/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.challenge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class ChallengesManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static ChallengesManager INSTANCE = new ChallengesManager();
    private Map<ResourceLocation, ChallengesData> challenges = new TreeMap<ResourceLocation, ChallengesData>();

    public ChallengesManager() {
        super(GSON, "challenges");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        this.challenges.clear();
        object.forEach((location, json) -> {
            AtomicReference<ChallengesData> challenge = new AtomicReference<ChallengesData>();
            challenge.set((ChallengesData)ChallengesData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow(err -> new IllegalStateException("There is an issue with (%s) challenge JSON file.\n".formatted(location.toString()) + err)));
            if (((ChallengesData)challenge.get()).getChallengeType() == ChallengesData.Type.INTERACT_WITH_BLOCK || ((ChallengesData)challenge.get()).getChallengeType() == ChallengesData.Type.INTERACT_WITH_BLOCK_CONSUME) {
                FTBUltimineAddition.LOGGER.warn("This challenge type ({}) you choose in ({}) isn't stable! You may have to change the type until a new update comes to fix it.", (Object)((ChallengesData)challenge.get()).getChallengeType().getTypeName(), (Object)location.toString());
            }
            this.challenges.put((ResourceLocation)location, (ChallengesData)challenge.get());
        });
    }

    public Map<ResourceLocation, ChallengesData> getRandomChallenges(int quantity, MiningSkillCardItem.Type type, MiningSkillCardItem.Tier tier) {
        if (quantity > this.challenges.values().stream().filter(data -> data.getForCardType().equals(type) && data.getForCardTier().isEligible(tier)).toList().size()) {
            String error = String.format("There aren't enough %s %s challenges for tier %s to add it to Mining Skill Card.", quantity, type.getId().toLowerCase(), tier.name().toLowerCase());
            throw new IllegalArgumentException(error);
        }
        HashMap<ResourceLocation, ChallengesData> randomValues = new HashMap<ResourceLocation, ChallengesData>();
        Random random = new Random();
        while (randomValues.size() < quantity) {
            int randomIndex = random.nextInt(this.challenges.size());
            ResourceLocation[] keys = this.challenges.keySet().toArray(new ResourceLocation[0]);
            ResourceLocation randomKey = keys[randomIndex];
            if (!this.challenges.get(randomKey).getForCardType().equals(type) || !this.challenges.get(randomKey).getForCardTier().isEligible(tier)) continue;
            randomValues.put(randomKey, this.challenges.get(randomKey));
        }
        if (((Boolean)ConfigHandler.SERVER.CHALLENGE_MANAGER_LOGGER.get()).booleanValue() || Platform.isDevelopmentEnvironment()) {
            FTBUltimineAddition.LOGGER.debug("/----------[Challenge Tracker]-----------/");
            FTBUltimineAddition.LOGGER.debug("| Added Challenges:");
            randomValues.forEach((location, data) -> FTBUltimineAddition.LOGGER.debug("|> ID: {}", location));
            FTBUltimineAddition.LOGGER.debug("/----------------------------------------/");
        }
        return randomValues;
    }

    public Map<ResourceLocation, ChallengesData> getAllChallenges() {
        return this.challenges;
    }

    public void validateAllChallenges() {
        ArrayList markedToRemove = new ArrayList();
        this.challenges.forEach((location, challengesData) -> {
            AtomicBoolean isValid = new AtomicBoolean();
            List<Block> blocks = this.utilizeTargetedBlocks((ChallengesData)challengesData);
            if (!blocks.isEmpty()) {
                isValid.set(true);
            }
            if (!isValid.get()) {
                markedToRemove.add(location);
                FTBUltimineAddition.LOGGER.error("There is no valid targeted blocks in ({}) challenge JSON file.", (Object)location.toString());
            }
        });
        if (markedToRemove.isEmpty()) {
            FTBUltimineAddition.LOGGER.info("Loaded {} challenges", (Object)this.challenges.size());
        } else {
            int oldSize = this.challenges.size();
            markedToRemove.forEach(this.challenges::remove);
            FTBUltimineAddition.LOGGER.info("Loaded {} from {} challenges", (Object)this.challenges.size(), (Object)oldSize);
        }
    }

    public List<Block> utilizeTargetedBlocks(ChallengesData data) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (data.getTargetedBlocks() == null) {
            return new ArrayList<Block>();
        }
        for (String value : data.getTargetedBlocks()) {
            if (value.startsWith("#")) {
                ArrayList blocks = new ArrayList();
                BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)value.replaceAll("#", "")))).ifPresent(holders -> blocks.addAll(holders.stream().map(Holder::value).toList()));
                if (blocks.isEmpty()) continue;
                list.addAll(blocks);
                continue;
            }
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)value));
            if (block == Blocks.AIR) continue;
            list.add(block);
        }
        return list;
    }

    public boolean isCorrectTool(Player player, ChallengesData challengesData) {
        if (challengesData.getForCardType().isCustomType()) {
            return ItemUtils.isItemInHandCustomCardValid(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.PICKAXE)) {
            return ItemUtils.isItemInHandPickaxe(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.AXE)) {
            return ItemUtils.isItemInHandAxe(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.SHOVEL)) {
            return ItemUtils.isItemInHandShovel(player);
        }
        if (challengesData.getForCardType().equals(MiningSkillCardItem.Type.HOE)) {
            return ItemUtils.isItemInHandHoe(player);
        }
        return false;
    }

    public void setChallenges(Map<ResourceLocation, ChallengesData> dataMap) {
        this.challenges = dataMap;
    }
}

