/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class CardTierArgument
implements ArgumentType<MiningSkillCardItem.Tier> {
    private static final Collection<String> EXAMPLES = Arrays.asList("novice", "adept");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_TIER = new DynamicCommandExceptionType(entry -> Component.translatable((String)"argument.ultimine_addition.cards.tier.unknown", (Object[])new Object[]{entry}));

    public static CardTierArgument tier() {
        return new CardTierArgument();
    }

    public static MiningSkillCardItem.Tier getTier(CommandContext<CommandSourceStack> pContext, String pName) {
        return (MiningSkillCardItem.Tier)((Object)pContext.getArgument(pName, MiningSkillCardItem.Tier.class));
    }

    public MiningSkillCardItem.Tier parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        MiningSkillCardItem.Tier tier = MiningSkillCardItem.Tier.fromString(input);
        if (tier != null) {
            return tier;
        }
        throw ERROR_UNKNOWN_TIER.create((Object)input);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        return SharedSuggestionProvider.suggest((String[])MiningSkillCardItem.Tier.getNames(), (SuggestionsBuilder)pBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

