/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ParserUtils;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class CardHolderArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("none", "skills_record.slot.1");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SLOT = new DynamicCommandExceptionType(slot -> Component.translatableEscape((String)"slot.unknown", (Object[])new Object[]{slot}));
    private final Collection<String> SLOTS = (Collection)Util.make(new ArrayList(), list -> {
        list.add("self");
        for (int slot : SkillsRecordMenu.CARD_SLOTS) {
            list.add("skills_record." + slot);
        }
    });

    public CardHolderArgument(boolean inInventory) {
        if (!inInventory) {
            this.SLOTS.remove("self");
        }
    }

    public static CardHolderArgument slot(boolean inInventory) {
        return new CardHolderArgument(inInventory);
    }

    public static Integer getSlot(CommandContext<CommandSourceStack> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        String string = ParserUtils.readWhile((StringReader)reader, c -> c != ' ');
        if (!this.SLOTS.contains(string)) {
            throw ERROR_UNKNOWN_SLOT.create((Object)string);
        }
        if (string.startsWith("skills_record.")) {
            try {
                return Integer.parseInt(string.substring("skills_record.".length()));
            }
            catch (NumberFormatException e) {
                throw ERROR_UNKNOWN_SLOT.create((Object)string);
            }
        }
        return -1;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(this.SLOTS, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

