/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import java.util.ArrayList;
import java.util.List;
import net.ixdarklord.ultimine_addition.common.command.arguments.UltimineShapeArgument;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;

public class UltimineShapeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ignored, Commands.CommandSelection ignored2) {
        FTBUltimineAddition.withCommandPrompt(dispatcher, 2, builder -> builder.then(Commands.literal((String)"ultimine_shape").then(((LiteralArgumentBuilder)Commands.literal((String)"blacklist").then(Commands.literal((String)"add").then(Commands.argument((String)"shape_id", (ArgumentType)UltimineShapeArgument.shape()).executes(context -> UltimineShapeCommand.updateBlacklistedShapes((CommandSourceStack)context.getSource(), UltimineShapeArgument.getShape((CommandContext<CommandSourceStack>)context, "shape_id"), true))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"shape_id", (ArgumentType)UltimineShapeArgument.shape()).executes(context -> UltimineShapeCommand.updateBlacklistedShapes((CommandSourceStack)context.getSource(), UltimineShapeArgument.getShape((CommandContext<CommandSourceStack>)context, "shape_id"), false)))))));
    }

    private static int updateBlacklistedShapes(CommandSourceStack source, Shape shape, boolean adding) {
        ModConfigSpec.ConfigValue<List<? extends String>> config = ConfigHandler.SERVER.BLACKLISTED_SHAPES;
        ArrayList shapeIds = Lists.newArrayList((Iterable)((Iterable)config.get()));
        if (adding) {
            if (shapeIds.contains(shape.getName().toString())) {
                source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.ultimine_shape.included", (Object[])new Object[]{shape.getName()}));
                return 0;
            }
            shapeIds.add(shape.getName().toString());
            config.set((Object)shapeIds);
            config.save();
            source.sendSuccess(() -> Component.translatable((String)"command.ultimine_addition.ultimine_shape.success.add", (Object[])new Object[]{shape.getName()}), true);
        } else {
            if (!shapeIds.contains(shape.getName().toString())) {
                source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.ultimine_shape.excluded", (Object[])new Object[]{shape.getName()}));
                return 0;
            }
            shapeIds.remove(shape.getName().toString());
            config.set((Object)shapeIds);
            config.save();
            source.sendSuccess(() -> Component.translatable((String)"command.ultimine_addition.ultimine_shape.success.remove", (Object[])new Object[]{shape.getName()}), true);
        }
        return 1;
    }
}

