/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.ixdarklord.coolcatlib.api.util.SlotReference;
import net.ixdarklord.ultimine_addition.common.command.arguments.CardHolderArgument;
import net.ixdarklord.ultimine_addition.common.command.arguments.CardTierArgument;
import net.ixdarklord.ultimine_addition.common.command.arguments.ChallengesArgument;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ignored, Commands.CommandSelection ignored2) {
        RequiredArgumentBuilder challengeArgument = (RequiredArgumentBuilder)Commands.argument((String)"challenge_id", (ArgumentType)ChallengesArgument.data()).then(Commands.literal((String)"in_inventory").then(Commands.argument((String)"slot_index", (ArgumentType)SlotArgument.slot()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"card_holder", (ArgumentType)CardHolderArgument.slot(true)).then(Commands.literal((String)"set_point").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CardsCommand.updateChallengeValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ChallengesArgument.getData((CommandContext<CommandSourceStack>)context, "challenge_id"), new CardLocation((CommandContext<CommandSourceStack>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))))).then(Commands.literal((String)"add_point").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CardsCommand.updateChallengeValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ChallengesArgument.getData((CommandContext<CommandSourceStack>)context, "challenge_id"), new CardLocation((CommandContext<CommandSourceStack>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false))))).then(Commands.literal((String)"accomplish").executes(context -> CardsCommand.updateChallengeValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ChallengesArgument.getData((CommandContext<CommandSourceStack>)context, "challenge_id"), new CardLocation((CommandContext<CommandSourceStack>)context), null, false))))));
        RequiredArgumentBuilder tierArgument = (RequiredArgumentBuilder)Commands.argument((String)"new_tier", (ArgumentType)CardTierArgument.tier()).then(Commands.literal((String)"in_inventory").then(Commands.argument((String)"slot_index", (ArgumentType)SlotArgument.slot()).then(Commands.argument((String)"card_holder", (ArgumentType)CardHolderArgument.slot(true)).executes(context -> CardsCommand.updateTierValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), CardTierArgument.getTier((CommandContext<CommandSourceStack>)context, "new_tier"), new CardLocation((CommandContext<CommandSourceStack>)context))))));
        if (ServicePlatform.get().slotAPI().isModLoaded()) {
            challengeArgument.then(Commands.literal((String)"in_%s".formatted(ServicePlatform.get().slotAPI().getAPIName())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"card_holder", (ArgumentType)CardHolderArgument.slot(false)).then(Commands.literal((String)"set_point").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CardsCommand.updateChallengeValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ChallengesArgument.getData((CommandContext<CommandSourceStack>)context, "challenge_id"), new CardLocation((CommandContext<CommandSourceStack>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))))).then(Commands.literal((String)"add_point").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CardsCommand.updateChallengeValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ChallengesArgument.getData((CommandContext<CommandSourceStack>)context, "challenge_id"), new CardLocation((CommandContext<CommandSourceStack>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false))))).then(Commands.literal((String)"accomplish").executes(context -> CardsCommand.updateChallengeValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ChallengesArgument.getData((CommandContext<CommandSourceStack>)context, "challenge_id"), new CardLocation((CommandContext<CommandSourceStack>)context), null, false)))));
            tierArgument.then(Commands.literal((String)"in_%s".formatted(ServicePlatform.get().slotAPI().getAPIName())).then(Commands.argument((String)"card_holder", (ArgumentType)CardHolderArgument.slot(false)).executes(context -> CardsCommand.updateTierValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), CardTierArgument.getTier((CommandContext<CommandSourceStack>)context, "new_tier"), new CardLocation((CommandContext<CommandSourceStack>)context)))));
        }
        FTBUltimineAddition.withCommandPrompt(dispatcher, 2, builder -> builder.then(((LiteralArgumentBuilder)Commands.literal((String)"mining_skill_card").then(Commands.literal((String)"challenges").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then((ArgumentBuilder)challengeArgument)))).then(Commands.literal((String)"change_tier").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then((ArgumentBuilder)tierArgument)))));
    }

    private static int updateChallengeValue(CommandSourceStack source, @NotNull Collection<ServerPlayer> targets, Pair<ResourceLocation, ChallengesData> cData, CardLocation cardLocation, @Nullable Integer amount, Boolean replaceValue) {
        int i;
        block15: {
            i = 0;
            try {
                for (ServerPlayer player : targets) {
                    Integer newPoints;
                    ResourceLocation challengeId;
                    MiningSkillCardData cardData;
                    MiningSkillCardData.ChallengeHolder challengeHolder;
                    Optional<SlotReference.Player> cardOrHolder = CardsCommand.getCardOrRecord(player, cardLocation);
                    if (cardOrHolder.isEmpty()) {
                        source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.cards.not_found").withStyle(ChatFormatting.RED));
                        continue;
                    }
                    ItemStack mainStack = cardOrHolder.get().getItem();
                    ItemStack cardStack = mainStack.copy();
                    SkillsRecordData recordData = null;
                    if (!(mainStack.getItem() instanceof MiningSkillCardItem)) {
                        recordData = SkillsRecordData.loadData(mainStack);
                        cardStack = (ItemStack)recordData.getCardSlots().get(cardLocation.cardHolder);
                    }
                    if ((challengeHolder = (MiningSkillCardData.ChallengeHolder)(cardData = MiningSkillCardData.loadData(cardStack)).getChallenge(challengeId = (ResourceLocation)cData.getFirst()).orElse(null)) == null) {
                        source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.challenge.not_found", (Object[])new Object[]{((ResourceLocation)cData.getFirst()).toString()}));
                        return i;
                    }
                    int oldPoints = challengeHolder.getCurrentPoints();
                    Integer n = amount == null ? null : (newPoints = Integer.valueOf(replaceValue != false ? amount : oldPoints + amount));
                    if (!cardData.isChallengeAccomplished(challengeId) || replaceValue.booleanValue()) {
                        if (newPoints != null) {
                            cardData.setAmount(challengeId, newPoints);
                        } else {
                            cardData.accomplishChallenge(challengeId);
                        }
                        cardData.saveData(cardStack);
                        if (recordData == null) {
                            cardData.sendToClient(player, cardLocation.inventoryIndex).saveData(cardStack);
                        } else {
                            recordData.sendToClient(player, cardLocation.inventoryIndex).saveData(mainStack);
                        }
                        ++i;
                    } else {
                        source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.challenge.accomplished", (Object[])new Object[]{((ResourceLocation)cData.getFirst()).toString()}).withStyle(ChatFormatting.RED));
                        continue;
                    }
                    if (player == source.getPlayer()) {
                        source.sendSuccess(() -> Component.translatable((String)"command.ultimine_addition.challenge.success", (Object[])new Object[]{((ResourceLocation)cData.getFirst()).toString(), oldPoints, newPoints}).withStyle(ChatFormatting.DARK_AQUA), true);
                    }
                    if (i > 1 && player != source.getPlayer() && !player.hasPermissions(2)) {
                        player.displayClientMessage((Component)Component.translatable((String)"command.ultimine_addition.challenge.receiver", (Object[])new Object[]{((ResourceLocation)cData.getFirst()).toString(), oldPoints, newPoints, Objects.requireNonNull(source.getPlayer()).getName().getString()}).withStyle(ChatFormatting.GRAY), false);
                    }
                    if (i <= 1) continue;
                    source.sendSuccess(() -> Component.translatable((String)"command.ultimine_addition.challenge.sender", (Object[])new Object[]{((ResourceLocation)cData.getFirst()).toString(), oldPoints, newPoints}).withStyle(ChatFormatting.GRAY), true);
                    int x = 1;
                    for (ServerPlayer p : targets) {
                        if (p == source.getPlayer()) continue;
                        int finalX = x++;
                        source.sendSuccess(() -> Component.literal((String)(finalX + ": " + p.getName().getString())).withStyle(ChatFormatting.YELLOW), true);
                    }
                }
            }
            catch (Exception err) {
                if (!Platform.isDevelopmentEnvironment()) break block15;
                FTBUltimineAddition.LOGGER.error("Error occurred while executing the command!", (Throwable)err);
            }
        }
        return i;
    }

    private static int updateTierValue(CommandSourceStack source, @NotNull Collection<ServerPlayer> targets, MiningSkillCardItem.Tier tier, CardLocation cardLocation) {
        int i;
        block12: {
            i = 0;
            try {
                for (ServerPlayer player : targets) {
                    MiningSkillCardData cardData;
                    Optional<SlotReference.Player> cardOrHolder = CardsCommand.getCardOrRecord(player, cardLocation);
                    if (cardOrHolder.isEmpty()) {
                        source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.cards.not_found").withStyle(ChatFormatting.RED));
                        return i;
                    }
                    ItemStack mainStack = cardOrHolder.get().getItem();
                    ItemStack cardStack = mainStack.copy();
                    SkillsRecordData recordData = null;
                    if (!(mainStack.getItem() instanceof MiningSkillCardItem)) {
                        recordData = SkillsRecordData.loadData(mainStack);
                        cardStack = (ItemStack)recordData.getCardSlots().get(cardLocation.cardHolder);
                    }
                    if ((cardData = MiningSkillCardData.loadData(cardStack)).getTier() != tier) {
                        cardData.setTier(tier).initChallenges();
                        if (recordData == null) {
                            cardData.sendToClient(player, cardLocation.inventoryIndex).saveData(cardStack);
                        } else {
                            recordData.sendToClient(player, cardLocation.inventoryIndex).saveData(mainStack);
                        }
                        ++i;
                    } else {
                        source.sendFailure((Component)Component.translatable((String)"command.ultimine_addition.cards.tier.set.already_setted", (Object[])new Object[]{((ItemStack)cardData.get()).getHoverName().getString().toLowerCase(), tier.name()}).withStyle(ChatFormatting.RED));
                        continue;
                    }
                    if (player == source.getPlayer()) {
                        source.sendSuccess(() -> Component.translatable((String)"command.ultimine_addition.cards.tier.set.success", (Object[])new Object[]{((ItemStack)cardData.get()).getHoverName(), tier.name()}).withStyle(ChatFormatting.DARK_AQUA), true);
                    }
                    if (i > 1 && player != source.getPlayer() && !player.hasPermissions(2)) {
                        player.displayClientMessage((Component)Component.translatable((String)"command.ultimine_addition.cards.tier.set.receiver", (Object[])new Object[]{((ItemStack)cardData.get()).getHoverName(), tier.name(), Objects.requireNonNull(source.getPlayer()).getName().getString()}).withStyle(ChatFormatting.GRAY), false);
                    }
                    if (i <= 1) continue;
                    source.sendSuccess(() -> Component.translatable((String)"command.ultimine_addition.cards.tier.set.sender", (Object[])new Object[]{((ItemStack)cardData.get()).getHoverName(), tier.name()}).withStyle(ChatFormatting.GRAY), true);
                    int x = 1;
                    for (ServerPlayer p : targets) {
                        if (p == source.getPlayer()) continue;
                        int finalX = x++;
                        source.sendSuccess(() -> Component.literal((String)(finalX + ": " + p.getName().getString())).withStyle(ChatFormatting.YELLOW), true);
                    }
                }
            }
            catch (Exception err) {
                if (!Platform.isDevelopmentEnvironment()) break block12;
                FTBUltimineAddition.LOGGER.error("Error occurred!", (Throwable)err);
            }
        }
        return i;
    }

    private static Optional<SlotReference.Player> getCardOrRecord(ServerPlayer player, CardLocation location) {
        return ItemUtils.getSlotReferences((Player)player, stack -> {
            MiningSkillCardItem cardItem;
            Item patt0$temp;
            return location.isCardInsideSkillsRecord() ? stack.getItem() instanceof SkillsRecordItem : (patt0$temp = stack.getItem()) instanceof MiningSkillCardItem && (cardItem = (MiningSkillCardItem)patt0$temp).getType() != MiningSkillCardItem.Type.EMPTY;
        }, false).stream().filter(slot -> slot.getIndex() == location.inventoryIndex).findAny();
    }

    private static class CardLocation {
        public final int inventoryIndex = (Integer)Util.make(() -> {
            try {
                return SlotArgument.getSlot((CommandContext)context, (String)"slot_index");
            }
            catch (Exception ignored) {
                return -1;
            }
        });
        public final int cardHolder = (Integer)Util.make(() -> {
            try {
                return CardHolderArgument.getSlot(context, "card_holder");
            }
            catch (Exception ignored) {
                return -1;
            }
        });

        private CardLocation(CommandContext<CommandSourceStack> context) {
        }

        public boolean isCardInsideSkillsRecord() {
            return this.cardHolder > -1;
        }
    }
}

