/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.renderer.item;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.ixdarklord.coolcatlib.api.util.MathUtils;
import net.ixdarklord.ultimine_addition.client.handler.ModelHandler;
import net.ixdarklord.ultimine_addition.client.renderer.item.UAItemRenderer;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MiningSkillCardItemRenderer
extends UAItemRenderer {
    @Override
    public void render(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        MiningSkillCardData data = MiningSkillCardData.loadData(stack);
        ModelResourceLocation modelLocation = switch (data.getTier()) {
            default -> throw new MatchException(null, null);
            case MiningSkillCardItem.Tier.Unlearned -> ModelHandler.UNLEARNED_ID;
            case MiningSkillCardItem.Tier.Novice -> ModelHandler.TIER_1_ID;
            case MiningSkillCardItem.Tier.Apprentice -> ModelHandler.TIER_2_ID;
            case MiningSkillCardItem.Tier.Adept -> ModelHandler.TIER_3_ID;
            case MiningSkillCardItem.Tier.Mastered -> ModelHandler.MASTERED_ID;
        };
        BakedModel base = renderer.getItemModelShaper().getModelManager().getModel(modelLocation);
        poseStack.pushPose();
        if (displayContext == ItemDisplayContext.FIXED) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            float scale = 1.0f;
            poseStack.scale(scale, scale, scale);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        } else if (displayContext == ItemDisplayContext.GUI) {
            float scale = 1.0f;
            poseStack.scale(scale, scale, scale);
        } else if (displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.HEAD) {
            poseStack.translate(1.0f, 1.0f, 0.0f);
            float scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-1.5f, -0.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else {
            poseStack.translate(1.0f, 1.0f, 0.0f);
            float scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-1.5f, -1.0f, 0.5f);
        }
        renderer.renderModelLists(base, stack, light, overlay, poseStack, ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true), (boolean)true, (boolean)false));
        bufferSource.endBatch();
        poseStack.popPose();
        if (stack.getItem() instanceof MiningSkillCardItem) {
            this.renderDisplayItem(stack, displayContext, poseStack, bufferSource, light, overlay);
        }
    }

    private void renderDisplayItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int light, int overlay) {
        int tickCount = Objects.requireNonNull(Minecraft.getInstance().player).tickCount;
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        MiningSkillCardData data = MiningSkillCardData.loadData(stack);
        poseStack.pushPose();
        if (transformType == ItemDisplayContext.FIXED) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-0.1f, 0.2f, -0.58f);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        } else if (transformType == ItemDisplayContext.GUI) {
            scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(0.1f, 0.2f, 0.58f);
        } else if (transformType == ItemDisplayContext.HEAD) {
            poseStack.translate(1.0f, 1.0f, 0.0f);
            scale = 1.0f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-0.5f, -0.5f, 0.5f);
        } else if (transformType == ItemDisplayContext.GROUND) {
            poseStack.translate(1.0f, 1.0f, 0.0f);
            scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-1.5f, -0.75f, 0.5f);
        } else {
            poseStack.translate(1.0f, 1.0f, 0.0f);
            scale = 0.25f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-2.9f, -1.8f, 1.56f);
        }
        if (transformType != ItemDisplayContext.GUI) {
            float animScale = MathUtils.cycledBetweenValues((float)0.95f, (float)1.0f, (float)0.8f, (float)((float)tickCount / 20.0f), (boolean)false);
            poseStack.scale(animScale, animScale, animScale);
        }
        BakedModel base = renderer.getItemModelShaper().getItemModel(data.getDisplayItem());
        renderer.renderModelLists(base, data.getDisplayItem(), light, overlay, poseStack, ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true), (boolean)true, (boolean)false));
        bufferSource.endBatch();
        poseStack.popPose();
    }
}

