/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import net.ixdarklord.ultimine_addition.client.gui.components.ChallengesInfoPanel;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.client.gui.tooltip.SkillsRecordTooltip;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSkillsRecordTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/background");
    private final NonNullList<ItemStack> items;

    public ClientSkillsRecordTooltip(SkillsRecordTooltip skillsRecordTooltip) {
        this.items = skillsRecordTooltip.getItems();
    }

    public int getHeight() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int getWidth(Font font) {
        return this.gridSizeX() * 18 + 2;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        guiGraphics.blitSprite(BACKGROUND_SPRITE, x, y, this.backgroundWidth(), this.backgroundHeight());
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int m = 0; m < i; ++m) {
                int n = x + m * 18 + 1;
                int o = y + l * 20 + 1;
                this.renderSlot(n, o, k++, guiGraphics, font);
            }
        }
    }

    private void renderSlot(int x, int y, int itemIndex, GuiGraphics guiGraphics, Font font) {
        if (itemIndex >= this.items.size()) {
            this.blit(guiGraphics, x, y);
        } else {
            ItemStack itemStack = (ItemStack)this.items.get(itemIndex);
            this.blit(guiGraphics, x, y);
            guiGraphics.renderItem(itemStack, x + 1, y + 1, itemIndex);
            guiGraphics.renderItemDecorations(font, itemStack, x + 1, y + 1);
        }
    }

    private void blit(GuiGraphics guiGraphics, int x, int y) {
        SkillsRecordScreen.OverlayColor overlayColor = (SkillsRecordScreen.OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
        RenderSystem.setShaderColor((float)overlayColor.getRed(), (float)overlayColor.getGreen(), (float)overlayColor.getBlue(), (float)overlayColor.getAlpha());
        guiGraphics.blitSprite(Texture.SLOT.sprite, x, y, 0, Texture.SLOT.w, Texture.SLOT.h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 20 + 2;
    }

    private int gridSizeX() {
        return this.items.size();
    }

    private int gridSizeY() {
        return 1;
    }

    private static enum Texture {
        SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/slot"), 18, 20);

        public final ResourceLocation sprite;
        public final int w;
        public final int h;

        private Texture(ResourceLocation sprite, int w, int h) {
            this.sprite = sprite;
            this.w = w;
            this.h = h;
        }
    }

    public static class Option
    implements ClientTooltipComponent {
        private final int buttonId;
        private final Component textComponent;

        public Option(SkillsRecordTooltip.Option option) {
            this.buttonId = option.buttonId();
            this.textComponent = option.textComponent();
        }

        public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
            switch (this.buttonId) {
                case 0: {
                    this.renderBGColors(font, x, y, guiGraphics);
                    break;
                }
                case 1: {
                    this.renderPanelPos(font, x, y, guiGraphics);
                }
            }
        }

        private void renderBGColors(Font font, int x, int y, GuiGraphics guiGraphics) {
            int gridSize = 3;
            int cellSpacing = 2;
            int cellWidth = (this.getWidth(font) - gridSize * cellSpacing) / gridSize;
            int cellHeight = (this.getHeight() - gridSize * cellSpacing) / gridSize;
            SkillsRecordScreen.OverlayColor[] colors = SkillsRecordScreen.OverlayColor.values();
            int colorIndex = 0;
            for (int row = 0; row < gridSize; ++row) {
                for (int col = 0; col < gridSize; ++col) {
                    int adjuster = 2 + Math.max(0, font.width((FormattedText)this.textComponent) - this.getWidth(font)) / 2;
                    int minX = x + col * (cellWidth + cellSpacing) + adjuster;
                    int minY = y + row * (cellHeight + cellSpacing);
                    int maxX = minX + cellWidth;
                    int maxY = minY + cellHeight;
                    colorIndex = row * gridSize + col;
                    guiGraphics.fill(minX, minY, maxX, maxY, colors[colorIndex].convert().getRGB());
                    ResourceLocation CONFIRM_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/confirm");
                    int textureX = minX + (cellWidth - 18) / 2;
                    int textureY = minY + (cellHeight - 18) / 2;
                    if (colorIndex == ((SkillsRecordScreen.OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get())).ordinal()) {
                        guiGraphics.blitSprite(CONFIRM_SPRITE, textureX + 1, textureY, 18, 18);
                    }
                    if (colorIndex >= colors.length - 1) break;
                }
                if (colorIndex >= colors.length - 1) break;
            }
        }

        private void renderPanelPos(Font font, int x, int y, GuiGraphics guiGraphics) {
            int gridSize = 3;
            int cellSpacing = 2;
            int cellWidth = (this.getWidth(font) - gridSize * cellSpacing) / gridSize;
            int cellHeight = (this.getHeight() - gridSize * cellSpacing) / gridSize;
            int[] disabledPositions = new int[]{1, 4, 7};
            for (int row = 0; row < gridSize; ++row) {
                for (int col = 0; col < gridSize; ++col) {
                    int directionIndex;
                    Color color;
                    int adjuster = 2 + Math.max(0, font.width((FormattedText)this.textComponent) - this.getWidth(font)) / 2;
                    int minX = x + col * (cellWidth + cellSpacing) + adjuster;
                    int minY = y + row * (cellHeight + cellSpacing);
                    int maxX = minX + cellWidth;
                    int maxY = minY + cellHeight;
                    int selectedDirection = ((ChallengesInfoPanel.Panel.Position)((Object)ConfigHandler.CLIENT.CHALLENGES_PANEL_POSITION.get())).getPosIndex();
                    Color color2 = color = selectedDirection == (directionIndex = row * gridSize + col) ? Color.GREEN : Color.GRAY;
                    if (Arrays.stream(disabledPositions).anyMatch(value -> value == directionIndex)) {
                        color = Color.DARK_GRAY.darker();
                    }
                    guiGraphics.fill(minX, minY, maxX, maxY, color.getRGB());
                    ResourceLocation CONFIRM_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/confirm");
                    ResourceLocation CANCEL_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/cancel");
                    int textureX = minX + (cellWidth - 18) / 2;
                    int textureY = minY + (cellHeight - 18) / 2;
                    if (directionIndex == selectedDirection) {
                        guiGraphics.blitSprite(CONFIRM_SPRITE, textureX + 1, textureY, 18, 18);
                    }
                    if (directionIndex != 4 || selectedDirection != ChallengesInfoPanel.Panel.Position.DISABLED.getPosIndex()) continue;
                    guiGraphics.blitSprite(CANCEL_SPRITE, textureX + 1, textureY, 18, 18);
                }
            }
        }

        public int getHeight() {
            return 64;
        }

        public int getWidth(Font font) {
            return 64 + Math.max(0, font.width((FormattedText)this.textComponent) - 64);
        }
    }
}

