/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.toasts;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class ChallengesToast
extends SimpleToast {
    private final Component title;
    private final Component desc;
    private final Icon icon;
    private final SoundInstance sound;

    public static void run(MiningSkillCardData.ChallengeHolder challengeHolder, ItemStack stack) {
        Minecraft.getInstance().getToasts().addToast((Toast)new ChallengesToast(challengeHolder, stack));
    }

    public ChallengesToast(MiningSkillCardData.ChallengeHolder challengeIdentifier, ItemStack stack) {
        this.icon = ItemIcon.getItemIcon((ItemStack)stack);
        if (challengeIdentifier.getId().equals((Object)ResourceLocation.parse((String)"completed"))) {
            this.title = Component.translatable((String)"toast.ultimine_addition.challenge.all_completed");
            this.desc = Component.translatable((String)"toast.ultimine_addition.challenge.all_completed.info", (Object[])new Object[]{stack.getHoverName()});
            this.sound = SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, (float)1.0f, (float)1.0f);
        } else {
            this.title = Component.translatable((String)"toast.ultimine_addition.challenge.completed");
            this.desc = Component.translatable((String)"toast.ultimine_addition.challenge.completed.info", (Object[])new Object[]{challengeIdentifier.getOrder(), stack.getHoverName()});
            this.sound = SimpleSoundInstance.forUI((SoundEvent)SoundEvents.PLAYER_LEVELUP, (float)1.0f, (float)1.0f);
        }
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getSubtitle() {
        return this.desc;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void playSound(SoundManager handler) {
        handler.play(this.sound);
    }
}

