/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.screens;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.ixdarklord.coolcatlib.api.client.gui.components.ColorableImageButton;
import net.ixdarklord.coolcatlib.api.client.gui.components.TextScreen;
import net.ixdarklord.coolcatlib.api.client.gui.components.widgets.AbstractDraggableWidget;
import net.ixdarklord.coolcatlib.api.util.ColorUtils;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.coolcatlib.api.util.MathUtils;
import net.ixdarklord.coolcatlib.api.util.MouseHelper;
import net.ixdarklord.coolcatlib.api.util.RenderUtils;
import net.ixdarklord.ultimine_addition.client.gui.components.ChallengesInfoPanel;
import net.ixdarklord.ultimine_addition.client.gui.components.ConfigurationPanel;
import net.ixdarklord.ultimine_addition.client.gui.screens.EditChallengeScreen;
import net.ixdarklord.ultimine_addition.client.gui.tooltip.SkillsRecordTooltip;
import net.ixdarklord.ultimine_addition.client.handler.KeyHandler;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.common.menu.slot.CustomSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.MiningSkillCardSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PaperSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PenSlot;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.hooks.KeyBindingHooks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillsRecordScreen
extends AbstractContainerScreen<SkillsRecordMenu> {
    public static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(FTBUltimineAddition.rl("container/skills_record/button"), FTBUltimineAddition.rl("container/skills_record/button_disabled"), FTBUltimineAddition.rl("container/skills_record/button_focused"));
    private static final ResourceLocation BACKGROUND_TEXTURE = FTBUltimineAddition.getGuiTexture("container/skills_record", "png");
    private static final ResourceLocation SLOT_SELECT_SPRITE = FTBUltimineAddition.rl("container/skills_record/slot_select");
    private static final ResourceLocation PROGRESS_BAR_SPRITE = FTBUltimineAddition.rl("container/skills_record/progress_bar");
    private static final ResourceLocation ITEM_DISPLAY_SPRITE = FTBUltimineAddition.rl("container/skills_record/item_display");
    public static final WidgetSprites CONFIGURATION_BUTTON_SPRITES = new WidgetSprites(FTBUltimineAddition.rl("container/skills_record/configuration_button_enabled"), FTBUltimineAddition.rl("container/skills_record/configuration_button_disabled"), FTBUltimineAddition.rl("container/skills_record/configuration_button_focused"));
    private static final WidgetSprites CONSUME_BUTTON_SPRITES = new WidgetSprites(FTBUltimineAddition.rl("container/skills_record/consume_on"), FTBUltimineAddition.rl("container/skills_record/consume_off"), FTBUltimineAddition.rl("container/skills_record/consume_on_focused"), FTBUltimineAddition.rl("container/skills_record/consume_off_focused"));
    private static final WidgetSprites SCROLLBAR_SPRITE = new WidgetSprites(FTBUltimineAddition.rl("container/skills_record/scroller_enabled"), FTBUltimineAddition.rl("container/skills_record/scroller_disabled"), FTBUltimineAddition.rl("container/skills_record/scroller_focused"));
    private final int maxProgress = 100;
    private ColorableImageButton configurationButton;
    private StateSwitchingButton consumeButton;
    public ConfigurationPanel configuration;
    private TextScreen textScreen;
    private OverlayColor backgroundColor;
    private boolean isAnimationsEnabled;
    private int progressMode;
    private static float itemCycle;
    public int selectedSlot;
    private boolean isChallengesExists;
    private boolean isMissingItems;
    private boolean notEnoughInk;
    private int currentProgress;
    private boolean isScrolling;
    private boolean isProgressionBarShown;
    private boolean lock;

    public SkillsRecordScreen(SkillsRecordMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 192;
        this.imageHeight = 224;
    }

    public SkillsRecordScreen lock(boolean lock) {
        this.lock = lock;
        return this;
    }

    public void init() {
        super.init();
        this.titleLabelX = 8;
        this.titleLabelY = 5;
        this.inventoryLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.playerInventoryTitle) / 2;
        this.inventoryLabelY = this.imageHeight - 96;
        this.createButtons();
        this.selectedSlot = ((SkillsRecordMenu)this.menu).getData().getSelectedCard();
        this.textScreen = TextScreen.build((int)(this.leftPos + 10), (int)(this.topPos + 17), (int)157, (int)82, (boolean)((Boolean)ConfigHandler.CLIENT.TEXT_SCREEN_SHADOW.get()), (int)2);
        this.backgroundColor = (OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
        this.isAnimationsEnabled = (Boolean)ConfigHandler.CLIENT.ANIMATIONS_MODE.get();
        this.progressMode = (Integer)ConfigHandler.CLIENT.PROGRESS_BAR.get();
        boolean visibility = this.configuration != null && this.configuration.isVisible();
        this.configuration = (ConfigurationPanel)this.addWidget((GuiEventListener)new ConfigurationPanel(this.leftPos + 194, this.topPos));
        this.configuration.setVisible(visibility);
        this.configuration.addButton(button -> {
            this.backgroundColor = !Screen.hasShiftDown() ? this.backgroundColor.next() : this.backgroundColor.previous();
            this.saveValuesToConfig();
        }, (Component)Component.translatable((String)"gui.ultimine_addition.skills_record.option.bg_color"), tooltipInfo -> {
            int color = ColorUtils.RGBToRGBA((int)this.backgroundColor.convert().getRGB(), (float)this.backgroundColor.getAlpha());
            tooltipInfo.component = Component.translatable((String)String.format("gui.ultimine_addition.color.%s", this.backgroundColor.name().toLowerCase())).withStyle(Style.EMPTY.withColor(color));
            tooltipInfo.tooltipComponent = new SkillsRecordTooltip.Option(0, tooltipInfo.component);
        });
        this.configuration.addButton(button -> {
            this.isAnimationsEnabled ^= true;
            this.saveValuesToConfig();
        }, (Component)Component.translatable((String)"gui.ultimine_addition.skills_record.option.animations"), tooltipInfo -> {
            tooltipInfo.component = this.isAnimationsEnabled ? Component.translatable((String)"options.on").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"options.off").withStyle(ChatFormatting.RED);
        });
        this.configuration.addButton(button -> {
            this.progressMode = this.progressMode >= 2 ? 0 : this.progressMode + 1;
            this.saveValuesToConfig();
        }, (Component)Component.translatable((String)"gui.ultimine_addition.skills_record.option.progression_bar"), tooltipInfo -> {
            switch (this.progressMode) {
                case 0: {
                    tooltipInfo.component = Component.translatable((String)"options.on").withStyle(ChatFormatting.GREEN);
                    break;
                }
                case 1: {
                    tooltipInfo.component = Component.translatable((String)"gui.ultimine_addition.skills_record.option.hold_keybind", (Object[])new Object[]{KeyHandler.KEY_SHOW_PROGRESSION_BAR.getTranslatedKeyMessage()}).withStyle(ChatFormatting.AQUA);
                    break;
                }
                case 2: {
                    tooltipInfo.component = Component.translatable((String)"options.off").withStyle(ChatFormatting.RED);
                }
            }
        });
        this.configuration.addButton(button -> {
            if (!Screen.hasShiftDown()) {
                ChallengesInfoPanel.INSTANCE.setPanelPos(ChallengesInfoPanel.INSTANCE.getPanelPos().next());
            } else {
                ChallengesInfoPanel.INSTANCE.setPanelPos(ChallengesInfoPanel.INSTANCE.getPanelPos().previous());
            }
            this.saveValuesToConfig();
        }, (Component)Component.translatable((String)"gui.ultimine_addition.skills_record.option.panel_pos"), tooltipInfo -> {
            ChatFormatting color = ChallengesInfoPanel.INSTANCE.getPanelPos().getSerializedName().equals("disabled") ? ChatFormatting.RED : ChatFormatting.WHITE;
            tooltipInfo.component = Component.translatable((String)"gui.ultimine_addition.skills_record.option.panel_pos.%s".formatted(ChallengesInfoPanel.INSTANCE.getPanelPos().getSerializedName())).withStyle(color);
            tooltipInfo.tooltipComponent = new SkillsRecordTooltip.Option(1, tooltipInfo.component);
        });
    }

    public void saveValuesToConfig() {
        ConfigHandler.CLIENT.BACKGROUND_COLOR.set((Object)this.backgroundColor);
        ConfigHandler.CLIENT.ANIMATIONS_MODE.set((Object)this.isAnimationsEnabled);
        ConfigHandler.CLIENT.PROGRESS_BAR.set((Object)this.progressMode);
        ConfigHandler.CLIENT.CHALLENGES_PANEL_POSITION.set((Object)ChallengesInfoPanel.INSTANCE.getPanelPos());
    }

    public void clearWidgets() {
        super.clearWidgets();
    }

    private void createButtons() {
        this.configurationButton = (ColorableImageButton)this.addRenderableWidget((GuiEventListener)new ColorableImageButton(this.leftPos + 174, this.topPos + 4, 10, 10, CONFIGURATION_BUTTON_SPRITES, button -> {
            this.configuration.toggleVisibility(true);
            this.saveValuesToConfig();
        }));
        this.consumeButton = (StateSwitchingButton)this.addRenderableWidget((GuiEventListener)new StateSwitchingButton(this.leftPos + 174, this.topPos + 106, 10, 18, ((SkillsRecordMenu)this.menu).getData().isConsumeMode()){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.sprites = CONSUME_BUTTON_SPRITES;
                guiGraphics.setColor(SkillsRecordScreen.this.backgroundColor.getRed(), SkillsRecordScreen.this.backgroundColor.getGreen(), SkillsRecordScreen.this.backgroundColor.getBlue(), SkillsRecordScreen.this.backgroundColor.getAlpha());
                RenderSystem.disableDepthTest();
                guiGraphics.blitSprite(this.sprites.get(!SkillsRecordScreen.this.lock && this.isStateTriggered, !SkillsRecordScreen.this.lock && this.active && this.isHoveredOrFocused()), this.getX(), this.getY(), this.width, this.height);
                RenderSystem.enableDepthTest();
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                double value = SkillsRecordScreen.this.isAnimationsEnabled ? (double)MathUtils.cycledBetweenValues((float)0.5f, (float)1.0f, (float)0.75f, (float)((float)((SkillsRecordMenu)((SkillsRecordScreen)SkillsRecordScreen.this).menu).getPlayer().tickCount / 20.0f), (boolean)false) : 1.0;
                Color cTo = this.isStateTriggered ? new Color(2337827) : new Color(0xA82222);
                Color cFrom = this.isStateTriggered ? ColorUtils.blendColors((Color)new Color(0x37FF37), (Color)cTo, (double)value) : ColorUtils.blendColors((Color)new Color(0xFF3737), (Color)cTo, (double)value);
                Color color1 = this.isStateTriggered ? cFrom : cTo;
                Color color2 = this.isStateTriggered ? cTo : cFrom;
                guiGraphics.fillGradient(this.getX() + 1, this.getY() + (this.isStateTriggered ? 1 : 9), this.getX() + 9, this.getY() + (this.isStateTriggered ? 9 : 17), color1.getRGB(), color2.getRGB());
                if (this.isActive() && this.isHovered()) {
                    MutableComponent state = ((SkillsRecordMenu)SkillsRecordScreen.this.menu).getData().isConsumeMode() ? Component.translatable((String)"options.on").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"options.off").withStyle(ChatFormatting.RED);
                    MutableComponent info = Component.literal((String)"\u27a4 ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.consume", (Object[])new Object[]{state}).withStyle(ChatFormatting.WHITE));
                    guiGraphics.renderTooltip(SkillsRecordScreen.this.font, (Component)info, mouseX, mouseY);
                }
            }

            public void onClick(double mouseX, double mouseY) {
                if (!SkillsRecordScreen.this.configuration.isVisible() && SkillsRecordScreen.this.isConsumeChallengeExists()) {
                    SkillsRecordMenu menu = (SkillsRecordMenu)SkillsRecordScreen.this.menu;
                    SkillsRecordData data = menu.getData();
                    data.toggleConsumeMode().sendToServer(menu.interactionHand).saveData((ItemStack)data.get());
                }
            }
        });
    }

    public void update() {
        DataHandler data;
        this.currentProgress = 0;
        if (this.selectedSlot > -1 && ((Slot)((SkillsRecordMenu)this.menu).getCardSlots().get(this.selectedSlot)).getItem() == ItemStack.EMPTY) {
            this.selectedSlot = -1;
            data = ((SkillsRecordMenu)this.menu).getData();
            ((SkillsRecordData)data).setSelectedCard(this.selectedSlot).sendToServer(((SkillsRecordMenu)this.menu).interactionHand).saveData((ItemStack)data.get());
        }
        data = MiningSkillCardData.loadData(this.selectedSlot > -1 ? ((Slot)((SkillsRecordMenu)this.menu).getCardSlots().get(this.selectedSlot)).getItem() : ItemStack.EMPTY);
        boolean isCardTierMastered = ((MiningSkillCardData)data).getTier() == MiningSkillCardItem.Tier.Mastered;
        this.isChallengesExists = !((MiningSkillCardData)data).getChallenges().isEmpty();
        boolean hasCorrectGamemode = !((SkillsRecordMenu)this.menu).getPlayer().isCreative() && !((SkillsRecordMenu)this.menu).getPlayer().isSpectator();
        this.isMissingItems = hasCorrectGamemode && (!((Slot)((SkillsRecordMenu)this.menu).getAllSlots().get(4)).hasItem() || !((Slot)((SkillsRecordMenu)this.menu).getAllSlots().get(5)).hasItem());
        boolean bl = this.notEnoughInk = hasCorrectGamemode && this.selectedSlot > -1 && ((SkillsRecordMenu)this.menu).getInkAmount() == 0;
        if (this.lock || this.configuration.isVisible()) {
            this.isProgressionBarShown = false;
            ((SkillsRecordMenu)this.menu).getAllSlots().forEach(slot -> ((CustomSlot)((Object)slot)).setEnabled(false));
        } else {
            if (this.isChallengesExists && !this.isMissingItems && !this.notEnoughInk && this.progressMode == 0) {
                this.isProgressionBarShown = true;
            } else if (this.selectedSlot == -1 || isCardTierMastered) {
                this.isProgressionBarShown = false;
            }
            ((SkillsRecordMenu)this.menu).getAllSlots().forEach(slot -> ((CustomSlot)((Object)slot)).setEnabled(true));
        }
        this.textScreen.clear();
        this.textScreen.setHeight(82 - (this.isProgressionBarShown ? 9 : 0), true);
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)child;
            widget.active = !this.lock;
        }
        if (this.configurationButton != null) {
            this.configurationButton.setColor(this.backgroundColor.color);
        }
        if (this.consumeButton != null) {
            if (this.consumeButton.active) {
                this.consumeButton.active = !this.configuration.isVisible();
            }
            this.consumeButton.setStateTriggered(((SkillsRecordMenu)this.menu).getData().isConsumeMode());
            if (this.consumeButton.isFocused()) {
                this.consumeButton.setFocused(false);
            }
        }
    }

    public void onClose() {
        this.saveValuesToConfig();
        super.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.update();
        this.renderGhostItem(guiGraphics, this.leftPos, this.topPos);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderSlotDecorations(guiGraphics, this.leftPos, this.topPos);
        this.renderTextBox(guiGraphics);
        this.renderScroll(guiGraphics, this.leftPos, this.topPos, mouseX, mouseY);
        this.renderProgressBar(guiGraphics, this.leftPos, this.topPos, mouseX, mouseY);
        this.renderTextBoxComponent(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!this.configuration.isVisible() && this.configurationButton.isHovered()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"\u27a4 ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.configuration").withStyle(ChatFormatting.WHITE)), mouseX, mouseY);
        }
        this.configuration.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.setColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha());
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Color color = ColorUtils.blendColors((Color)new Color(0, 0, 0), (Color)this.backgroundColor.color, (double)0.75);
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, color.getRGB(), false);
        int n = this.inventoryLabelX + this.font.width((FormattedText)this.playerInventoryTitle);
        Objects.requireNonNull(this.font);
        guiGraphics.fill(this.inventoryLabelX - 1, this.inventoryLabelY - 1, n, this.inventoryLabelY + 9, ColorUtils.RGBToRGBA((int)color.getRGB(), (float)0.5f));
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, color.getRGB(), false);
    }

    private void renderGhostItem(GuiGraphics guiGraphics, int x, int y) {
        PoseStack poseStack = guiGraphics.pose();
        List<ItemStack> listOfCards = List.of(new ItemStack((ItemLike)Registration.MINING_SKILL_CARD_PICKAXE.get()), new ItemStack((ItemLike)Registration.MINING_SKILL_CARD_AXE.get()), new ItemStack((ItemLike)Registration.MINING_SKILL_CARD_SHOVEL.get()), new ItemStack((ItemLike)Registration.MINING_SKILL_CARD_HOE.get()));
        ItemStack displayItem = ItemStack.EMPTY;
        for (Slot slot : ((SkillsRecordMenu)this.menu).getAllSlots()) {
            float alpha;
            if (slot instanceof MiningSkillCardSlot) {
                displayItem = listOfCards.get(Mth.floor((float)((float)((SkillsRecordMenu)this.menu).getPlayer().tickCount / 20.0f)) % listOfCards.size());
            }
            if (slot instanceof PenSlot) {
                displayItem = new ItemStack(Registration.PEN);
            }
            if (slot instanceof PaperSlot) {
                displayItem = new ItemStack((ItemLike)Items.PAPER);
            }
            if (displayItem == ItemStack.EMPTY) {
                return;
            }
            ItemStack stack = slot.getItem();
            if (stack == ItemStack.EMPTY || this.lock || this.configuration.isVisible()) {
                boolean bl;
                poseStack.pushPose();
                poseStack.translate((float)(x + slot.x), (float)(y + slot.y), 100.0f);
                poseStack.translate(8.0, 8.0, 0.0);
                poseStack.scale(1.0f, -1.0f, 1.0f);
                poseStack.scale(16.0f, 16.0f, 16.0f);
                MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
                assert (this.minecraft != null);
                BakedModel model = this.minecraft.getItemRenderer().getModel(displayItem, null, null, 0);
                RenderSystem.applyModelViewMatrix();
                boolean bl2 = bl = !model.usesBlockLight();
                if (bl) {
                    Lighting.setupForFlatItems();
                }
                poseStack.pushPose();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                float size = MathUtils.cycledBetweenValues((float)0.75f, (float)0.9f, (float)1.0f, (float)((float)((SkillsRecordMenu)this.menu).getPlayer().tickCount / 20.0f), (boolean)true);
                size = this.isAnimationsEnabled ? size : 0.9f;
                poseStack.scale(size, size, size);
                this.minecraft.getItemRenderer().render(displayItem, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
                RenderSystem.enableDepthTest();
                bufferSource.endBatch();
                poseStack.popPose();
                if (bl) {
                    Lighting.setupFor3DItems();
                }
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                poseStack.popPose();
            }
            boolean isMissingItems = this.isChallengesExists && this.isMissingItems && (slot instanceof PenSlot || slot instanceof PaperSlot);
            boolean notEnoughInk = this.isChallengesExists && this.notEnoughInk && slot instanceof PenSlot;
            int color = isMissingItems || notEnoughInk || ((SkillsRecordMenu)this.menu).isCardSlotsEmpty() && slot instanceof MiningSkillCardSlot ? 0xFF0000 : 0x8B8B8B;
            float f = alpha = isMissingItems || notEnoughInk || ((SkillsRecordMenu)this.menu).isCardSlotsEmpty() && slot instanceof MiningSkillCardSlot ? 0.15f : 0.55f;
            if (stack != ItemStack.EMPTY && !notEnoughInk && !this.lock && !this.configuration.isVisible()) continue;
            poseStack.pushPose();
            poseStack.translate((float)(x + slot.x), (float)(y + slot.y), 100.0f);
            poseStack.translate(8.0, 8.0, 0.0);
            guiGraphics.setColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha());
            guiGraphics.fill(RenderType.guiOverlay(), -8, -8, 8, 8, ColorUtils.RGBToRGBA((int)color, (float)alpha));
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.popPose();
        }
    }

    private void renderSlotDecorations(GuiGraphics guiGraphics, int x, int y) {
        if (this.lock) {
            return;
        }
        guiGraphics.setColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha());
        if (((SkillsRecordMenu)this.menu).getSlot(4).getItem() != ItemStack.EMPTY) {
            guiGraphics.blitSprite(SLOT_SELECT_SPRITE, x + 135, y + 99, 4, 8);
        }
        if (((SkillsRecordMenu)this.menu).getSlot(5).getItem() != ItemStack.EMPTY) {
            guiGraphics.blitSprite(SLOT_SELECT_SPRITE, x + 157, y + 99, 4, 8);
        }
        if (this.selectedSlot == -1) {
            return;
        }
        int X = 14 + 22 * this.selectedSlot;
        guiGraphics.blitSprite(SLOT_SELECT_SPRITE, x + X, y + 99, 4, 8);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTextBox(GuiGraphics guiGraphics) {
        ItemStack stack = this.selectedSlot > -1 ? ((Slot)((SkillsRecordMenu)this.menu).getCardSlots().get(this.selectedSlot)).getItem() : ItemStack.EMPTY;
        MiningSkillCardData data = MiningSkillCardData.loadData(stack);
        if (((SkillsRecordMenu)this.menu).isCardSlotsEmpty()) {
            this.textScreen.selectScreen(0).alignToCenter(true).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.no_cards"), new ChatFormatting[]{ChatFormatting.RED});
        } else if (this.selectedSlot == -1) {
            this.textScreen.selectScreen(0).alignToCenter(true).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.select_card"), new ChatFormatting[]{ChatFormatting.GRAY});
        } else if (this.selectedSlot > -1 && !data.getChallenges().isEmpty()) {
            this.textScreen.selectScreen(0).alignToCenter(false);
            this.createChallengesText(((SkillsRecordMenu)this.menu).getCardSlots());
        } else if (this.selectedSlot > -1 && data.getTier() == MiningSkillCardItem.Tier.Mastered) {
            this.textScreen.selectScreen(0).alignToCenter(true).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.completed_card"), new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
        } else {
            this.textScreen.selectScreen(0).alignToCenter(true).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.no_challenges"), new ChatFormatting[]{ChatFormatting.GRAY});
        }
        if (this.configuration.isVisible()) {
            this.textScreen.selectScreen(1).shouldRender(true).alignToCenter(List.of(Boolean.valueOf(true), Boolean.valueOf(false)).get(Mth.floor((float)((float)((SkillsRecordMenu)this.menu).getPlayer().tickCount / 20.0f)) % 2).booleanValue()).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.example"), (Component)Component.literal((String)"A: 001"), new ChatFormatting[]{ChatFormatting.WHITE}).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.example"), (Component)Component.literal((String)"B: 002"), new ChatFormatting[]{ChatFormatting.GRAY}).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.example"), (Component)Component.literal((String)"C: 003"), new ChatFormatting[]{ChatFormatting.DARK_AQUA}).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.example"), (Component)Component.literal((String)"C: 004"), new ChatFormatting[]{ChatFormatting.GOLD});
        } else if (this.isChallengesExists && this.isMissingItems) {
            this.textScreen.selectScreen(1).shouldRender(true).alignToCenter(true).backgroundColor(new Color(75, 24, 24, 218)).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.missing_items").withStyle(ChatFormatting.RED), new ChatFormatting[0]);
            ArrayList<ItemStack> missingItems = new ArrayList<ItemStack>();
            if (!((Slot)((SkillsRecordMenu)this.menu).getAllSlots().get(4)).hasItem()) {
                missingItems.add(new ItemStack(Registration.PEN));
            }
            if (!((Slot)((SkillsRecordMenu)this.menu).getAllSlots().get(5)).hasItem()) {
                missingItems.add(Items.PAPER.getDefaultInstance());
            }
            for (ItemStack item : missingItems) {
                this.textScreen.add(Component.literal((String)"\u00a7c\u2022 ").append((Component)Component.empty().append(item.getHoverName()).withStyle(style -> style.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(item))))).getVisualOrderText());
            }
        } else if (this.isChallengesExists && this.notEnoughInk) {
            this.textScreen.selectScreen(1).shouldRender(true).alignToCenter(true).backgroundColor(new Color(75, 24, 24, 218)).create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.not_enough_ink").withStyle(ChatFormatting.RED), new ChatFormatting[0]);
        } else {
            this.textScreen.selectScreen(1).shouldRender(false);
        }
        this.textScreen.selectLastScreen(true).renderAllBoxes(guiGraphics, Color.DARK_GRAY.getRGB(), this.backgroundColor.color);
    }

    private void renderScroll(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int Y = (int)Mth.lerp((float)this.getScrollOffsetDelta(), (float)16.0f, (float)86.0f);
        boolean isOverButton = this.isHovering(174, Y, 9, 12, mouseX, mouseY);
        guiGraphics.setColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha());
        guiGraphics.blitSprite(SCROLLBAR_SPRITE.get(this.textScreen.canScroll(), isOverButton), x + 174, y + Y, 10, 13);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderProgressBar(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (!this.isProgressionBarShown) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blitSprite(PROGRESS_BAR_SPRITE, x + 10, y + 91, 156, 7);
        float f = this.currentProgress;
        Objects.requireNonNull(this);
        float value = f / 100.0f;
        int bar = (int)Mth.lerp((float)value, (float)0.0f, (float)154.0f);
        poseStack.pushPose();
        poseStack.translate((float)(x + 11), (float)(y + 97), 0.0f);
        poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
        guiGraphics.fillGradient(RenderType.guiOverlay(), 0, 0, 5, bar, ColorUtils.RGBToRGBA((int)this.getProgressionBarColor(), (float)0.55f), ColorUtils.RGBToRGBA((int)this.getProgressionBarColor(), (float)0.75f), 0);
        poseStack.popPose();
        if (this.lock) {
            return;
        }
        if (MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)x, (int)y, (int)10, (int)91, (int)156, (int)7)) {
            MutableComponent component = Component.translatable((String)"gui.ultimine_addition.skills_record.progress", (Object[])new Object[]{Component.literal((String)("%" + this.currentProgress)).withStyle(Style.EMPTY.withColor(this.getProgressionBarColor()))}).withStyle(ChatFormatting.GRAY);
            guiGraphics.renderTooltip(this.font, (Component)component, mouseX - 50, mouseY - 5);
        }
    }

    private void renderTextBoxComponent(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.lock) {
            return;
        }
        Style style = this.textScreen.getComponentStyleAt((double)mouseX, (double)mouseY);
        if (style != null && style.getHoverEvent() != null) {
            Component component;
            HoverEvent styleHoverEvent = style.getHoverEvent();
            if (styleHoverEvent.getValue(HoverEvent.Action.SHOW_TEXT) != null && (component = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT)) != null) {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)component, Math.max(this.width / 2, 200)), mouseX, mouseY);
            }
            if (styleHoverEvent.getValue(HoverEvent.Action.SHOW_ITEM) != null) {
                HoverEvent.ItemStackInfo stackInfo = (HoverEvent.ItemStackInfo)styleHoverEvent.getValue(HoverEvent.Action.SHOW_ITEM);
                if (stackInfo == null) {
                    return;
                }
                int X = -10;
                int Y = -30;
                guiGraphics.pose().pushPose();
                this.renderItemTooltip(guiGraphics, stackInfo.getItemStack(), style, mouseX + X, mouseY + Y);
                guiGraphics.pose().popPose();
            }
        }
    }

    private void renderItemTooltip(GuiGraphics guiGraphics, ItemStack stack, Style style, int mouseX, int mouseY) {
        assert (this.minecraft != null);
        AtomicInteger length = new AtomicInteger();
        List tooltip = Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack);
        List<ClientTooltipComponent> tooltipComponents = tooltip.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList());
        tooltipComponents.forEach(component -> length.set(Math.max(length.get(), component.getWidth(this.font))));
        if (style.getClickEvent() != null) {
            MutableComponent component2 = Component.translatable((String)"tooltip.ultimine_addition.skills_record.press.left_click").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            tooltipComponents.addAll(Language.getInstance().getVisualOrder(this.font.getSplitter().splitLines((FormattedText)component2, Math.max(length.get(), 150), Style.EMPTY)).stream().map(ClientTooltipComponent::create).toList());
        }
        boolean isExceedingWindow = mouseX + 12 + 18 + length.get() > this.width;
        int alignPosX = isExceedingWindow ? 6 : 0;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.setColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha());
        guiGraphics.blitSprite(ITEM_DISPLAY_SPRITE, mouseX + alignPosX, mouseY, 26, 26);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.pose().popPose();
        guiGraphics.renderFakeItem(stack, mouseX + alignPosX + 5, mouseY + 5);
        int spacing = 6 - tooltipComponents.size() * 6;
        guiGraphics.renderTooltipInternal(this.font, tooltipComponents, mouseX + 18, mouseY + 21 + spacing, DefaultTooltipPositioner.INSTANCE);
    }

    private boolean isConsumeChallengeExists() {
        AtomicBoolean result = new AtomicBoolean();
        ((SkillsRecordMenu)this.menu).getCardSlots().forEach(slot -> {
            ItemStack stack = slot.getItem();
            MiningSkillCardData cardData = MiningSkillCardData.loadData(stack);
            if (!cardData.getChallenges().stream().filter(identifier -> {
                if (ChallengesManager.INSTANCE.getAllChallenges().get(identifier.getId()) == null) {
                    return false;
                }
                return ChallengesManager.INSTANCE.getAllChallenges().get(identifier.getId()).getChallengeType().isConsuming();
            }).toList().isEmpty()) {
                result.set(true);
            }
        });
        return result.get();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isScrollHovered(mouseX, mouseY)) {
                this.isScrolling = this.textScreen.canScroll();
                return this.isScrolling;
            }
            Style style = this.textScreen.getComponentStyleAt(mouseX, mouseY);
            if (style != null && style.getClickEvent() != null) {
                if (style.getClickEvent().getValue().contains("[cycle]")) {
                    itemCycle += 1.0f;
                    return true;
                }
                if (this.selectedSlot > -1 && style.getClickEvent().getValue().contains("[pin]")) {
                    String value = style.getClickEvent().getValue().split("<>")[1];
                    ResourceLocation challengeId = ResourceLocation.parse((String)value);
                    SkillsRecordData data = ((SkillsRecordMenu)this.menu).getData();
                    data.togglePinned(this.selectedSlot, challengeId, (SkillsRecordMenu)this.menu).saveData((ItemStack)data.get());
                    return true;
                }
                if (this.selectedSlot > -1 && style.getClickEvent().getValue().contains("[edit]")) {
                    JsonElement element = JsonParser.parseString((String)style.getClickEvent().getValue().split("<>")[1]);
                    DataResult decode = MiningSkillCardData.ChallengeHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    Objects.requireNonNull(this.minecraft).setScreen((Screen)new EditChallengeScreen(this, (MiningSkillCardData.ChallengeHolder)((Pair)decode.getOrThrow()).getFirst()));
                    return true;
                }
            }
        }
        if (button == 1 && this.hoveredSlot != null && this.hoveredSlot.getItem() != ItemStack.EMPTY && ((SkillsRecordMenu)this.menu).getCardSlots().contains((Object)this.hoveredSlot)) {
            this.selectedSlot = this.selectedSlot == -1 || this.selectedSlot != this.hoveredSlot.getContainerSlot() ? this.hoveredSlot.getContainerSlot() : -1;
            SkillsRecordData data = ((SkillsRecordMenu)this.menu).getData();
            data.setSelectedCard(this.selectedSlot).sendToServer(((SkillsRecordMenu)this.menu).interactionHand).saveData((ItemStack)data.get());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button)) {
            this.clearFocus();
            this.setFocused(null);
            return true;
        }
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.getFocused() != null && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isScrolling) {
            int i = this.topPos + 16;
            int j = i + 86;
            float delta = Mth.clamp((float)((float)((mouseY - (double)i) / (double)(j - i))), (float)0.0f, (float)1.0f);
            this.textScreen.scrollTo((int)Mth.lerp((float)delta, (float)0.0f, (float)this.textScreen.getRemainingLines()), true);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (this.textScreen.canScroll()) {
            if (scrollY < 0.0) {
                this.textScreen.scrollTo(1, false);
            }
            if (scrollY > 0.0) {
                this.textScreen.scrollTo(-1, false);
            }
            return true;
        }
        return false;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        AbstractDraggableWidget component;
        if (this.lock) {
            return false;
        }
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof AbstractDraggableWidget && (component = (AbstractDraggableWidget)guiEventListener).isMouseOver(mouseX, mouseY)) {
            return false;
        }
        return super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.hoveredSlot != null) {
            return false;
        }
        if (KeyBindingHooks.isMatches(KeyHandler.KEY_SHOW_PROGRESSION_BAR, keyCode, scanCode) && this.isChallengesExists && !this.isMissingItems && !this.notEnoughInk && !this.lock && this.progressMode == 1) {
            this.isProgressionBarShown = true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (super.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (!KeyBindingHooks.isMatches(KeyHandler.KEY_SHOW_PROGRESSION_BAR, keyCode, scanCode)) {
            if (this.progressMode == 1) {
                this.isProgressionBarShown = false;
            }
            return true;
        }
        return false;
    }

    private float getScrollOffsetDelta() {
        float offset = (float)this.textScreen.getScrollOffset() / Math.max(1.0f, (float)this.textScreen.getRemainingLines());
        return Mth.clamp((float)offset, (float)0.0f, (float)1.0f);
    }

    private boolean isScrollHovered(double mouseX, double mouseY) {
        int y = (int)Mth.lerp((float)this.getScrollOffsetDelta(), (float)16.0f, (float)86.0f);
        return MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)this.leftPos, (int)this.topPos, (int)174, (int)y, (int)10, (int)13);
    }

    private void createChallengesText(NonNullList<Slot> slots) {
        ItemStack stack = ((Slot)slots.get(this.selectedSlot)).getItem();
        MiningSkillCardData cardData = MiningSkillCardData.loadData(stack);
        ChallengesManager manager = ChallengesManager.INSTANCE;
        int currentValues = 0;
        int requiredValues = 0;
        for (MiningSkillCardData.ChallengeHolder challengeHolder : cardData.getChallenges()) {
            boolean isConsumeNeeded;
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(List.of(ItemStack.EMPTY));
            ChallengesData challengesData = manager.getAllChallenges().get(challengeHolder.getId());
            String type = "null";
            if (challengesData != null) {
                itemList.clear();
                type = challengesData.getChallengeType().getTypeName();
                ChallengesManager.INSTANCE.utilizeTargetedBlocks(challengesData).forEach(block -> itemList.add(new ItemStack((ItemLike)block)));
                currentValues += challengeHolder.getCurrentPoints();
                requiredValues += challengeHolder.getRequiredPoints();
            }
            ItemStack displayItem = (ItemStack)itemList.get(Mth.floor((float)itemCycle) % itemList.size());
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(displayItem));
            Style questStyle = Style.EMPTY.withHoverEvent(hoverEvent).withItalic(Boolean.valueOf(true)).withColor(new Color(12361597).getRGB());
            if (itemList.size() > 1) {
                questStyle = questStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, "[cycle]"));
            }
            Component title = ComponentHelper.limitComponent((Component)Component.literal((String)"\u300b").append((Component)Component.translatable((String)"challenge.ultimine_addition.title", (Object[])new Object[]{challengeHolder.getOrder()}).setStyle(Style.EMPTY.withColor(new Color(16445889).getRGB()))).append("\u300a").withColor(new Color(0x7A7A7A).getRGB()), (int)this.textScreen.getWidth());
            Component description = SkillsRecordScreen.createChallengeDescription(type, questStyle, itemList, itemCycle);
            Style descStyle = Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY);
            Style counterStyle = Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD);
            boolean bl = isConsumeNeeded = challengesData != null && challengesData.getChallengeType().isConsuming() && !((SkillsRecordMenu)this.menu).getData().isConsumeMode() && !cardData.isChallengeAccomplished(challengeHolder.getId());
            if (isConsumeNeeded) {
                hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"challenge.ultimine_addition.consume.info").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                counterStyle = Style.EMPTY.withHoverEvent(hover).withColor(ChatFormatting.RED);
            } else if (challengesData != null && challengesData.getChallengeType().isConsuming() && ((SkillsRecordMenu)this.menu).getData().isConsumeMode() && !cardData.isChallengeAccomplished(challengeHolder.getId())) {
                hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"\u2716 ").append((Component)Component.translatable((String)"challenge.ultimine_addition.consume")).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                counterStyle = Style.EMPTY.withItalic(Boolean.valueOf(true)).withHoverEvent(hover).withColor(ChatFormatting.LIGHT_PURPLE);
            } else if (cardData.isChallengeAccomplished(challengeHolder.getId())) {
                counterStyle = Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN);
            }
            ArrayList<FormattedCharSequence> result = new ArrayList<FormattedCharSequence>(Language.getInstance().getVisualOrder(this.font.getSplitter().splitLines((FormattedText)title, this.textScreen.getWidth(), title.getStyle())));
            result.addAll(Language.getInstance().getVisualOrder(this.font.getSplitter().splitLines((FormattedText)description, this.textScreen.getWidth(), descStyle)));
            FormattedCharSequence counter = FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)"\u27a4 ", (Style)counterStyle), (FormattedCharSequence)FormattedCharSequence.forward((String)"%s/%s".formatted(challengeHolder.getCurrentPoints(), challengeHolder.getRequiredPoints()), (Style)counterStyle.withStrikethrough(Boolean.valueOf(isConsumeNeeded))));
            HoverEvent pinHover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"gui.ultimine_addition.skills_record.pin.click").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            FormattedCharSequence pinButton = FormattedCharSequence.forward((String)"\u25ce", (Style)Style.EMPTY.withColor(challengeHolder.isPinned() ? ChatFormatting.YELLOW : ChatFormatting.GRAY).withStrikethrough(Boolean.valueOf(!challengeHolder.isPinned())).withHoverEvent(pinHover).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, "[pin]<>%s".formatted(challengeHolder.getId().toString()))));
            DataResult dataResult = MiningSkillCardData.ChallengeHolder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)challengeHolder);
            HoverEvent editHover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"gui.ultimine_addition.skills_record.edit.click").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            FormattedCharSequence editButton = FormattedCharSequence.forward((String)"\u270e", (Style)Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withHoverEvent(editHover).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, "[edit]<>%s".formatted(dataResult.getOrThrow()))));
            FormattedCharSequence buttons = FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)" [", (Style)Style.EMPTY.withColor(Color.GRAY.getRGB())), (FormattedCharSequence)pinButton);
            if (((Boolean)ConfigHandler.CLIENT.SR_EDIT_MODE.get()).booleanValue() && ((SkillsRecordMenu)this.menu).getPlayer().hasPermissions(2)) {
                buttons = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{buttons, FormattedCharSequence.forward((String)"]-[", (Style)Style.EMPTY.withColor(Color.GRAY.getRGB())), editButton});
            }
            buttons = FormattedCharSequence.composite((FormattedCharSequence)buttons, (FormattedCharSequence)FormattedCharSequence.forward((String)"]", (Style)Style.EMPTY.withColor(Color.GRAY.getRGB())));
            result.add(FormattedCharSequence.composite((FormattedCharSequence)counter, (FormattedCharSequence)buttons));
            if (!this.textScreen.isEmpty()) {
                this.textScreen.add(FormattedCharSequence.EMPTY).addAll(result);
                continue;
            }
            this.textScreen.addAll(result);
        }
        this.calculateProgression(currentValues, requiredValues);
    }

    public static Component createChallengeDescription(String challengeType, Style style, List<ItemStack> items, float cycle) {
        ItemStack displayItem = items.get(Mth.floor((float)cycle) % items.size());
        MutableComponent info = items.size() > 1 ? Component.translatable((String)"challenge.ultimine_addition.various_blocks", (Object[])new Object[]{Component.literal((String)displayItem.getHoverName().getString()).withStyle(style)}) : Component.literal((String)items.getFirst().getHoverName().getString()).withStyle(style);
        return Component.translatable((String)"challenge.ultimine_addition.%s".formatted(challengeType), (Object[])new Object[]{info});
    }

    private void calculateProgression(int currentValues, int requiredValues) {
        if (requiredValues == 0) {
            return;
        }
        float f = (float)currentValues / (float)requiredValues;
        Objects.requireNonNull(this);
        float value = f * 100.0f;
        this.currentProgress = (int)value;
    }

    public int getProgressionBarColor() {
        float f = Math.min((float)this.currentProgress / 100.0f, 1.0f);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Collection<Rect2i> getComponentsRectangle() {
        HashSet<Rect2i> collection = new HashSet<Rect2i>();
        collection.add(RenderUtils.createRect2i((GuiEventListener)this.configuration));
        return collection;
    }

    public static float getItemCycle() {
        return itemCycle;
    }

    public static enum OverlayColor {
        DEFAULT(new Color(255, 255, 255)),
        RED(new Color(255, 116, 116)),
        ORANGE(new Color(255, 162, 94)),
        YELLOW(new Color(253, 241, 113)),
        GREEN(new Color(144, 238, 144)),
        BLUE(new Color(112, 153, 255)),
        INDIGO(new Color(126, 80, 176)),
        VIOLET(new Color(238, 130, 238));

        private final Color color;

        private OverlayColor(Color color) {
            this.color = color;
        }

        public float getAlpha() {
            return new ColorUtils(this.color.getRGB()).getAlpha();
        }

        public float getRed() {
            return new ColorUtils(this.color.getRGB()).getRed();
        }

        public float getGreen() {
            return new ColorUtils(this.color.getRGB()).getGreen();
        }

        public float getBlue() {
            return new ColorUtils(this.color.getRGB()).getBlue();
        }

        public OverlayColor next() {
            int nextIndex = (this.ordinal() + 1) % OverlayColor.values().length;
            return OverlayColor.values()[nextIndex];
        }

        public OverlayColor previous() {
            int prevIndex = (this.ordinal() - 1 + OverlayColor.values().length) % OverlayColor.values().length;
            return OverlayColor.values()[prevIndex];
        }

        public Color convert() {
            return this.color;
        }
    }
}

