/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.ixdarklord.coolcatlib.api.client.gui.components.ColorableImageButton;
import net.ixdarklord.coolcatlib.api.util.ColorUtils;
import net.ixdarklord.coolcatlib.api.util.RenderUtils;
import net.ixdarklord.ultimine_addition.client.gui.components.ColoredButton;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.common.data.item.SelectedShapeData;
import net.ixdarklord.ultimine_addition.common.menu.ShapeSelectorMenu;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.FTBUltimineIntegration;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.network.PayloadHandler;
import net.ixdarklord.ultimine_addition.network.payloads.UpdateItemShapePayload;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ShapeSelectorScreen
extends AbstractContainerScreen<ShapeSelectorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = FTBUltimineAddition.getGuiTexture("container/shape_selector", "png");
    private SkillsRecordScreen.OverlayColor color;
    private ColoredButton filterButton;
    private AbstractStringWidget emptyString;
    private SelectBox selectBox;
    private ColorableImageButton setButton;
    private ColorableImageButton clearButton;

    public ShapeSelectorScreen(ShapeSelectorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 178;
        this.imageHeight = 172;
    }

    protected void init() {
        super.init();
        this.titleLabelX = 6;
        this.titleLabelY = 5;
        this.inventoryLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.playerInventoryTitle) / 2;
        this.inventoryLabelY = this.imageHeight - 96;
        this.filterButton = (ColoredButton)this.addWidget((GuiEventListener)new ColoredButton(this.leftPos + 165, this.topPos + 4, 9, 9, SkillsRecordScreen.CONFIGURATION_BUTTON_SPRITES, button -> {
            Filter filter = (Filter)((Object)((Object)ConfigHandler.CLIENT.SHAPE_SELECTOR_FILTER.get()));
            ConfigHandler.CLIENT.SHAPE_SELECTOR_FILTER.set((Object)(Screen.hasShiftDown() ? filter.previous() : filter.next()));
            ConfigHandler.CLIENT.SHAPE_SELECTOR_FILTER.save();
            this.selectBox.refreshList();
        }, (Component)Component.empty(), tooltipInfo -> {
            MutableComponent filterComponent = ConfigHandler.CLIENT.SHAPE_SELECTOR_FILTER.get() == Filter.ALL ? Component.translatable((String)"gui.ultimine_addition.filter.all") : Component.translatable((String)"gui.ultimine_addition.filter.only_enabled");
            tooltipInfo.component = Component.translatable((String)"gui.ultimine_addition.filter").append(": ").append((Component)filterComponent).withStyle(ChatFormatting.WHITE);
        }));
        this.emptyString = (AbstractStringWidget)this.addRenderableWidget((GuiEventListener)new AbstractStringWidget(this, this.leftPos + 61, this.topPos + 16, 102, 54, (Component)Component.translatable((String)"gui.ultimine_addition.shape_selector.insert"), this.font){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Component component = this.getMessage();
                Font font = this.getFont();
                int width = this.getWidth();
                List sequences = font.split((FormattedText)component, width);
                int n = sequences.size();
                Objects.requireNonNull(font);
                int totalTextHeight = n * 9;
                int x = this.getX();
                int y = this.getY() + (this.getHeight() - totalTextHeight) / 2;
                for (FormattedCharSequence sequence : sequences) {
                    int textWidth = font.width(sequence);
                    int centeredX = x + (width - textWidth) / 2;
                    guiGraphics.drawString(font, sequence, centeredX, y, this.getColor());
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        });
        this.emptyString.setColor(Color.LIGHT_GRAY.getRGB());
        this.selectBox = (SelectBox)this.addRenderableWidget((GuiEventListener)new SelectBox(this.leftPos + 61, this.topPos + 16, 102, 54));
        this.selectBox.visible = false;
        this.setButton = (ColorableImageButton)this.addRenderableWidget((GuiEventListener)new ColorableImageButton(this, this.leftPos + 10, this.topPos + 54, 19, 19, SkillsRecordScreen.BUTTON_SPRITES, button -> {
            SelectBox.ShapeEntry selected = (SelectBox.ShapeEntry)this.selectBox.getSelected();
            if (selected != null) {
                PayloadHandler.sendToServer(new UpdateItemShapePayload(selected.shape.getName().toString()));
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                ResourceLocation SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/confirm");
                guiGraphics.blitSprite(SPRITE, this.getX() + 1, this.getY(), 18, 18);
            }
        });
        this.clearButton = (ColorableImageButton)this.addRenderableWidget((GuiEventListener)new ColorableImageButton(this, this.leftPos + 32, this.topPos + 54, 19, 19, SkillsRecordScreen.BUTTON_SPRITES, button -> {
            this.selectBox.setSelected(null);
            PayloadHandler.sendToServer(new UpdateItemShapePayload(""));
        }){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                ResourceLocation SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/cancel");
                guiGraphics.blitSprite(SPRITE, this.getX() + 1, this.getY(), 18, 18);
            }
        });
        this.setButton.active = false;
        this.clearButton.active = false;
    }

    private void update() {
        ItemStack stack = ((ShapeSelectorMenu)this.menu).getSlot(0).getItem();
        boolean slotEmpty = stack.isEmpty();
        SelectBox.ShapeEntry selected = (SelectBox.ShapeEntry)this.selectBox.getSelected();
        this.setButton.setColor(this.color.convert());
        this.clearButton.setColor(this.color.convert());
        this.emptyString.visible = slotEmpty;
        this.selectBox.visible = !slotEmpty;
        this.clearButton.active = !slotEmpty && stack.has((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get());
        this.setButton.active = !slotEmpty && selected != null && !selected.isShapeSelected();
        this.setButton.setTooltip(this.setButton.active ? Tooltip.create((Component)Component.literal((String)"\u27a4 ").append((Component)Component.translatable((String)"gui.ultimine_addition.action.set"))) : null);
        this.clearButton.setTooltip(this.clearButton.active ? Tooltip.create((Component)Component.literal((String)"\u27a4 ").append((Component)Component.translatable((String)"gui.ultimine_addition.action.clear"))) : null);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.color = (SkillsRecordScreen.OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
        this.update();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.filterButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        SelectBox.ShapeEntry entry = this.selectBox.getHovered();
        if (entry == null) {
            return;
        }
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (!entry.isAllowed()) {
            components.add(Component.translatable((String)"gui.ultimine_addition.shape_selector.blacklisted").withStyle(ChatFormatting.RED));
        } else if (entry.isShapeSelected()) {
            components.add(Component.translatable((String)"gui.ultimine_addition.shape_selector.selected").withColor(10541630));
            components.add(Component.literal((String)"- ").append((Component)entry.shape.getDisplayName()));
        }
        Minecraft mc = Objects.requireNonNull(this.minecraft);
        if (mc.options.advancedItemTooltips && ShapeSelectorScreen.hasShiftDown()) {
            if (!components.isEmpty()) {
                components.add(Component.empty());
            }
            components.add(Component.literal((String)"Shape ID: ").append(entry.shape.getName().toString()).withStyle(ChatFormatting.GRAY));
        }
        if (!components.isEmpty()) {
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Color color = ColorUtils.blendColors((Color)new Color(0, 0, 0), (Color)this.color.convert(), (double)0.75);
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, color.getRGB(), false);
        int n = this.inventoryLabelX + this.font.width((FormattedText)this.playerInventoryTitle);
        Objects.requireNonNull(this.font);
        guiGraphics.fill(this.inventoryLabelX - 1, this.inventoryLabelY - 1, n, this.inventoryLabelY + 9, ColorUtils.RGBToRGBA((int)color.getRGB(), (float)0.5f));
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, color.getRGB(), false);
    }

    private class SelectBox
    extends ObjectSelectionList<ShapeEntry> {
        public SelectBox(int x, int y, int width, int height) {
            super(Minecraft.getInstance(), width, height, y, 20);
            this.setX(x);
            this.refreshList();
        }

        public void refreshList() {
            this.clearEntries();
            for (Shape shape : FTBUltimineIntegration.getShapesList()) {
                if (ConfigHandler.CLIENT.SHAPE_SELECTOR_FILTER.get() == Filter.ENABLED_SHAPES && !FTBUltimineIntegration.getEnabledShapes().contains(shape)) continue;
                this.addEntry((AbstractSelectionList.Entry)new ShapeEntry(shape));
            }
            this.clampScrollAmount();
        }

        @Nullable
        public ShapeEntry getHovered() {
            return (ShapeEntry)super.getHovered();
        }

        public int getRowLeft() {
            return this.getX() + this.width / 2 - this.getRowWidth() / 2;
        }

        public int getRowWidth() {
            return this.width;
        }

        protected int getScrollbarPosition() {
            return this.getX() + this.width + 4;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
            int i = this.getX() + (this.width - width) / 2;
            ScreenRectangle rectangle = new ScreenRectangle(i, top - 1, width, height + 2);
            RenderUtils.renderHollowRectangle((GuiGraphics)guiGraphics, (ScreenRectangle)rectangle, (int)1, (int)outerColor);
        }

        protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.scrollbarVisible()) {
                int i = this.getScrollbarPosition();
                int j = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
                j = Mth.clamp((int)j, (int)32, (int)(this.height - 8));
                int k = (int)this.getScrollAmount() * (this.height - j) / this.getMaxScroll() + this.getY();
                if (k < this.getY()) {
                    k = this.getY();
                }
                ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
                ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
                RenderSystem.enableBlend();
                guiGraphics.blitSprite(SCROLLER_BACKGROUND_SPRITE, i, this.getY(), 6, this.getHeight());
                ColorUtils color = new ColorUtils(ShapeSelectorScreen.this.color.convert().brighter().getRGB());
                guiGraphics.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                guiGraphics.blitSprite(SCROLLER_SPRITE, i, k, 6, j);
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private class ShapeEntry
        extends ObjectSelectionList.Entry<ShapeEntry> {
            private final Shape shape;

            private ShapeEntry(Shape shape) {
                this.shape = shape;
            }

            private boolean isAllowed() {
                return FTBUltimineIntegration.getEnabledShapes().contains(this.shape);
            }

            private boolean isShapeSelected() {
                ItemStack stack = ((ShapeSelectorMenu)ShapeSelectorScreen.this.menu).getSlot(0).getItem();
                SelectedShapeData shapeData = (SelectedShapeData)stack.get((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get());
                return shapeData != null && this.shape.getName().equals((Object)shapeData.shape().getName());
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                SoundManager handler = Minecraft.getInstance().getSoundManager();
                if (!this.isAllowed()) {
                    handler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_BASS, (float)0.5f));
                    return false;
                }
                handler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return super.mouseClicked(mouseX, mouseY, button);
            }

            public void renderBack(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
                Color bgColor = new Color(0xBCBCBC);
                Color borderColor = new Color(0xB5B5B5);
                if (!this.isAllowed()) {
                    bgColor = ColorUtils.blendColors((Color)bgColor.darker(), (Color)new Color(0x701111), (double)0.4);
                    borderColor = ColorUtils.blendColors((Color)borderColor, (Color)new Color(0x701111), (double)0.4);
                } else if (this.isShapeSelected()) {
                    bgColor = ColorUtils.blendColors((Color)bgColor.darker(), (Color)new Color(10541630), (double)0.4);
                    borderColor = ColorUtils.blendColors((Color)borderColor, (Color)new Color(10541630), (double)0.4);
                }
                float alpha = this.isAllowed() && isHovered || this.isShapeSelected() ? 0.8f : 0.5f;
                guiGraphics.fill(left, top, left + width, top + height, ColorUtils.RGBToRGBA((int)bgColor.getRGB(), (float)alpha));
                RenderUtils.renderHollowRectangle((GuiGraphics)guiGraphics, (ScreenRectangle)new ScreenRectangle(left, top, width, height), (int)1, (int)borderColor.getRGB());
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
                int spacing;
                Font font = ((SelectBox)SelectBox.this).minecraft.font;
                Color color = this.isAllowed() ? Color.WHITE : new Color(13712958);
                int ticks = (int)(Util.getMillis() / 10L);
                Style style = Style.EMPTY.withStrikethrough(Boolean.valueOf(!this.isAllowed()));
                int n = spacing = this.isShapeSelected() ? 9 : 0;
                if (this.isShapeSelected()) {
                    guiGraphics.drawString(font, (Component)Component.literal((String)"\u27a4"), left + 3, top + height / 2 - 4, color.getRGB());
                }
                RenderUtils.renderScrollingString((GuiGraphics)guiGraphics, (int)ticks, (Font)font, (Component)this.shape.getDisplayName().copy().withStyle(style), (boolean)false, (int)(left + spacing), (int)top, (int)(width - spacing), (int)height, (int)3, (int)color.getRGB());
            }

            @NotNull
            public Component getNarration() {
                return this.shape.getDisplayName();
            }
        }
    }

    public static enum Filter {
        ALL,
        ENABLED_SHAPES;


        public Filter next() {
            int nextIndex = (this.ordinal() + 1) % Filter.values().length;
            return Filter.values()[nextIndex];
        }

        public Filter previous() {
            int prevIndex = (this.ordinal() - 1 + Filter.values().length) % Filter.values().length;
            return Filter.values()[prevIndex];
        }
    }
}

