/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.screens;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.ixdarklord.coolcatlib.api.util.ColorUtils;
import net.ixdarklord.ultimine_addition.common.data.item.SelectedShapeData;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.common.potion.MineGoPotion;
import net.ixdarklord.ultimine_addition.common.tag.ModItemTags;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipEvents {
    public static void init(ItemStack stack, List<Component> components, Item.TooltipContext ignored, TooltipFlag ignored1) {
        Potion potion;
        if (stack.has((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get())) {
            ItemTooltipEvents.insertSelectedShapeInfo(stack, components);
        }
        if (stack.is(ModItemTags.LEGACY_DISABLED_ITEMS) && ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            components.add(1, (Component)Component.translatable((String)"tooltip.ultimine_addition.legacy_mode.disabled_item").withStyle(ChatFormatting.RED));
        }
        if (stack.getItem() instanceof PotionItem && (potion = ItemTooltipEvents.getPotion(stack)) instanceof MineGoPotion) {
            MineGoPotion potion2 = (MineGoPotion)potion;
            MutableComponent name = components.getFirst().copy().append((Component)Component.literal((String)" | ").withStyle(ChatFormatting.DARK_GRAY).append(potion2.getComponentType().get()));
            components.set(0, (Component)name);
            components.add(1, (Component)Component.literal((String)"\u00a78\u2022 ").append((Component)Component.translatable((String)"tooltip.ultimine_addition.skill_card.tier", (Object[])new Object[]{potion2.getTier().getDisplayName()})).withStyle(ChatFormatting.ITALIC));
            if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
                components.add(1, (Component)Component.translatable((String)"tooltip.ultimine_addition.legacy_mode.disabled_item").withStyle(ChatFormatting.RED));
            }
        }
        if (stack.getItem() instanceof SkillsRecordItem) {
            for (int i = 0; i < components.size(); ++i) {
                Component component = components.get(i);
                String slot = "trinkets.slot.hand.skills_record";
                if (!component.getString().contains(slot)) continue;
                components.set(i, (Component)Component.literal((String)component.getString().replace(slot, Component.translatable((String)"item.ultimine_addition.skills_record").getString())).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    private static void insertSelectedShapeInfo(ItemStack stack, List<Component> components) {
        SelectedShapeData shapeData = (SelectedShapeData)stack.get((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get());
        double ratio = Mth.clamp((double)(((double)Mth.sin((float)((float)Util.getMillis() / 160.0f)) + 1.0) / 2.0), (double)0.0, (double)1.0);
        Color color = ColorUtils.blendColors((Color)new Color(10541630), (Color)new Color(10541630).brighter(), (double)ratio);
        MutableComponent shapeName = Objects.requireNonNull(shapeData).shape().getDisplayName().withColor(color.getRGB());
        List<MutableComponent> componentList = List.of(Component.literal((String)""), Component.translatable((String)"tooltip.ultimine_addition.shape_selector.selected").withStyle(ChatFormatting.GRAY), Component.literal((String)"- ").withStyle(ChatFormatting.DARK_GRAY).append((Component)shapeName));
        for (int i = 0; i < components.size(); ++i) {
            Component component = components.get(i);
            if (!component.getString().isEmpty()) continue;
            components.set(i, (Component)Component.literal((String)" "));
            components.addAll(i, componentList);
            return;
        }
        components.addAll(componentList);
    }

    @Nullable
    private static Potion getPotion(ItemStack stack) {
        return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().map(Holder::value).orElse(null);
    }
}

