/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.screens;

import java.awt.Color;
import net.ixdarklord.coolcatlib.api.client.gui.components.ColorableImageButton;
import net.ixdarklord.coolcatlib.api.util.RenderUtils;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EditChallengeScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_SPRITE = FTBUltimineAddition.rl("container/skills_record/edit_challenge/background");
    private static final ResourceLocation ARROW_SPRITE = FTBUltimineAddition.rl("container/skills_record/edit_challenge/arrow");
    protected int imageWidth = 155;
    protected int imageHeight = 91;
    protected int leftPos;
    protected int topPos;
    private final SkillsRecordScreen parent;
    private final MiningSkillCardData.ChallengeHolder challengeHolder;
    private EditBox newValueBox;
    private ColorableImageButton doneButton;

    public EditChallengeScreen(@NotNull SkillsRecordScreen parent, MiningSkillCardData.ChallengeHolder challengeHolder) {
        super((Component)Component.translatable((String)"selectWorld.edit").append(" ").append((Component)Component.translatable((String)"challenge.ultimine_addition.title", (Object[])new Object[]{Component.literal((String)"[%s]".formatted(challengeHolder.getOrder()))})));
        this.parent = parent.lock(true);
        this.challengeHolder = challengeHolder;
    }

    protected void init() {
        this.parent.width = this.width;
        this.parent.height = this.height;
        this.parent.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new StringWidget(this.leftPos + 16, this.topPos + 34, 123, 9, (Component)Component.literal((String)this.challengeHolder.getId().toString()), this.font){
            private int ticks;
            private boolean showSuccess;
            {
                this.ticks = 0;
                this.showSuccess = false;
            }

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                MutableComponent component = Component.translatable((String)"gui.ultimine_addition.skills_record.edit.copy_id").withStyle(ChatFormatting.GRAY);
                MutableComponent successComponent = Component.translatable((String)"gui.ultimine_addition.skills_record.edit.copy_success").withStyle(ChatFormatting.GREEN);
                this.setTooltip(Tooltip.create((Component)(this.showSuccess ? successComponent : component)));
                RenderUtils.renderScrollingString((GuiGraphics)guiGraphics, (int)((int)(Util.getMillis() / 4L)), (Font)EditChallengeScreen.this.font, (Component)this.getMessage(), (boolean)true, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (int)1, (int)Color.WHITE.getRGB());
                if (this.showSuccess) {
                    --this.ticks;
                    if (this.ticks <= 0) {
                        this.showSuccess = false;
                    }
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.isHovered() && button == 0) {
                    assert (EditChallengeScreen.this.minecraft != null);
                    ((EditChallengeScreen)EditChallengeScreen.this).minecraft.keyboardHandler.setClipboard(this.getMessage().getString());
                    this.playDownSound(EditChallengeScreen.this.minecraft.getSoundManager());
                    this.showSuccess = true;
                    this.ticks = 80;
                    return true;
                }
                return false;
            }
        });
        this.newValueBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 91, this.topPos + 50, 34, 10, (Component)Component.translatable((String)"gui.ultimine_addition.skills_record.edit.new_value")));
        this.newValueBox.setBordered(false);
        this.newValueBox.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.edit.new_value", (Object[])new Object[]{this.challengeHolder.getRequiredPoints()})));
        this.newValueBox.insertText(String.valueOf(this.challengeHolder.getCurrentPoints()));
        this.newValueBox.setMaxLength(String.valueOf(this.challengeHolder.getRequiredPoints()).length());
        this.newValueBox.setFilter(s -> {
            try {
                if (s.isEmpty()) {
                    return true;
                }
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        FrameLayout layout = new FrameLayout(this.leftPos + 10, this.topPos + 64, 135, 17);
        LinearLayout linearLayout = (LinearLayout)layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(5));
        this.doneButton = (ColorableImageButton)linearLayout.addChild((LayoutElement)(this.addRenderableWidget((GuiEventListener)new ColorableImageButton(0, 0, 45, 13, SkillsRecordScreen.BUTTON_SPRITES, button -> {
            SkillsRecordData data = ((SkillsRecordMenu)this.parent.getMenu()).getData();
            MiningSkillCardData cardData = MiningSkillCardData.loadData((ItemStack)data.getCardSlots().get(this.parent.selectedSlot));
            cardData.setAmount(this.challengeHolder.getId(), this.getNewValue());
            data.sendToServer(((SkillsRecordMenu)this.parent.getMenu()).interactionHand).saveData((ItemStack)data.get());
            assert (this.minecraft != null);
            assert (this.minecraft.player != null);
            this.minecraft.player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.5f);
            this.onClose();
        }, CommonComponents.GUI_DONE){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                int i = this.getX() + 2;
                int j = this.getX() + this.getWidth() - 2;
                2.renderScrollingString((GuiGraphics)guiGraphics, (Font)EditChallengeScreen.this.font, (Component)this.getMessage(), (int)i, (int)this.getY(), (int)j, (int)(this.getY() + this.getHeight() - 1), (int)Color.WHITE.getRGB());
            }
        })));
        linearLayout.addChild((LayoutElement)(this.addRenderableWidget((GuiEventListener)new ColorableImageButton(0, 0, 45, 13, SkillsRecordScreen.BUTTON_SPRITES, button -> this.onClose(), CommonComponents.GUI_CANCEL){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                int i = this.getX() + 2;
                int j = this.getX() + this.getWidth() - 2;
                3.renderScrollingString((GuiGraphics)guiGraphics, (Font)EditChallengeScreen.this.font, (Component)this.getMessage(), (int)i, (int)this.getY(), (int)j, (int)(this.getY() + this.getHeight() - 1), (int)Color.WHITE.getRGB());
            }
        })));
        layout.arrangeElements();
    }

    protected void clearWidgets() {
        super.clearWidgets();
        this.parent.clearWidgets();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.parent.render(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.doneButton.active = this.isValidInput();
        try {
            int value = Integer.parseInt(this.newValueBox.getValue());
            this.newValueBox.setValue(String.valueOf(Math.min(value, this.challengeHolder.getRequiredPoints())));
            this.newValueBox.setTextColor(value > this.challengeHolder.getCurrentPoints() ? new Color(3931979).getRGB() : (value < this.challengeHolder.getCurrentPoints() ? new Color(0xFF5E5E).getRGB() : Color.WHITE.getRGB()));
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        int ticks = (int)Util.getMillis() / 4;
        RenderUtils.renderScrollingString((GuiGraphics)guiGraphics, (int)ticks, (Font)this.font, (Component)this.title, (boolean)true, (int)(this.leftPos + 10), (int)(this.topPos + 10), (int)135, (int)18, (int)4, (int)Color.WHITE.getRGB());
        RenderUtils.renderScrollingString((GuiGraphics)guiGraphics, (int)ticks, (Font)this.font, (Component)Component.literal((String)("" + this.challengeHolder.getCurrentPoints())), (boolean)false, (int)(this.leftPos + 29), (int)(this.topPos + 49), (int)36, (int)9, (int)1, (int)Color.GRAY.getRGB());
        this.renderArrow(guiGraphics);
    }

    private void renderArrow(GuiGraphics guiGraphics) {
        int value = this.getNewValue();
        boolean still = value == this.challengeHolder.getCurrentPoints();
        int minX = this.leftPos + (still ? 68 : 66);
        int minY = this.topPos + 48;
        int maxX = this.leftPos + 88;
        int maxY = this.topPos + 60;
        int arrowWidth = 19;
        int arrowHeight = 12;
        int spacing = 4;
        int speed = 50;
        int conveyorWidth = maxX - minX;
        int arrowTotalWidth = arrowWidth + spacing;
        int numArrows = conveyorWidth / arrowTotalWidth + 2;
        long currentTime = Util.getMillis();
        double offset = still ? 0.0 : (double)currentTime / 1000.0 * (double)speed;
        guiGraphics.enableScissor(minX, minY, maxX, maxY);
        for (int i = 0; i < numArrows; ++i) {
            int arrowX;
            if (still) {
                arrowX = minX + i * arrowTotalWidth;
            } else {
                arrowX = minX + i * arrowTotalWidth + (int)(offset % (double)arrowTotalWidth);
                if (arrowX > maxX) {
                    arrowX -= numArrows * arrowTotalWidth;
                }
            }
            if (arrowX + arrowWidth <= minX) continue;
            guiGraphics.blitSprite(ARROW_SPRITE, arrowX, minY, arrowWidth, arrowHeight);
        }
        guiGraphics.disableScissor();
    }

    private boolean isValidInput() {
        return this.getNewValue() != this.challengeHolder.getCurrentPoints();
    }

    private int getNewValue() {
        try {
            return Integer.parseInt(this.newValueBox.getValue());
        }
        catch (NumberFormatException e) {
            return this.challengeHolder.getCurrentPoints();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.isValidInput() && (keyCode == 257 || keyCode == 335)) {
            this.doneButton.onPress();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.newValueBox.isHovered() && button == 1) {
            this.newValueBox.setValue("");
            return true;
        }
        if (this.newValueBox.isFocused() && !this.newValueBox.isHovered()) {
            this.newValueBox.setFocused(false);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (this.newValueBox.isHoveredOrFocused()) {
            try {
                int value = (int)Mth.clamp((long)((long)this.getNewValue() + Math.round(scrollY)), (long)0L, (long)this.challengeHolder.getRequiredPoints());
                this.newValueBox.setValue(String.valueOf(value));
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        SkillsRecordScreen.OverlayColor color = (SkillsRecordScreen.OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
        guiGraphics.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        guiGraphics.blitSprite(BACKGROUND_SPRITE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen((Screen)this.parent.lock(false));
    }
}

