/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.components;

import java.awt.Color;
import java.util.Optional;
import net.ixdarklord.coolcatlib.api.util.ChatFormattingUtils;
import net.ixdarklord.ultimine_addition.common.data.item.MinerCertificateData;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MinerCertificateStatus {
    public static final MinerCertificateStatus INSTANCE = new MinerCertificateStatus();

    private MinerCertificateStatus() {
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker ignored) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        ItemStack stack = ItemUtils.findItemInHand((Player)player, (Item)ModItems.MINER_CERTIFICATE);
        if (stack.isEmpty()) {
            return;
        }
        MinerCertificateData data = MinerCertificateData.loadData(stack);
        Optional<MinerCertificateData.Legacy> optional = data.getLegacy();
        if (data.isAccomplished() || optional.isEmpty()) {
            return;
        }
        MinerCertificateData.Legacy legacy = optional.get();
        MutableComponent values = Component.literal((String)String.valueOf(legacy.getMinedBlocks())).withStyle(ChatFormattingUtils.get3LevelChatFormatting((int)legacy.getMinedBlocks(), (int)legacy.getRequiredAmount())).append((Component)Component.literal((String)"/")).append((Component)Component.literal((String)String.valueOf(legacy.getRequiredAmount())));
        MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.quest", (Object[])new Object[]{values});
        int textWidth = font.width((FormattedText)component);
        int x = (guiGraphics.guiWidth() - textWidth) / 2;
        int y = guiGraphics.guiHeight();
        y -= 66;
        if (minecraft.gui.overlayMessageTime > 0) {
            y -= 22;
        } else if (minecraft.gui.toolHighlightTimer > 0) {
            y -= 8;
        }
        ScreenRectangle rectangle = new ScreenRectangle(x, y, textWidth, 9);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)rectangle.left(), (int)rectangle.top(), (int)rectangle.width(), (int)rectangle.height(), (int)0);
        guiGraphics.drawString(font, (Component)component, x, y, Color.WHITE.getRGB());
    }
}

