/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.components;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.ixdarklord.coolcatlib.api.client.gui.components.ColorableImageButton;
import net.ixdarklord.coolcatlib.api.client.gui.components.widgets.AbstractDraggableWidget;
import net.ixdarklord.coolcatlib.api.util.ColorUtils;
import net.ixdarklord.ultimine_addition.client.gui.components.ColoredButton;
import net.ixdarklord.ultimine_addition.client.gui.components.TooltipInfo;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ConfigurationPanel
extends AbstractDraggableWidget {
    private static final ResourceLocation BACKGROUND_LOCATION = FTBUltimineAddition.rl("container/skills_record/configuration/background");
    private static final int BUTTON_WIDTH = 45;
    private static final int BUTTON_HEIGHT = 14;
    private final List<ColoredButton> buttons = Lists.newArrayList();

    public ConfigurationPanel(int x, int y) {
        super((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.configuration").withStyle(ChatFormatting.GRAY), x, y, 63, 102, true);
        this.visible = false;
        this.blitOffset = 600.0f;
    }

    public void init() {
        this.layout.defaultChildLayoutSetting().paddingVertical(2);
        LinearLayout linearLayout = (LinearLayout)this.layout.addChild((LayoutElement)LinearLayout.vertical().spacing(2));
        for (ColoredButton button : this.buttons) {
            button.setWidth(45 + this.getWidthSpacing());
        }
        for (ColoredButton button : this.buttons) {
            linearLayout.addChild((LayoutElement)button);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    protected void updateChildren() {
        super.updateChildren();
        this.title.setPosition(this.x + 9, this.y + 16);
        this.title.setSize(47 + this.getWidthSpacing(), 11);
        this.title.alignCenter();
        for (AbstractButton button : this.getButtons()) {
            if (!(button instanceof ColorableImageButton)) continue;
            ColorableImageButton imageButton = (ColorableImageButton)button;
            imageButton.setColor(this.getBGColor().convert());
        }
    }

    protected void renderBackground(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.setColor(this.getBGColor().getRed(), this.getBGColor().getGreen(), this.getBGColor().getBlue(), this.getBGColor().getAlpha());
        guiGraphics.blitSprite(BACKGROUND_LOCATION, this.getRectangle().left(), this.getRectangle().top(), this.getRectangle().width(), this.getRectangle().height());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int getButtonsTextLength() {
        int length = 0;
        for (AbstractButton abstractButton : this.buttons) {
            length = Math.max(this.font.width((FormattedText)abstractButton.getMessage()), length);
        }
        return Math.max(this.font.width((FormattedText)Component.translatable((String)"gui.ultimine_addition.skills_record.configuration")), length);
    }

    private int getWidthSpacing() {
        int length = this.getButtonsTextLength();
        return Math.max(length - 45 + 10, 0);
    }

    private int getHeightSpacing() {
        return Math.max(this.layout.getHeight() - 72, 0);
    }

    public void addButton(Button.OnPress onPress, Component component, Consumer<TooltipInfo> consumer) {
        ColoredButton button = new ColoredButton(this.x, this.y + 14 * this.getButtons().size(), 45, 14, SkillsRecordScreen.BUTTON_SPRITES, onPress, component, consumer){

            @Override
            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                TextColor color = this.getMessage().getStyle().getColor();
                color = color == null ? TextColor.fromRgb((int)Color.WHITE.getRGB()) : color;
                this.renderString(guiGraphics, ConfigurationPanel.this.font, color.getValue());
                this.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        };
        this.buttons.add(button);
    }

    public SkillsRecordScreen.OverlayColor getBGColor() {
        return (SkillsRecordScreen.OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
    }

    public ColorUtils getDraggingAreaColor() {
        return new ColorUtils(this.getBGColor().convert().getRGB());
    }

    @NotNull
    public ScreenRectangle getDraggingRectangle() {
        return new ScreenRectangle(this.getRectangle().position().x() + 8, this.getRectangle().position().y() + 5, this.getRectangle().width() - 16, 7);
    }

    @NotNull
    protected ScreenRectangle layoutRectangle() {
        return new ScreenRectangle(this.getRectangle().position().x() + 9, this.getRectangle().position().y() + 27, this.getRectangle().width() - 18, this.getRectangle().height() - 36);
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return this.applyIfVisible(new ScreenRectangle(this.x, this.y, this.width + this.getWidthSpacing(), this.height + this.getHeightSpacing()));
    }
}

