/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.client.gui.components;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.ixdarklord.coolcatlib.api.client.gui.components.animations.AnimatedComponent;
import net.ixdarklord.coolcatlib.api.client.gui.components.animations.SlideAnimation;
import net.ixdarklord.coolcatlib.api.util.ColorUtils;
import net.ixdarklord.coolcatlib.api.util.MathUtils;
import net.ixdarklord.coolcatlib.api.util.RenderUtils;
import net.ixdarklord.coolcatlib.api.util.ScreenPosition;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ChallengesInfoPanel {
    private static final ResourceLocation SLOT_INDICATOR_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"ultimine_addition", (String)"challenge_panel/slot_indicator");
    private static final ResourceLocation TITLE_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"ultimine_addition", (String)"challenge_panel/title");
    private static final ResourceLocation DESC_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"ultimine_addition", (String)"challenge_panel/description");
    public static final ChallengesInfoPanel INSTANCE = new ChallengesInfoPanel();
    private final int textureWidth = 112;
    private final int textureHeight = 32;
    private final List<Panel> PANEL_LIST = new ArrayList<Panel>();
    private Panel.Position panelPos = Panel.Position.LEFT;
    private float time;
    private float lastStamp;

    private ChallengesInfoPanel() {
    }

    private void tick(float partialTicks) {
        if (partialTicks < this.lastStamp) {
            this.time += 1.0f - this.lastStamp;
            this.time += partialTicks;
        } else {
            this.time += partialTicks - this.lastStamp;
        }
        this.lastStamp = partialTicks;
        this.updatePos();
    }

    private void updatePos() {
        this.panelPos = (Panel.Position)((Object)ConfigHandler.CLIENT.CHALLENGES_PANEL_POSITION.get());
        for (Panel panel : this.PANEL_LIST) {
            panel.getAnimatedComponent().setScreenPosition(this.panelPos.toScreenPos());
        }
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            return;
        }
        Minecraft MC = Minecraft.getInstance();
        if (MC.gui.getDebugOverlay().showDebugScreen()) {
            return;
        }
        Window window = MC.getWindow();
        Font font = MC.font;
        LocalPlayer player = MC.player;
        if (player == null) {
            return;
        }
        ItemStack stack = ItemUtils.findItemInHand((Player)player, (Item)ModItems.SKILLS_RECORD);
        if (stack == ItemStack.EMPTY) {
            this.slideOutPanels(this.PANEL_LIST.stream().filter(Panel::isNotTestPanel));
        }
        if (!MC.isPaused() && !this.PANEL_LIST.isEmpty()) {
            this.tick(deltaTracker.getGameTimeDeltaPartialTick(false));
        }
        if (!MC.isPaused()) {
            SkillsRecordData recordData = SkillsRecordData.loadData(stack);
            this.createPanels(recordData);
            this.validatePanels(recordData, window);
            this.PANEL_LIST.forEach(panel -> panel.animatedComponent.updateAnimation());
        }
        guiGraphics.pose().pushPose();
        int textLength = this.getTextLength(font);
        for (int slot = 0; slot < this.PANEL_LIST.size(); ++slot) {
            Panel panel2 = this.PANEL_LIST.get(slot);
            if (panel2.isNotActive()) continue;
            AnimatedComponent animatedComponent = panel2.getAnimatedComponent();
            if (animatedComponent.getScreenPosition() == null) break;
            int[] offsets = animatedComponent.getAnimatedOffsets(window.getGuiScaledWidth(), window.getGuiScaledHeight(), panel2.getWidth() + textLength, panel2.getHeight(), 4);
            int X = offsets[0];
            int Y = this.getAlignedYPos(offsets[1], slot, 4);
            SkillsRecordScreen.OverlayColor overlayColor = (SkillsRecordScreen.OverlayColor)((Object)ConfigHandler.CLIENT.BACKGROUND_COLOR.get());
            if (panel2.isNotMorePanel()) {
                RenderSystem.setShaderColor((float)overlayColor.getRed(), (float)overlayColor.getGreen(), (float)overlayColor.getBlue(), (float)overlayColor.getAlpha());
                guiGraphics.blitSprite(SLOT_INDICATOR_SPRITE, X + 5, Y, 51, 10);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int spacing = 13 * Math.min(panel2.getSlot(), 3);
                double value = MathUtils.cycledBetweenValues((float)0.0f, (float)1.0f, (float)0.8f, (float)(this.time / 20.0f), (boolean)false);
                Color color = ColorUtils.blendColors((Color)new Color(6991904), (Color)new Color(9036329), (double)((Boolean)ConfigHandler.CLIENT.ANIMATIONS_MODE.get() != false ? value : 0.0));
                guiGraphics.fill(X + 8 + spacing, Y + 3, X + 14 + spacing, Y + 9, color.getRGB());
                RenderSystem.setShaderColor((float)overlayColor.getRed(), (float)overlayColor.getGreen(), (float)overlayColor.getBlue(), (float)overlayColor.getAlpha());
                guiGraphics.blitSprite(TITLE_SPRITE, X, Y + 10, panel2.getWidth() + textLength, 11);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderStateShard.TRANSLUCENT_TRANSPARENCY.setupRenderState();
                RenderSystem.setShaderColor((float)overlayColor.getRed(), (float)overlayColor.getGreen(), (float)overlayColor.getBlue(), (float)overlayColor.getAlpha());
                int n = panel2.getWidth() + textLength;
                Objects.requireNonNull(font);
                guiGraphics.blitSprite(DESC_SPRITE, X, Y + 18, n, 14 + Math.max(0, 9 * (panel2.getInfos().size() - 1)));
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderStateShard.TRANSLUCENT_TRANSPARENCY.clearRenderState();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.drawCenteredString(font, panel2.getTitle(), X + (panel2.getWidth() + textLength) / 2, Y + 11, Color.WHITE.getRGB());
            } else {
                RenderSystem.setShaderColor((float)overlayColor.getRed(), (float)overlayColor.getGreen(), (float)overlayColor.getBlue(), (float)overlayColor.getAlpha());
                guiGraphics.blitSprite(TITLE_SPRITE, X, Y + 10, panel2.getWidth() + textLength, 11);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtils.renderScrollingString((GuiGraphics)guiGraphics, (int)((int)this.time * 8), (Font)font, (Component)panel2.getTitle(), (boolean)true, (int)X, (int)Y, (int)(panel2.getWidth() + textLength), (int)10, (int)4, (int)Color.WHITE.getRGB());
            }
            for (int i = 0; i < panel2.getInfos().size(); ++i) {
                Panel.Info info = panel2.getInfos().get(i);
                float value = (float)info.getCurrentValue() / (float)info.getRequiredValue() * 100.0f;
                int currentProgression = (int)value;
                MutableComponent values = Component.literal((String)("%" + currentProgression)).withStyle(currentProgression >= 100 ? ChatFormatting.GREEN : ChatFormatting.GOLD);
                int valuesXPos = font.width((FormattedText)values) - font.width("%0");
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int n = (int)this.time * 8;
                MutableComponent mutableComponent = info.getMessage().copy().withStyle(ChatFormatting.GRAY);
                Objects.requireNonNull(font);
                RenderUtils.renderScrollingString((GuiGraphics)guiGraphics, (int)n, (Font)font, (Component)mutableComponent, (boolean)false, (int)(X + 2), (int)(Y + 22 + 9 * i), (int)(94 + textLength - valuesXPos), (int)8, (int)0, (int)Color.WHITE.getRGB());
                Objects.requireNonNull(font);
                guiGraphics.drawString(font, (Component)values, X + textLength + 98 - valuesXPos, Y + 22 + 9 * i, Color.WHITE.getRGB());
            }
        }
        guiGraphics.pose().popPose();
    }

    public void createPanels(SkillsRecordData recordData) {
        ArrayList<Panel> trashList = new ArrayList<Panel>(this.PANEL_LIST.stream().filter(panel -> !panel.getAnimatedComponent().isPlaying()).filter(Panel::isNotMorePanel).filter(Panel::isNotTestPanel).toList());
        int i = 0;
        while (i < recordData.getCardSlots().size()) {
            int cardSlot = i++;
            ItemStack cardStack = (ItemStack)recordData.getCardSlots().get(cardSlot);
            MiningSkillCardData cardData = MiningSkillCardData.loadData(cardStack);
            cardData.getChallenges().forEach(challengeData -> {
                this.PANEL_LIST.removeIf(panel -> panel.getUUID() == null || !panel.getUUID().equals(recordData.getUUID()));
                List<Panel> list = this.PANEL_LIST.stream().filter(panel -> panel.getSlot() == cardSlot).toList();
                ChallengesManager manager = ChallengesManager.INSTANCE;
                ChallengesData challengesData = manager.getAllChallenges().get(challengeData.getId());
                MutableComponent message = Component.literal((String)challengeData.getId().toString());
                if (challengesData != null) {
                    List<ItemStack> items = manager.utilizeTargetedBlocks(challengesData).stream().map(ItemStack::new).toList();
                    message = SkillsRecordScreen.createChallengeDescription(challengesData.getChallengeType().getTypeName(), Style.EMPTY, items, SkillsRecordScreen.getItemCycle());
                }
                if (challengeData.isPinned()) {
                    if (list.isEmpty()) {
                        this.PANEL_LIST.add(new Panel(recordData.getUUID(), cardSlot, new Panel.TextureDimension(112, 32), (Component)Component.literal((String)((ItemStack)recordData.getCardSlots().get(cardSlot)).getHoverName().getString()), List.of(new Panel.Info(challengeData.getOrder(), challengeData.getId(), (Component)message, challengeData.getCurrentPoints(), challengeData.getRequiredPoints())), (AnimatedComponent)new SlideAnimation(this.panelPos.toScreenPos(), 60)));
                    } else {
                        panel = list.getFirst();
                        trashList.removeIf(panel1 -> panel1.equals(panel));
                        List<Panel.Info> infoList = panel.getInfos();
                        AnimatedComponent component = panel.getAnimatedComponent();
                        List<Panel.Info> filteredInfoList = infoList.stream().filter(info -> info.getChallengeId().equals((Object)challengeData.getId())).toList();
                        if (filteredInfoList.isEmpty()) {
                            infoList.add(new Panel.Info(challengeData.getOrder(), challengeData.getId(), (Component)message, challengeData.getCurrentPoints(), challengeData.getRequiredPoints()));
                        } else {
                            MutableComponent finalMessage = message;
                            filteredInfoList.forEach(arg_0 -> ChallengesInfoPanel.lambda$createPanels$6((Component)finalMessage, arg_0));
                            filteredInfoList.forEach(info -> {
                                info.setCurrentValue(challengeData.getCurrentPoints());
                                info.setRequiredValue(challengeData.getRequiredPoints());
                            });
                        }
                        if (component.isPlaying() && !component.isEnteringScene()) {
                            panel.getAnimatedComponent().startAnimation(true);
                        }
                    }
                } else if (!list.isEmpty()) {
                    panel = list.getFirst();
                    List<Panel.Info> infoList = panel.getInfos();
                    infoList.removeIf(info -> info.getChallengeId().equals((Object)challengeData.getId()));
                }
            });
        }
        this.slideOutPanels(trashList.stream());
    }

    private void validatePanels(SkillsRecordData recordData, Window window) {
        Panel panel2;
        this.PANEL_LIST.forEach(panel -> panel.setActive(true));
        int slot = this.PANEL_LIST.size();
        while (slot-- > 0) {
            Panel panel3 = this.PANEL_LIST.get(slot);
            if (panel3.isNotActive() || panel3.isMorePanel) continue;
            AnimatedComponent animatedComponent = panel3.getAnimatedComponent();
            if (animatedComponent.getScreenPosition() == null) break;
            int offsetY = animatedComponent.getAnimatedOffsets(0, window.getGuiScaledHeight(), 0, panel3.getHeight(), 4)[1];
            int Y = this.getAlignedYPos(offsetY, slot, 4);
            if (this.panelPos != Panel.Position.BOTTOM_LEFT && this.panelPos != Panel.Position.BOTTOM_RIGHT) {
                Y += panel3.getHeight();
            }
            if (Y >= 0 && Y <= window.getGuiScaledHeight() - 4) continue;
            if (this.panelPos == Panel.Position.BOTTOM_LEFT || this.panelPos == Panel.Position.BOTTOM_RIGHT) {
                this.PANEL_LIST.get(this.PANEL_LIST.size() - 1 - (slot + 1)).setActive(false);
                continue;
            }
            panel3.setActive(false);
        }
        int inactiveSlots = this.PANEL_LIST.stream().filter(Panel::isNotActive).toList().size();
        int slot2 = this.PANEL_LIST.size();
        while (slot2-- > 0) {
            panel2 = this.PANEL_LIST.get(slot2);
            AnimatedComponent component = panel2.getAnimatedComponent();
            if (component.isPlaying() && !panel2.isNotActive() || component.isEnteringScene()) continue;
            panel2.setRemoved();
        }
        List<Panel> list = this.PANEL_LIST.stream().filter(panel -> panel.getSlot() == 999).toList();
        if (inactiveSlots > 0) {
            if (list.isEmpty()) {
                this.PANEL_LIST.add(new Panel(recordData.getUUID(), 999, new Panel.TextureDimension(112, 12), (Component)Component.translatable((String)"gui.ultimine_addition.skills_record.pin.panel", (Object[])new Object[]{inactiveSlots}), null, (AnimatedComponent)new SlideAnimation(this.panelPos.toScreenPos(), 60), true, false));
            } else {
                panel2 = list.getFirst();
                panel2.setTitle((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.pin.panel", (Object[])new Object[]{inactiveSlots}));
                AnimatedComponent component = panel2.getAnimatedComponent();
                if (recordData.get() != ItemStack.EMPTY && component.isPlaying() && !component.isEnteringScene()) {
                    panel2.getAnimatedComponent().startAnimation(true);
                }
            }
        } else if (!list.isEmpty()) {
            this.slideOutPanels(list.stream());
        }
        this.PANEL_LIST.removeIf(Panel::isAssignedToRemove);
        this.PANEL_LIST.sort(Comparator.comparingInt(Panel::getSlot));
    }

    private int getTextLength(Font font) {
        int textLength = 0;
        for (Panel panel : this.PANEL_LIST) {
            if (panel.isNotActive() || !panel.isNotMorePanel()) continue;
            int titleWidth = font.width((FormattedText)panel.getTitle());
            int adjustedWidth = Math.max(0, titleWidth - panel.getWidth());
            textLength = Math.max(textLength, adjustedWidth);
        }
        return textLength > 0 ? textLength + 8 : 0;
    }

    private int getAlignedYPos(int yOffset, int slot, int padding) {
        int Y = yOffset;
        switch (this.panelPos.ordinal()) {
            case 1: 
            case 2: {
                for (int i = 0; i < slot; ++i) {
                    Panel panel = this.PANEL_LIST.get(i);
                    if (panel.isNotActive()) continue;
                    Y += panel.getHeight() + padding;
                }
                break;
            }
            case 3: 
            case 4: {
                Y += Math.max(0, this.PANEL_LIST.get(slot).getHeight() / 2);
                for (Panel panel : this.PANEL_LIST) {
                    if (panel.isNotActive()) continue;
                    Y -= panel.getHeight() / 2 + padding / 2;
                }
                for (int i = 0; i < slot; ++i) {
                    Panel panel;
                    panel = this.PANEL_LIST.get(i);
                    if (panel.isNotActive()) continue;
                    Y += panel.getHeight() + padding;
                }
                break;
            }
            case 5: 
            case 6: {
                for (int i = slot + 1; i < this.PANEL_LIST.size(); ++i) {
                    Panel panel = this.PANEL_LIST.get(i);
                    if (panel.isNotActive()) continue;
                    Y -= panel.getHeight() + padding;
                }
                break;
            }
        }
        return Y;
    }

    private void slideOutPanels(Stream<Panel> panelStream) {
        panelStream.map(Panel::getAnimatedComponent).filter(AnimatedComponent::isEnteringScene).forEach(component -> component.startAnimation(false));
    }

    public void setPanelPos(Panel.Position panelPos) {
        this.panelPos = panelPos;
    }

    public Panel.Position getPanelPos() {
        return this.panelPos;
    }

    private static /* synthetic */ void lambda$createPanels$6(Component finalMessage, Panel.Info info) {
        info.setMessage(finalMessage);
    }

    public static class Panel {
        private boolean active = true;
        private final UUID uuid;
        private final TextureDimension textureDimension;
        private final int slot;
        private Component title;
        private final List<Info> infos;
        private final AnimatedComponent animatedComponent;
        private boolean assignedToRemove;
        private final boolean isMorePanel;
        private final boolean isTestPanel;

        Panel(UUID uuid, int slot, TextureDimension textureDimension, Component title, List<Info> infos, AnimatedComponent animatedComponent) {
            this(uuid, slot, textureDimension, title, infos, animatedComponent, false, false, false);
        }

        Panel(UUID uuid, int slot, TextureDimension textureDimension, Component title, List<Info> infos, AnimatedComponent animatedComponent, boolean isMorePanel, boolean isTestPanel) {
            this(uuid, slot, textureDimension, title, infos, animatedComponent, false, isMorePanel, isTestPanel);
        }

        Panel(UUID uuid, int slot, TextureDimension textureDimension, Component title, List<Info> infos, AnimatedComponent animatedComponent, boolean assignedToRemove, boolean isMorePanel, boolean isTestPanel) {
            this.uuid = uuid;
            this.slot = slot;
            this.textureDimension = textureDimension;
            this.title = title;
            this.infos = infos == null ? new ArrayList<Info>() : new ArrayList<Info>(infos);
            this.animatedComponent = animatedComponent;
            this.assignedToRemove = assignedToRemove;
            this.isMorePanel = isMorePanel;
            this.isTestPanel = isTestPanel;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setTitle(Component title) {
            this.title = title;
        }

        public void setRemoved() {
            this.assignedToRemove = true;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public boolean isNotActive() {
            return !this.active;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getWidth() {
            return this.textureDimension.width();
        }

        public int getHeight() {
            int n = this.textureDimension.height();
            Objects.requireNonNull(Minecraft.getInstance().font);
            return n + Math.max(0, 9 * (this.infos.size() - 1));
        }

        public Component getTitle() {
            return this.title;
        }

        public List<Info> getInfos() {
            if (this.infos == null) {
                return new ArrayList<Info>();
            }
            this.infos.sort(Comparator.comparingInt(o -> o.order));
            return this.infos;
        }

        public AnimatedComponent getAnimatedComponent() {
            return this.animatedComponent;
        }

        public boolean isAssignedToRemove() {
            return this.assignedToRemove;
        }

        public boolean isNotMorePanel() {
            return !this.isMorePanel;
        }

        public boolean isNotTestPanel() {
            return !this.isTestPanel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Panel panel = (Panel)o;
            return this.active == panel.active && this.slot == panel.slot && this.assignedToRemove == panel.assignedToRemove && this.isMorePanel == panel.isMorePanel && this.isTestPanel == panel.isTestPanel && Objects.equals(this.uuid, panel.uuid) && Objects.equals(this.textureDimension, panel.textureDimension) && Objects.equals(this.title, panel.title) && Objects.equals(this.infos, panel.infos) && Objects.equals(this.animatedComponent, panel.animatedComponent);
        }

        public int hashCode() {
            return Objects.hash(this.active, this.uuid, this.textureDimension, this.slot, this.title, this.infos, this.animatedComponent, this.assignedToRemove, this.isMorePanel, this.isTestPanel);
        }

        public record TextureDimension(int width, int height) {
        }

        public static class Info {
            private final int order;
            private final ResourceLocation challengeId;
            private Component message;
            private int currentValue;
            private int requiredValue;

            private Info(int order, ResourceLocation challengeId, Component message, int currentValue, int requiredValue) {
                this.order = order;
                this.challengeId = challengeId;
                this.message = message;
                this.currentValue = currentValue;
                this.requiredValue = requiredValue;
            }

            public ResourceLocation getChallengeId() {
                return this.challengeId;
            }

            public Component getMessage() {
                return this.message;
            }

            public int getCurrentValue() {
                return this.currentValue;
            }

            public int getRequiredValue() {
                return this.requiredValue;
            }

            public void setMessage(Component message) {
                this.message = message;
            }

            public void setCurrentValue(int currentValue) {
                this.currentValue = currentValue;
            }

            public void setRequiredValue(int requiredValue) {
                this.requiredValue = requiredValue;
            }
        }

        public static enum Position implements StringRepresentable
        {
            DISABLED(-1, null),
            TOP_LEFT(0, ScreenPosition.TOP_LEFT),
            TOP_RIGHT(2, ScreenPosition.TOP_RIGHT),
            LEFT(3, ScreenPosition.LEFT),
            RIGHT(5, ScreenPosition.RIGHT),
            BOTTOM_LEFT(6, ScreenPosition.BOTTOM_LEFT),
            BOTTOM_RIGHT(8, ScreenPosition.BOTTOM_RIGHT);

            private final int posIndex;
            @Nullable
            private final ScreenPosition screenPos;

            private Position(int posIndex, ScreenPosition screenPos) {
                this.posIndex = posIndex;
                this.screenPos = screenPos;
            }

            @Nullable
            public ScreenPosition toScreenPos() {
                return this.screenPos;
            }

            public Position next() {
                int nextOrdinal = (this.ordinal() + 1) % Position.values().length;
                return Position.values()[nextOrdinal];
            }

            public Position previous() {
                int previousOrdinal = (this.ordinal() - 1 + Position.values().length) % Position.values().length;
                return Position.values()[previousOrdinal];
            }

            @NotNull
            public String getSerializedName() {
                return this.name().toLowerCase();
            }

            public int getPosIndex() {
                return this.posIndex;
            }
        }
    }
}

