/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.components.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class DetachedDrawerContents
implements TooltipComponent {
    public static final DetachedDrawerContents EMPTY = new DetachedDrawerContents(ItemStack.EMPTY, 0, false);
    public static final Codec<DetachedDrawerContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.optionalFieldOf("item", (Object)ItemStack.EMPTY).forGetter(DetachedDrawerContents::getItemPrototype), (App)Codec.INT.optionalFieldOf("itemCount", (Object)0).forGetter(DetachedDrawerContents::getItemCount), (App)Codec.INT.fieldOf("stackLimit").forGetter(DetachedDrawerContents::getStackLimit), (App)Codec.BOOL.fieldOf("heavy").forGetter(DetachedDrawerContents::isHeavy)).apply((Applicative)instance, DetachedDrawerContents::new));
    private final ItemStack item;
    private final int itemCount;
    private final int stackLimit;
    private final boolean heavy;

    public DetachedDrawerContents(ItemStack item, int itemCount, int stackLimit, boolean heavy) {
        this.item = item.copyWithCount(itemCount);
        this.itemCount = itemCount;
        this.stackLimit = stackLimit;
        this.heavy = heavy;
    }

    public DetachedDrawerContents(ItemStack item, int stackLimit, boolean heavy) {
        this(item, item.getCount(), stackLimit, heavy);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getItemPrototype() {
        return this.item == ItemStack.EMPTY ? ItemStack.EMPTY : this.item.copyWithCount(1);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getStackLimit() {
        return this.stackLimit;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DetachedDrawerContents) {
            DetachedDrawerContents contents = (DetachedDrawerContents)obj;
            return ItemStack.isSameItemSameComponents((ItemStack)this.item, (ItemStack)contents.getItem()) && this.itemCount == contents.getItemCount() && this.stackLimit == contents.getStackLimit() && this.heavy == contents.isHeavy();
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.getItem()) * 31 + this.stackLimit * 31 + this.itemCount * 31 + (this.heavy ? 1 : 0);
    }

    public String toString() {
        return "DetachedDrawerContents [item=" + String.valueOf(this.item) + ", count=" + this.itemCount + ", stackLimit=" + this.stackLimit + ", heavy=" + this.heavy + "]";
    }
}

