/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.widget;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class WeightSlider
extends AbstractSliderButton {
    private final double minValue;
    private final double maxValue;
    private final Component text;

    public WeightSlider(int x, int y, int width, int height, Component text, double minValue, double maxValue, double initialValue) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.value = (initialValue - minValue) / (maxValue - minValue);
        this.text = text;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.updateMessage();
    }

    private MutableComponent createMessage() {
        double weight = this.getWeight();
        String formattedValue = String.format("%.2f", weight);
        return this.text.copy().append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)formattedValue));
    }

    private double getWeight() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    protected void updateMessage() {
        this.setMessage((Component)this.createMessage());
    }

    protected abstract void applyWeight(double var1);

    protected void applyValue() {
        this.applyWeight(this.getWeight());
    }
}

