/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.widget;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;

public class ClickableWidgetList
extends ContainerObjectSelectionList<ListWidgetEntry> {
    private static final int ENTRY_WIDTH = 310;

    public ClickableWidgetList(Minecraft minecraftClient, List<List<AbstractWidget>> widgets, int width, int height, int headerHeight) {
        super(minecraftClient, width, height, headerHeight, 25);
        for (List<AbstractWidget> row : widgets) {
            this.addEntry((AbstractSelectionList.Entry)new ListWidgetEntry(row));
        }
    }

    public int getRowWidth() {
        return 310;
    }

    protected static class ListWidgetEntry
    extends ContainerObjectSelectionList.Entry<ListWidgetEntry> {
        private static final int PADDING = 10;
        private final List<AbstractWidget> widgets;

        ListWidgetEntry(List<AbstractWidget> widgets) {
            this.widgets = widgets;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.widgets.isEmpty()) {
                return;
            }
            int currentX = x;
            int widgetWidth = (310 - 10 * (this.widgets.size() - 1)) / this.widgets.size();
            for (AbstractWidget clickableWidget : this.widgets) {
                clickableWidget.setPosition(currentX, y);
                clickableWidget.setWidth(widgetWidth);
                clickableWidget.render(context, mouseX, mouseY, tickDelta);
                currentX += widgetWidth + 10;
            }
        }

        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }

        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }
    }
}

