/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.Constants;
import net.spacerulerwill.skygrid_reloaded.platform.Services;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.TextField;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;

public class SkyGridPresetsScreen
extends Screen {
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 33, 64);
    private final CustomizeSkyGridScreen parent;
    private final RegistryAccess.Frozen dynamicRegistryManager;
    private TextField textField;
    private Button selectPresetButton;
    private Button savePresetButton;
    private SkyGridPresetListWidget listWidget;

    protected SkyGridPresetsScreen(CustomizeSkyGridScreen parent, RegistryAccess.Frozen dynamicRegistryManager) {
        super((Component)Component.translatable((String)"createWorld.customize.skygrid.presets"));
        this.parent = parent;
        this.dynamicRegistryManager = dynamicRegistryManager;
        Common.reloadCustomPresets((HolderLookup.Provider)this.dynamicRegistryManager);
    }

    protected void init() {
        this.layout.addTitleHeader(this.title, this.font);
        this.listWidget = (SkyGridPresetListWidget)this.layout.addToContents((LayoutElement)new SkyGridPresetListWidget());
        LinearLayout rows = LinearLayout.vertical().spacing(4);
        LinearLayout row1 = LinearLayout.horizontal().spacing(8);
        this.selectPresetButton = (Button)row1.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"createWorld.skygrid.customize.presets.select"), buttonWidget -> {
            SkyGridPresetListWidget.SkyGridPresetEntry entry = (SkyGridPresetListWidget.SkyGridPresetEntry)this.listWidget.getSelected();
            this.parent.setConfigFromPreset(entry.preset);
            this.parent.updateBiomeScaleSlider();
            this.minecraft.setScreen((Screen)this.parent);
        }).build());
        row1.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen((Screen)this.parent)).build());
        rows.addChild((LayoutElement)row1);
        LinearLayout row2 = LinearLayout.horizontal().spacing(8);
        this.textField = (TextField)row2.addChild((LayoutElement)new PresetsTextField());
        this.savePresetButton = (Button)row2.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"createWorld.skygrid.customize.presets.save"), buttonWidget -> this.savePreset(this.textField.getValue())).build());
        rows.addChild((LayoutElement)row2);
        rows.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.addToFooter((LayoutElement)rows);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.updateSelectPresetButtonActive();
        this.repositionElements();
        this.updateSaveButtonActive();
    }

    private void updateSaveButtonActive() {
        this.savePresetButton.active = !this.textField.getValue().isEmpty();
    }

    protected void repositionElements() {
        if (this.listWidget != null) {
            this.listWidget.updateSize(this.width, this.layout);
        }
        this.layout.arrangeElements();
    }

    public void updateSelectPresetButtonActive() {
        this.selectPresetButton.active = this.listWidget.getSelected() != null;
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parent);
    }

    private void savePreset(String name) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(name.getBytes(StandardCharsets.UTF_8));
            String hashedName = Hex.encodeHexString((byte[])hash);
            SkyGridConfig currentConfig = this.parent.getCurrentSkyGridConfig();
            boolean maxWeight = false;
            ArrayList<Item> allItems = new ArrayList<Item>();
            SkyGridChunkGeneratorConfig overworldConfig = currentConfig.dimensions.get(LevelStem.OVERWORLD);
            overworldConfig.blocks.keySet().stream().map(Block::asItem).forEach(allItems::add);
            allItems.addAll(overworldConfig.chestItems.keySet());
            SkyGridChunkGeneratorConfig netherConfig = currentConfig.dimensions.get(LevelStem.NETHER);
            netherConfig.blocks.keySet().stream().map(Block::asItem).forEach(allItems::add);
            allItems.addAll(netherConfig.chestItems.keySet());
            SkyGridChunkGeneratorConfig endConfig = currentConfig.dimensions.get(LevelStem.END);
            endConfig.blocks.keySet().stream().map(Block::asItem).forEach(allItems::add);
            allItems.addAll(endConfig.chestItems.keySet());
            Random random = new Random();
            Item icon = (Item)allItems.get(random.nextInt(allItems.size()));
            SkyGridPreset preset = new SkyGridPreset(icon, name, currentConfig);
            JsonObject element = new JsonObject();
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.dynamicRegistryManager);
            DataResult json = SkyGridPreset.CODEC_V2.encode((Object)preset, (DynamicOps)ops, (Object)element);
            String jsonString = ((JsonElement)json.getOrThrow()).toString();
            String fileName = Services.PLATFORM.getConfigPath().toString() + "/skygrid_reloaded/" + hashedName + ".json";
            try (PrintWriter writer = new PrintWriter(fileName, StandardCharsets.UTF_8);){
                writer.write(jsonString);
            }
            Common.reloadCustomPresets((HolderLookup.Provider)this.dynamicRegistryManager);
            this.listWidget.refreshEntries();
        }
        catch (Exception e) {
            Constants.LOGGER.error("Failed to save preset {}: {}", (Object)name, (Object)e);
        }
    }

    private class SkyGridPresetListWidget
    extends ObjectSelectionList<SkyGridPresetEntry> {
        public SkyGridPresetListWidget() {
            super(SkyGridPresetsScreen.this.minecraft, SkyGridPresetsScreen.this.width, SkyGridPresetsScreen.this.height - 77, 33, 24);
            this.refreshEntries();
        }

        public void refreshEntries() {
            this.clearEntries();
            for (SkyGridPreset preset : Common.PRESETS) {
                this.addEntry((AbstractSelectionList.Entry)new SkyGridPresetEntry(preset));
            }
            for (SkyGridPreset preset : Common.CUSTOM_PRESETS) {
                this.addEntry((AbstractSelectionList.Entry)new SkyGridCustomPresetEntry(preset));
            }
        }

        public void setSelected(@Nullable SkyGridPresetEntry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
            SkyGridPresetsScreen.this.updateSelectPresetButtonActive();
        }

        public class SkyGridPresetEntry
        extends ObjectSelectionList.Entry<SkyGridPresetEntry> {
            private static final ResourceLocation SLOT_TEXTURE = ResourceLocation.withDefaultNamespace((String)"container/slot");
            private final SkyGridPreset preset;

            public SkyGridPresetEntry(SkyGridPreset preset) {
                this.preset = preset;
            }

            public Component getNarration() {
                return Component.empty();
            }

            public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.blitSprite(SLOT_TEXTURE, x + 1, y + 1, 0, 18, 18);
                context.renderFakeItem(this.preset.item.getDefaultInstance(), x + 2, y + 2);
                context.drawString(SkyGridPresetsScreen.this.font, (Component)Component.translatable((String)this.preset.name), x + 18 + 5, y + 3, 0xFFFFFF, false);
            }
        }

        public class SkyGridCustomPresetEntry
        extends SkyGridPresetEntry {
            private final Button deleteButton;

            public SkyGridCustomPresetEntry(SkyGridPreset preset) {
                super(preset);
                this.deleteButton = Button.builder((Component)Component.translatable((String)"createWorld.skygrid.customize.presets.delete"), button -> {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        byte[] hash = digest.digest(preset.name.getBytes(StandardCharsets.UTF_8));
                        String hashedName = Hex.encodeHexString((byte[])hash);
                        String fileName = Services.PLATFORM.getConfigPath().toString() + "/skygrid_reloaded/" + hashedName + ".json";
                        File file = new File(fileName);
                        Files.deleteIfExists(file.toPath());
                        Common.reloadCustomPresets((HolderLookup.Provider)SkyGridPresetsScreen.this.dynamicRegistryManager);
                        SkyGridPresetListWidget.this.removeEntry((AbstractSelectionList.Entry)this);
                    }
                    catch (Exception e) {
                        Constants.LOGGER.error("Failed to delete preset {}: {}", (Object)preset, (Object)e);
                    }
                }).width(50).build();
            }

            @Override
            public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                super.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
                this.deleteButton.setX(x + entryWidth - this.deleteButton.getWidth() - 5);
                this.deleteButton.setY(y);
                this.deleteButton.render(context, mouseX, mouseY, tickDelta);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.deleteButton.isMouseOver(mouseX, mouseY)) {
                    return this.deleteButton.mouseClicked(mouseX, mouseY, button);
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }
    }

    protected class PresetsTextField
    extends TextField {
        public PresetsTextField() {
            super(SkyGridPresetsScreen.this.font, 150, 20, (Component)Component.empty());
        }

        @Override
        protected void onTextChanged() {
            SkyGridPresetsScreen.this.updateSaveButtonActive();
        }
    }
}

