/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.dimension.LevelStem;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.util.RenderUtils;
import net.spacerulerwill.skygrid_reloaded.ui.widget.TextField;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DimensionSpecificCustomizableListWidgetScreen<T extends ObjectSelectionList.Entry<T>, V>
extends Screen {
    private static final Component CLEAR_TEXT = Component.translatable((String)"createWorld.customize.skygrid.clear");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Component title;
    private final Component textFieldPlaceholder;
    private final CustomizeSkyGridScreen parent;
    private final int entryHeight;
    protected ListWidget listWidget;
    protected SearchTextField textField;
    protected ResourceKey<LevelStem> currentDimension;
    private final List<ResourceKey<LevelStem>> dimensions;
    protected SkyGridConfig currentConfig;
    private Button addButton;
    private Button deleteButton;
    private CycleButton<ResourceKey<LevelStem>> dimensionsSelector;
    private Button doneButton;
    private Button cancelButton;

    public DimensionSpecificCustomizableListWidgetScreen(CustomizeSkyGridScreen parent, List<ResourceKey<LevelStem>> dimensions, ResourceKey<LevelStem> initialDimension, SkyGridConfig currentConfig, Component title, Component textFieldPlaceholder, int entryHeight) {
        super(title);
        this.title = title;
        this.textFieldPlaceholder = textFieldPlaceholder;
        this.entryHeight = entryHeight;
        this.parent = parent;
        this.currentConfig = new SkyGridConfig(currentConfig);
        this.currentDimension = initialDimension;
        this.dimensions = dimensions;
    }

    private void initHeader() {
        this.layout.addTitleHeader(this.title, this.font);
    }

    private void initBody() {
        this.listWidget = (ListWidget)this.layout.addToContents((LayoutElement)new ListWidget(this.minecraft, this.width, this.height - 117, 43, this.entryHeight));
    }

    private void initFooter() {
        LinearLayout rows = LinearLayout.vertical().spacing(4);
        LinearLayout row1 = LinearLayout.horizontal().spacing(8);
        this.doneButton = (Button)row1.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.parent.updateSkyGridConfig(this.currentConfig);
            this.onClose();
        }).width(75).build());
        this.cancelButton = (Button)row1.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).width(75).build());
        row1.addChild((LayoutElement)Button.builder((Component)CLEAR_TEXT, button -> {
            this.onClear();
            this.listWidget.clearEntries();
            this.listWidget.setScrollAmount(0.0);
            this.updateAddButtonActive();
        }).width(75).build());
        LinearLayout row2 = LinearLayout.horizontal().spacing(8);
        this.dimensionsSelector = (CycleButton)row2.addChild((LayoutElement)new CycleButton.Builder(value -> Component.translatable((String)value.location().toLanguageKey())).withValues(this.dimensions).withInitialValue(this.currentDimension).create(0, 0, 158, 20, (Component)Component.translatable((String)"createWorld.customize.skygrid.dimension"), (button, dimension) -> {
            this.currentDimension = dimension;
            this.regenerateListEntries();
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
        }));
        this.deleteButton = (Button)row2.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"createWorld.customize.skygrid.delete"), button -> {
            ObjectSelectionList.Entry entry = (ObjectSelectionList.Entry)this.listWidget.getSelected();
            if (entry == null) {
                return;
            }
            this.listWidget.removeEntry(entry);
            this.onDelete(entry);
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
        }).width(75).build());
        LinearLayout row3 = LinearLayout.horizontal().spacing(8);
        this.textField = (SearchTextField)row3.addChild((LayoutElement)new SearchTextField(this.font, 158, 20, this.textFieldPlaceholder));
        this.addButton = (Button)row3.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"createWorld.customize.skygrid.add"), button -> {
            Optional<V> v = this.getSelectedThing();
            v.ifPresent(this::onAdd);
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
            this.listWidget.setScrollAmount(this.listWidget.getMaxScroll());
        }).width(75).build());
        rows.addChild((LayoutElement)row3);
        rows.addChild((LayoutElement)row2);
        rows.addChild((LayoutElement)row1);
        this.layout.addToFooter((LayoutElement)rows);
        this.layout.setFooterHeight(80);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AtomicBoolean mouseOverAnyWidget = new AtomicBoolean(false);
        this.layout.visitWidgets(widget -> {
            if (widget.isMouseOver(mouseX, mouseY)) {
                mouseOverAnyWidget.set(true);
            }
        });
        if (!(mouseOverAnyWidget.get() || this.textField.isMouseOver(mouseX, mouseY) || this.textField.autocompleteListWidget != null && this.textField.autocompleteListWidget.isMouseOver(mouseX, mouseY))) {
            if (this.textField.autocompleteListWidget != null) {
                this.removeWidget((GuiEventListener)this.textField.autocompleteListWidget);
                this.showWidgetsForAutocompleteBox();
                this.textField.autocompleteListWidget = null;
            }
            this.textField.setFocused(false);
        } else if (this.textField.isMouseOver(mouseX, mouseY) && this.textField.autocompleteListWidget == null) {
            this.textField.doAutocompleteStuff();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void init() {
        this.initHeader();
        this.initBody();
        this.initFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.regenerateListEntries();
        this.repositionElements();
        this.updateAddButtonActive();
        this.updateDeleteButtonActive();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.listWidget != null) {
            this.listWidget.updateSize(this.width, this.layout);
        }
        this.textField.refreshPositions();
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)this.parent);
        }
    }

    private void regenerateListEntries() {
        this.listWidget.replaceEntries(this.getEntriesFromConfig());
        this.listWidget.setScrollAmount(0.0);
    }

    private void updateAddButtonActive() {
        Optional<V> thing = this.getSelectedThing();
        this.addButton.active = thing.isPresent() && this.canAdd(thing.get());
    }

    private void updateDeleteButtonActive() {
        ObjectSelectionList.Entry entry = (ObjectSelectionList.Entry)this.listWidget.getSelected();
        this.deleteButton.active = entry != null;
    }

    private void hideWidgetsForAutocompleteBox() {
        this.removeWidget((GuiEventListener)this.doneButton);
        this.removeWidget((GuiEventListener)this.cancelButton);
        this.removeWidget((GuiEventListener)this.dimensionsSelector);
    }

    private void showWidgetsForAutocompleteBox() {
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.addRenderableWidget((GuiEventListener)this.dimensionsSelector);
    }

    protected abstract void onClear();

    protected abstract Optional<V> getThingFromString(String var1);

    protected abstract List<AutocompleteListWidget.Entry> getAutocompleteSuggestions(String var1);

    protected abstract void onAdd(V var1);

    protected abstract boolean canAdd(V var1);

    protected abstract void onDelete(T var1);

    protected abstract List<T> getEntriesFromConfig();

    private Optional<V> getSelectedThing() {
        AutocompleteListWidget.Entry entry;
        Optional thing1 = this.getThingFromString(this.textField.getValue());
        Optional<Object> thing2 = Optional.empty();
        if (this.textField.autocompleteListWidget != null && (entry = (AutocompleteListWidget.Entry)this.textField.autocompleteListWidget.getSelected()) != null) {
            thing2 = this.getThingFromString(entry.valueText);
        }
        return thing2.or(() -> thing1);
    }

    protected class ListWidget
    extends ObjectSelectionList<T> {
        public ListWidget(Minecraft minecraftClient, int i, int j, int k, int l) {
            super(minecraftClient, i, j, k, l);
        }

        public void setSelected(@Nullable T entry) {
            super.setSelected(entry);
            DimensionSpecificCustomizableListWidgetScreen.this.updateDeleteButtonActive();
        }

        public void clearEntries() {
            super.clearEntries();
        }

        public boolean removeEntry(@NotNull T entry) {
            return super.removeEntry(entry);
        }

        public int addEntry(@NotNull T entry) {
            return super.addEntry(entry);
        }

        public void replaceEntries(@NotNull Collection<T> entries) {
            super.replaceEntries(entries);
        }
    }

    protected class SearchTextField
    extends TextField {
        @Nullable
        public AutocompleteListWidget autocompleteListWidget;

        public SearchTextField(Font textRenderer, int x, int y, Component text) {
            super(textRenderer, x, y, text);
            this.setMaxLength(1024);
        }

        private void refreshPositions() {
            if (this.autocompleteListWidget != null) {
                this.autocompleteListWidget.setX(this.getX());
                this.autocompleteListWidget.setY(this.getY() + this.getHeight() + 4);
            }
        }

        private void doAutocompleteStuff() {
            DimensionSpecificCustomizableListWidgetScreen.this.updateAddButtonActive();
            List<AutocompleteListWidget.Entry> autocompleteResults = DimensionSpecificCustomizableListWidgetScreen.this.getAutocompleteSuggestions(this.getValue());
            if (autocompleteResults.isEmpty()) {
                if (this.autocompleteListWidget != null) {
                    DimensionSpecificCustomizableListWidgetScreen.this.removeWidget((GuiEventListener)this.autocompleteListWidget);
                    DimensionSpecificCustomizableListWidgetScreen.this.showWidgetsForAutocompleteBox();
                    this.autocompleteListWidget = null;
                }
            } else if (this.autocompleteListWidget == null) {
                this.autocompleteListWidget = new AutocompleteListWidget(DimensionSpecificCustomizableListWidgetScreen.this.minecraft, DimensionSpecificCustomizableListWidgetScreen.this);
                this.refreshPositions();
                for (AutocompleteListWidget.Entry entry : autocompleteResults) {
                    this.autocompleteListWidget.addEntry(entry);
                }
                DimensionSpecificCustomizableListWidgetScreen.this.addRenderableWidget((GuiEventListener)this.autocompleteListWidget);
                DimensionSpecificCustomizableListWidgetScreen.this.hideWidgetsForAutocompleteBox();
            } else {
                this.autocompleteListWidget.replaceEntries(autocompleteResults);
            }
        }

        @Override
        protected void onTextChanged() {
            this.doAutocompleteStuff();
        }
    }

    public static class AutocompleteListWidget
    extends ObjectSelectionList<Entry> {
        DimensionSpecificCustomizableListWidgetScreen<?, ?> parent;

        public AutocompleteListWidget(Minecraft minecraftClient, DimensionSpecificCustomizableListWidgetScreen<?, ?> parent) {
            super(minecraftClient, 158, 44, 0, 24);
            this.parent = parent;
        }

        public int addEntry(Entry entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public int getRowWidth() {
            return this.getWidth() - 16;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                Entry entry = (Entry)this.getEntry(i);
                if (!entry.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
            return super.isMouseOver(mouseX, mouseY);
        }

        protected void replaceEntries(@NotNull Collection<Entry> entries) {
            super.replaceEntries(entries);
        }

        public void setSelected(@Nullable Entry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
            this.parent.updateAddButtonActive();
        }

        public static class Entry
        extends ObjectSelectionList.Entry<Entry> {
            public final String valueText;
            @Nullable
            private final Item iconItem;
            private final String displayText;
            private final Font textRenderer;

            public Entry(@Nullable Item iconItem, String displayText, String valueText, Font textRenderer) {
                this.iconItem = iconItem;
                this.displayText = displayText;
                this.valueText = valueText;
                this.textRenderer = textRenderer;
            }

            public Component getNarration() {
                return Component.empty();
            }

            public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.iconItem == null) {
                    context.drawString(this.textRenderer, this.displayText, x + 5, y + 5, 0xFFFFFF, false);
                } else {
                    RenderUtils.renderItemIcon(this.iconItem, context, x, y);
                    context.drawString(this.textRenderer, this.displayText, x + 18 + 5, y + 5, 0xFFFFFF, false);
                }
            }
        }
    }
}

