/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.LevelStem;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.DimensionSpecificCustomizableListWidgetScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.WeightSliderListWidgetEntry;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

public class CustomizeBlocksScreen
extends DimensionSpecificCustomizableListWidgetScreen<BlockWeightListEntry, Block> {
    private static final double INITIAL_BLOCK_WEIGHT = 160.0;
    private static final double MIN_BLOCK_WEIGHT = 0.0;
    private static final double MAX_BLOCK_WEIGHT = 500.0;

    public CustomizeBlocksScreen(CustomizeSkyGridScreen parent, List<ResourceKey<LevelStem>> dimensions, ResourceKey<LevelStem> initialDimension, SkyGridConfig currentConfig) {
        super(parent, dimensions, initialDimension, currentConfig, (Component)Component.translatable((String)"createWorld.customize.skygrid.blocks"), (Component)Component.translatable((String)"createWorld.customize.skygrid.blocks.placeholder"), 25);
    }

    private static Item getBlockItem(Block block) {
        if (block.equals(Blocks.LAVA)) {
            return Items.LAVA_BUCKET;
        }
        if (block.equals(Blocks.WATER)) {
            return Items.WATER_BUCKET;
        }
        return block.asItem();
    }

    @Override
    public void onClear() {
        Map<Block, Double> blocks = this.getCurrentBlocks();
        blocks.clear();
    }

    @Override
    protected Optional<Block> getThingFromString(String text) {
        try {
            return BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)text));
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> results = new ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry>();
        if (text.isBlank()) {
            return results;
        }
        BuiltInRegistries.BLOCK.forEach(block -> {
            String displayString = Component.translatable((String)block.getDescriptionId()).getString();
            String valueString = BuiltInRegistries.BLOCK.getKey(block).toString();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry(CustomizeBlocksScreen.getBlockItem(block), displayString, valueString, this.font));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(Block block) {
        Map<Block, Double> blocks = this.getCurrentBlocks();
        if (blocks.containsKey(block)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        blocks.put(block, 160.0);
        this.listWidget.addEntry(new BlockWeightListEntry(block));
    }

    @Override
    protected boolean canAdd(Block block) {
        return !this.getCurrentBlocks().containsKey(block);
    }

    @Override
    protected void onDelete(BlockWeightListEntry entry) {
        Map<Block, Double> blocks = this.getCurrentBlocks();
        blocks.remove(entry.block);
    }

    private Map<Block, Double> getCurrentBlocks() {
        return this.currentConfig.dimensions.get((Object)this.currentDimension).blocks;
    }

    @Override
    protected List<BlockWeightListEntry> getEntriesFromConfig() {
        ArrayList<BlockWeightListEntry> entries = new ArrayList<BlockWeightListEntry>();
        Map<Block, Double> blocks = this.getCurrentBlocks();
        for (Map.Entry<Block, Double> entry : blocks.entrySet()) {
            Block block = entry.getKey();
            double weight = entry.getValue();
            entries.add(new BlockWeightListEntry(block, weight));
        }
        return entries;
    }

    public class BlockWeightListEntry
    extends WeightSliderListWidgetEntry<BlockWeightListEntry> {
        private final Block block;

        public BlockWeightListEntry(Block block) {
            super((Component)block.getName(), 0.0, 500.0, 160.0);
            this.block = block;
        }

        public BlockWeightListEntry(Block block, double initialWeight) {
            super((Component)block.getName(), 0.0, 500.0, initialWeight);
            this.block = block;
        }

        @Override
        public void applyWeight(double weight) {
            Map<Block, Double> blocks = CustomizeBlocksScreen.this.getCurrentBlocks();
            blocks.put(this.block, weight);
        }

        @Override
        public Item getIcon() {
            return CustomizeBlocksScreen.getBlockItem(this.block);
        }
    }
}

