/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded;

import com.mojang.serialization.MapCodec;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGenerator;
import org.jetbrains.annotations.NotNull;

@Mod(value="skygrid_reloaded")
public class SkyGridReloaded {
    public static final DeferredRegister<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = DeferredRegister.create((Registry)BuiltInRegistries.CHUNK_GENERATOR, (String)"skygrid_reloaded");

    public SkyGridReloaded(IEventBus eventBus) {
        CHUNK_GENERATORS.register("skygrid", resourceLocation -> SkyGridChunkGenerator.MAP_CODEC);
        CHUNK_GENERATORS.register(eventBus);
        NeoForge.EVENT_BUS.register(EventHandler.class);
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void reload(AddReloadListenerEvent event) {
            final HolderLookup.Provider wrapperLookup = event.getServerResources().getRegistryLookup();
            event.addListener(new PreparableReloadListener(){

                @NotNull
                public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profileFiller, @NotNull ProfilerFiller profilerFiller1, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
                    return CompletableFuture.runAsync(() -> Common.onResourceManagerReload(wrapperLookup, resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
                }
            });
        }
    }
}

