/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.api.FTBUltimineAPI;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record SendShapePacket(int shapeIdx, Optional<List<BlockPos>> blocks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendShapePacket> TYPE = new CustomPacketPayload.Type(FTBUltimineAPI.id("send_shape_packet"));
    public static final StreamCodec<FriendlyByteBuf, SendShapePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SendShapePacket::shapeIdx, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list())), SendShapePacket::blocks, SendShapePacket::new);

    public static SendShapePacket adjustShapeOnly(int shapeIdx) {
        return new SendShapePacket(shapeIdx, Optional.empty());
    }

    public static SendShapePacket adjustShapeAndBlockPos(int shapeIdx, List<BlockPos> blocks) {
        return new SendShapePacket(shapeIdx, Optional.of(blocks));
    }

    public CustomPacketPayload.Type<SendShapePacket> type() {
        return TYPE;
    }

    public static void handle(SendShapePacket message, NetworkManager.PacketContext context) {
        context.queue(() -> FTBUltimine.instance.proxy.setShape(message.shapeIdx, message.blocks.orElse(null)));
    }
}

