/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.power;

import java.math.BigInteger;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class CustomEnergyStorage
implements IEnergyStorage,
INBTSerializable<Tag> {
    public static final String ENERGY_TAG = "Energy";
    public static final String IN_TAG = "In";
    public static final String OUT_TAG = "Out";
    private long energy;
    private final long capacity;
    private final long maxReceive;
    private final long maxExtract;
    protected final boolean creative;
    private final AverageCalculator in = new AverageCalculator();
    private final AverageCalculator out = new AverageCalculator();
    private BigInteger energyIn = BigInteger.ZERO;
    private BigInteger energyOut = BigInteger.ZERO;
    private long averageIn;
    private long averageOut;

    public CustomEnergyStorage(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, false);
    }

    public CustomEnergyStorage(long capacity, long maxReceive, long maxExtract, boolean creative) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.creative = creative;
        this.energy = creative ? Long.MAX_VALUE : 0L;
    }

    public void tick() {
        this.in.tick(this.energyIn);
        this.out.tick(this.energyOut);
        this.averageIn = this.in.getAverage();
        this.averageOut = this.out.getAverage();
        this.energyIn = BigInteger.ZERO;
        this.energyOut = BigInteger.ZERO;
    }

    public void setEnergy(long energy) {
        if (energy > 0L) {
            this.energyIn = this.energyIn.add(BigInteger.valueOf(energy));
        } else {
            this.energyOut = this.energyOut.subtract(BigInteger.valueOf(energy));
        }
        if (!this.creative) {
            this.setEnergyInternal(energy);
        }
    }

    protected void setEnergyInternal(long energy) {
        this.energy += energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long received = this.receiveLongEnergy(maxReceive, simulate);
        return received > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long extracted = this.extractLongEnergy(maxExtract, simulate);
        return extracted > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)extracted;
    }

    public int getEnergyStored() {
        return this.energy > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.capacity;
    }

    public long receiveLongEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.getLongEnergyStored(), Math.min(this.getMaxInput(), maxReceive));
        if (!simulate) {
            this.setEnergy(energyReceived);
        }
        return this.creative ? maxReceive : energyReceived;
    }

    public long extractLongEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.getLongEnergyStored(), Math.min(this.getMaxOutput(), maxExtract));
        if (!simulate) {
            this.setEnergy(-energyExtracted);
        }
        return energyExtracted;
    }

    public long getLongEnergyStored() {
        return this.energy;
    }

    public long getLongMaxEnergyStored() {
        return this.creative ? Long.MAX_VALUE : this.capacity;
    }

    public boolean canExtract() {
        return this.creative || this.maxExtract > 0L;
    }

    public boolean canReceive() {
        return this.creative || this.maxReceive > 0L;
    }

    public long getMaxInput() {
        return this.creative ? Long.MAX_VALUE : this.maxReceive;
    }

    public long getMaxOutput() {
        return this.creative ? Long.MAX_VALUE : this.maxExtract;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            this.energy = compound.getLong(ENERGY_TAG);
            this.averageIn = compound.getLong(IN_TAG);
            this.averageOut = compound.getLong(OUT_TAG);
        }
    }

    public @UnknownNullability Tag serializeNBT(@NotNull HolderLookup.Provider registries) {
        CompoundTag compound = new CompoundTag();
        compound.putLong(ENERGY_TAG, this.getLongEnergyStored());
        compound.putLong(IN_TAG, this.in.getAverage());
        compound.putLong(OUT_TAG, this.out.getAverage());
        return compound;
    }

    public long getAverageIn() {
        return this.averageIn;
    }

    public long getAverageOut() {
        return this.averageOut;
    }

    public boolean isCreative() {
        return this.creative;
    }

    private static class AverageCalculator {
        private BigInteger lastTotal = BigInteger.ZERO;
        private int tickCount;
        private final BigInteger[] cache = new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
        private int writeIndex;
        private int writeSize;

        private AverageCalculator() {
        }

        public long getAverage() {
            int ticks = this.tickCount + this.writeSize * 20;
            if (ticks == 0) {
                return 0L;
            }
            BigInteger total = this.lastTotal;
            int i = this.writeIndex;
            int c = this.writeSize;
            while (c-- > 0) {
                total = total.add(this.cache[i]);
                if (++i != this.cache.length) continue;
                i = 0;
            }
            return total.divide(BigInteger.valueOf(ticks)).longValue();
        }

        public void tick(BigInteger val) {
            this.lastTotal = this.lastTotal.add(val);
            ++this.tickCount;
            if (this.tickCount == 20) {
                this.cache[this.writeIndex++] = this.lastTotal;
                if (this.writeIndex > this.writeSize) {
                    this.writeSize = this.writeIndex;
                }
                if (this.writeIndex == this.cache.length) {
                    this.writeIndex = 0;
                }
                this.lastTotal = BigInteger.ZERO;
                this.tickCount = 0;
            }
        }
    }
}

