/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.block.BlockRegistry;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.block.entity.ChargerItemStackHandler;
import se.gory_moon.chargers.inventory.ChargerData;
import se.gory_moon.chargers.inventory.ChargerDataSlot;
import se.gory_moon.chargers.inventory.InputSlot;
import se.gory_moon.chargers.inventory.OutputSlot;
import se.gory_moon.chargers.inventory.SimpleChargerData;
import se.gory_moon.chargers.network.WindowPropPayload;

@EventBusSubscriber(modid="chargers", bus=EventBusSubscriber.Bus.GAME)
public class ChargerMenu
extends AbstractContainerMenu {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final ResourceLocation EMPTY_CHARGE_SLOT = ResourceLocation.fromNamespaceAndPath((String)"chargers", (String)"item/empty_charge_slot");
    private final IItemHandler itemHandler;
    private final ChargerData energyData;
    private final ContainerLevelAccess access;
    private final List<ChargerDataSlot> customTracked = Lists.newArrayList();
    private final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    private final Slot inputSlot;
    private final Slot outputSlot;
    private final Slot chargeSlot;
    private static final int ENERGY = 0;
    private static final int ENERGY_MAX = 1;
    private static final int MAX_IN = 2;
    private static final int MAX_OUT = 3;
    private static final int AVERAGE_IN = 4;
    private static final int AVERAGE_OUT = 5;
    private static final int CREATIVE = 6;

    public ChargerMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, new ChargerItemStackHandler(), new SimpleChargerData(7), ContainerLevelAccess.NULL);
    }

    public ChargerMenu(int containerId, final Inventory playerInventory, ChargerItemStackHandler itemHandler, ChargerData energyData, ContainerLevelAccess access) {
        super(BlockEntityRegistry.CHARGER_MENU.get(), containerId);
        int i;
        this.itemHandler = itemHandler;
        this.energyData = energyData;
        this.access = access;
        this.inputSlot = this.addSlot((Slot)new InputSlot((IItemHandler)itemHandler, 0, 70, 35));
        this.outputSlot = this.addSlot((Slot)new OutputSlot((IItemHandler)itemHandler, 1, 70, 68));
        this.chargeSlot = this.addSlot(new InputSlot((IItemHandler)itemHandler, 2, 44, 89).setBackground(InventoryMenu.BLOCK_ATLAS, EMPTY_CHARGE_SLOT));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 175));
        }
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot slot = EQUIPMENT_SLOTS[i];
            this.addSlot(new Slot(this, (Container)playerInventory, 36 + (3 - i), 96, 14 + i * 18){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.canEquip(slot, (LivingEntity)playerInventory.player);
                }

                public boolean mayPickup(@NotNull Player player) {
                    ItemStack itemstack = this.getItem();
                    return (itemstack.isEmpty() || player.isCreative() || !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(player);
                }
            }.setBackground(InventoryMenu.BLOCK_ATLAS, ARMOR_SLOT_TEXTURES[slot.getIndex()]));
        }
        this.addSlot(new Slot((Container)playerInventory, 40, 116, 68).setBackground(InventoryMenu.BLOCK_ATLAS, InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD));
        for (i = 0; i < energyData.getCount(); ++i) {
            this.customTracked.add(ChargerDataSlot.forContainer(energyData, i));
        }
    }

    public void broadcastChanges() {
        ArrayList<WindowPropPayload.SyncPair> toSync = new ArrayList<WindowPropPayload.SyncPair>();
        for (int i = 0; i < this.customTracked.size(); ++i) {
            ChargerDataSlot dataSlot = this.customTracked.get(i);
            if (!dataSlot.checkAndClearUpdateFlag()) continue;
            toSync.add(new WindowPropPayload.SyncPair(i, dataSlot.get()));
        }
        if (!toSync.isEmpty()) {
            WindowPropPayload payload = new WindowPropPayload(this.containerId, toSync);
            for (ServerPlayer player : this.usingPlayers) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        super.broadcastChanges();
    }

    public void setData(int id, int data) {
        this.customTracked.get(id).set(data);
    }

    public void setData(int id, long data) {
        this.customTracked.get(id).set(data);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        int inventoryStart = this.chargeSlot.index + 1;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        int armorStart = hotbarEnd + 1;
        int armorEnd = armorStart + 3;
        int offhand = armorEnd + 1;
        int curiosStart = offhand + 1;
        int curiosEnd = curiosStart + 6;
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index == this.inputSlot.index || index == this.outputSlot.index || index == this.chargeSlot.index) {
                if (!this.moveItemStackTo(stack, inventoryStart, offhand, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            } else if (!this.itemHandler.isItemValid(0, stack) && !this.itemHandler.isItemValid(2, stack) ? (index <= inventoryEnd ? !this.moveItemStackTo(stack, hotbarStart, hotbarEnd + 1, false) : index < hotbarEnd + 1 && !this.moveItemStackTo(stack, inventoryStart, inventoryEnd + 1, false)) : !this.moveItemStackTo(stack, this.inputSlot.index, this.chargeSlot.index + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return ChargerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.CHARGER_BLOCK_T1.get())) || ChargerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.CHARGER_BLOCK_T2.get())) || ChargerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.CHARGER_BLOCK_T3.get())) || ChargerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.CHARGER_BLOCK_T4.get())) || ChargerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.CHARGER_BLOCK_CREATIVE.get()));
    }

    public boolean hasEnergy() {
        return this.getEnergy() > 0L;
    }

    public long getEnergy() {
        return this.energyData.get(0);
    }

    public long getEnergyMax() {
        return this.energyData.get(1);
    }

    public long getMaxIn() {
        return this.energyData.get(2);
    }

    public long getMaxOut() {
        return this.energyData.get(3);
    }

    public long getAverageIn() {
        return this.energyData.get(4);
    }

    public long getAverageOut() {
        return this.energyData.get(5);
    }

    public long getEnergyDiff() {
        return this.getAverageIn() - this.getAverageOut();
    }

    public int getEnergyScaled(int length) {
        return (int)((double)this.getEnergy() / (double)this.getEnergyMax() * (double)length);
    }

    public boolean isCreative() {
        return this.energyData.get(6) == 1L;
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof ChargerMenu) {
            ChargerMenu menu = (ChargerMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                menu.usingPlayers.add(serverPlayer);
                ArrayList<WindowPropPayload.SyncPair> toSync = new ArrayList<WindowPropPayload.SyncPair>();
                for (int i = 0; i < menu.customTracked.size(); ++i) {
                    toSync.add(new WindowPropPayload.SyncPair(i, menu.customTracked.get(i).get()));
                }
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new WindowPropPayload(menu.containerId, toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof ChargerMenu) {
            ChargerMenu menu = (ChargerMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                menu.usingPlayers.remove(serverPlayer);
            }
        }
    }
}

