/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.block.BlockRegistry;
import se.gory_moon.chargers.item.ChargerDataComponents;

public class ChargerLootTableProvider
extends LootTableProvider {
    public ChargerLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ChargerBlockLootSubProvider::new, LootContextParamSets.BLOCK)), registries);
    }

    private static class ChargerBlockLootSubProvider
    extends BlockLootSubProvider {
        private ChargerBlockLootSubProvider(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.DEFAULT_FLAGS, registries);
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return BlockRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.value()).toList();
        }

        protected void generate() {
            this.dropEnergyBlock((Supplier<? extends Block>)BlockRegistry.CHARGER_BLOCK_T1);
            this.dropEnergyBlock((Supplier<? extends Block>)BlockRegistry.CHARGER_BLOCK_T2);
            this.dropEnergyBlock((Supplier<? extends Block>)BlockRegistry.CHARGER_BLOCK_T3);
            this.dropEnergyBlock((Supplier<? extends Block>)BlockRegistry.CHARGER_BLOCK_T4);
            this.dropEnergyBlock((Supplier<? extends Block>)BlockRegistry.CHARGER_BLOCK_CREATIVE);
            this.dropEnergyBlock((Supplier<? extends Block>)BlockRegistry.WIRELESS_CHARGER);
        }

        private void dropEnergyBlock(Supplier<? extends Block> blockSupplier) {
            Block block = blockSupplier.get();
            this.add(block, LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include((DataComponentType)ChargerDataComponents.ENERGY.get()))))));
        }
    }
}

