/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.crafting.UpgradeChargerRecipe;

public class UpgradeChargerRecipeSerializer
implements RecipeSerializer<UpgradeChargerRecipe> {
    private final MapCodec<UpgradeChargerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.getResultItem(null)), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification)).apply((Applicative)instance, UpgradeChargerRecipe::new));
    private final StreamCodec<RegistryFriendlyByteBuf, UpgradeChargerRecipe> STREAM_CODEC = StreamCodec.of(UpgradeChargerRecipeSerializer::toNetwork, UpgradeChargerRecipeSerializer::fromNetwork);

    @NotNull
    public MapCodec<UpgradeChargerRecipe> codec() {
        return this.CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, UpgradeChargerRecipe> streamCodec() {
        return this.STREAM_CODEC;
    }

    public static UpgradeChargerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        ShapedRecipe basic = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buffer);
        return new UpgradeChargerRecipe(basic.getGroup(), basic.category(), basic.pattern, basic.getResultItem((HolderLookup.Provider)buffer.registryAccess()), basic.showNotification());
    }

    public static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, UpgradeChargerRecipe recipe) {
        RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe.toVanilla((HolderLookup.Provider)buffer.registryAccess()));
    }
}

