/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.crafting;

import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.block.EnergyBlock;
import se.gory_moon.chargers.crafting.RecipeSerializers;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public class UpgradeChargerRecipe
extends ShapedRecipe {
    public UpgradeChargerRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack output, boolean showNotification) {
        super(group, category, pattern, output, showNotification);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializers.UPGRADE_SERIALIZER.get();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        BlockItem blockItem;
        ItemStack out = this.getResultItem(registries).copy();
        Item item = out.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof EnergyBlock) {
            AtomicLong energy = new AtomicLong();
            for (int i = 0; i < input.size(); ++i) {
                IEnergyStorage storage;
                BlockItem blockItem1;
                Item item2;
                ItemStack item3 = input.getItem(i);
                if (item3.isEmpty() || !((item2 = item3.getItem()) instanceof BlockItem) || !((blockItem1 = (BlockItem)item2).getBlock() instanceof EnergyBlock) || (storage = (IEnergyStorage)item3.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
                if (storage instanceof CustomEnergyStorage) {
                    CustomEnergyStorage customEnergyStorage = (CustomEnergyStorage)storage;
                    energy.addAndGet(customEnergyStorage.getLongEnergyStored());
                    continue;
                }
                energy.addAndGet(storage.getEnergyStored());
            }
            IEnergyStorage outStorage = (IEnergyStorage)out.getCapability(Capabilities.EnergyStorage.ITEM);
            if (outStorage instanceof CustomEnergyStorage) {
                CustomEnergyStorage customEnergyStorage = (CustomEnergyStorage)outStorage;
                customEnergyStorage.setEnergy(Math.min(energy.get(), customEnergyStorage.getLongMaxEnergyStored()));
            }
            return out;
        }
        return super.assemble(input, registries);
    }

    public ShapedRecipe toVanilla(HolderLookup.Provider registries) {
        return new ShapedRecipe(this.getGroup(), this.category(), this.pattern, this.getResultItem(registries));
    }
}

