/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.compat;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.block.entity.WirelessChargerBlockEntity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class Curios {
    public static Curios INSTANCE = new Curios();
    private static final boolean loaded = ModList.get().isLoaded("curios");

    public static boolean isLoaded() {
        return loaded && (Boolean)Configs.SERVER.curiosCompat.get() != false;
    }

    @Nullable
    public static IItemHandler getCurios(Player player) {
        return null;
    }

    public static SlotItemHandler getSlot(Player player, IItemHandler itemHandler, int slot, int x, int y) {
        return new SlotItemHandler(itemHandler, slot, x, y){

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    public boolean chargeItems(Player player, WirelessChargerBlockEntity charger) {
        AtomicBoolean result = new AtomicBoolean(false);
        if (Curios.isLoaded()) {
            Optional lazyOptional = CuriosApi.getCuriosInventory((LivingEntity)player);
            lazyOptional.ifPresent(handler -> {
                NonNullList chargeList = NonNullList.create();
                chargeList.add((Object)ItemStack.EMPTY);
                for (ICurioStacksHandler itemHandler : handler.getCurios().values()) {
                    if (charger.getAvailableEnergy() <= 0L) break;
                    IDynamicStackHandler stacks = itemHandler.getStacks();
                    for (int i = 0; i < itemHandler.getSlots() && charger.getAvailableEnergy() > 0L; ++i) {
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (stack.isEmpty() || stack.getCount() != 1) continue;
                        stack = stack.copy();
                        chargeList.set(0, (Object)stack);
                        if (!charger.chargeItems((NonNullList<ItemStack>)chargeList)) continue;
                        stacks.setStackInSlot(i, stack);
                        result.set(true);
                    }
                }
            });
        }
        return result.get();
    }
}

