/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.compat;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import se.gory_moon.chargers.compat.bc.BrandonsCoreCompat;
import se.gory_moon.chargers.compat.fn.FluxNetworksCompat;
import se.gory_moon.chargers.compat.industrial.IndustrialForegoingCompat;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public class ChargeCompat {
    public static ChargeCompat INSTANCE = new ChargeCompat();

    private ChargeCompat() {
    }

    private int cap(long value) {
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        if (BrandonsCoreCompat.INSTANCE.isLoaded()) {
            BrandonsCoreCompat.INSTANCE.registerOPCapability(event);
        }
        if (FluxNetworksCompat.INSTANCE.isLoaded()) {
            FluxNetworksCompat.INSTANCE.registerFNCapability(event);
        }
    }

    public void dischargeItem(ItemStack stack, CustomEnergyStorage blockStorage, Runnable callback) {
        long extractAmount;
        long transferred;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (storage != null && (transferred = this.extractAmount(storage, extractAmount = Math.min(blockStorage.getLongMaxEnergyStored() - blockStorage.getLongEnergyStored(), blockStorage.getMaxInput()))) > 0L) {
            blockStorage.receiveLongEnergy(transferred, false);
            callback.run();
        }
    }

    public boolean chargeItem(ItemStack stack, CustomEnergyStorage blockStorage, Consumer<Long> transferredCallback) {
        return this.chargeItem(stack, blockStorage, -1L, transferredCallback);
    }

    public boolean chargeItem(ItemStack stack, CustomEnergyStorage blockStorage, long overrideTransfer, Consumer<Long> transferredCallback) {
        AtomicBoolean charged = new AtomicBoolean(false);
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (storage != null) {
            long transferred;
            long transferRequest = overrideTransfer;
            if (transferRequest < 0L) {
                transferRequest = blockStorage.extractLongEnergy(blockStorage.getLongMaxEnergyStored(), true);
            }
            if ((transferred = this.receiveAmount(storage, transferRequest)) > 0L) {
                transferredCallback.accept(transferred);
            }
            charged.set(this.isStorageFull(storage));
        }
        return charged.get();
    }

    private long extractAmount(IEnergyStorage storage, long extractAmount) {
        Optional<Long> amount;
        if (storage instanceof CustomEnergyStorage) {
            CustomEnergyStorage customEnergyStorage = (CustomEnergyStorage)storage;
            return customEnergyStorage.extractLongEnergy(extractAmount, false);
        }
        if (BrandonsCoreCompat.INSTANCE.isLoaded() && (amount = BrandonsCoreCompat.INSTANCE.extractAmount(storage, extractAmount)).isPresent()) {
            return amount.get();
        }
        return storage.extractEnergy(this.cap(extractAmount), false);
    }

    private long receiveAmount(IEnergyStorage storage, long receiveAmount) {
        Optional<Long> amount;
        if (storage instanceof CustomEnergyStorage) {
            CustomEnergyStorage customEnergyStorage = (CustomEnergyStorage)storage;
            return customEnergyStorage.receiveLongEnergy(receiveAmount, false);
        }
        if (BrandonsCoreCompat.INSTANCE.isLoaded() && (amount = BrandonsCoreCompat.INSTANCE.receiveAmount(storage, receiveAmount)).isPresent()) {
            return amount.get();
        }
        if (IndustrialForegoingCompat.INSTANCE.isLoaded() && (amount = IndustrialForegoingCompat.INSTANCE.receiveAmount(storage, receiveAmount)).isPresent()) {
            return amount.get();
        }
        return storage.receiveEnergy(this.cap(receiveAmount), false);
    }

    private boolean isStorageFull(IEnergyStorage storage) {
        Optional<Boolean> isFull;
        if (storage instanceof CustomEnergyStorage) {
            CustomEnergyStorage customEnergyStorage = (CustomEnergyStorage)storage;
            return customEnergyStorage.getLongEnergyStored() >= customEnergyStorage.getLongMaxEnergyStored();
        }
        if (BrandonsCoreCompat.INSTANCE.isLoaded() && (isFull = BrandonsCoreCompat.INSTANCE.isStorageFull(storage)).isPresent()) {
            return isFull.get();
        }
        if (IndustrialForegoingCompat.INSTANCE.isLoaded() && (isFull = IndustrialForegoingCompat.INSTANCE.isStorageFull(storage)).isPresent()) {
            return isFull.get();
        }
        return storage.getEnergyStored() >= storage.getMaxEnergyStored();
    }
}

