/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.EnergyFormatting;
import se.gory_moon.chargers.LangKeys;
import se.gory_moon.chargers.inventory.ChargerMenu;

public class ChargerScreen
extends AbstractContainerScreen<ChargerMenu> {
    private static final ResourceLocation CHARGER_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"chargers", (String)"textures/gui/charger.png");

    public ChargerScreen(ChargerMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageHeight = 199;
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 4;
        this.inventoryLabelY = 107;
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        if (pMouseX >= this.leftPos + 44 && pMouseX <= this.leftPos + 44 + 16 && pMouseY >= this.topPos + 14 && pMouseY <= this.topPos + 84) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (((ChargerMenu)this.menu).isCreative()) {
                list.add(Component.translatable((String)LangKeys.POWER_INFO.key(), (Object[])new Object[]{EnergyFormatting.INFINITE}).withStyle(ChatFormatting.GOLD));
            } else {
                list.add(EnergyFormatting.formatFilledCapacity(((ChargerMenu)this.menu).getEnergy(), ((ChargerMenu)this.menu).getEnergyMax()));
            }
            list.add(Component.translatable((String)LangKeys.GUI_MAX_IN.key(), (Object[])new Object[]{EnergyFormatting.formatEnergyPerTick(((ChargerMenu)this.menu).getMaxIn())}).withStyle(ChatFormatting.GOLD));
            list.add(Component.translatable((String)LangKeys.GUI_MAX_OUT.key(), (Object[])new Object[]{EnergyFormatting.formatEnergyPerTick(((ChargerMenu)this.menu).getMaxOut())}).withStyle(ChatFormatting.GOLD));
            if (((ChargerMenu)this.menu).getAverageIn() > 0L || ((ChargerMenu)this.menu).getAverageOut() > 0L) {
                list.add(Component.empty());
                if (ChargerScreen.hasShiftDown() || ((ChargerMenu)this.menu).getEnergyDiff() == 0L) {
                    list.add(Component.translatable((String)LangKeys.GUI_DETAILS_IN.key(), (Object[])new Object[]{EnergyFormatting.POSITIVE.copy().append(EnergyFormatting.formatEnergyPerTick(((ChargerMenu)this.menu).getAverageIn()))}).withStyle(ChatFormatting.GOLD));
                    list.add(Component.translatable((String)LangKeys.GUI_DETAILS_OUT.key(), (Object[])new Object[]{EnergyFormatting.NEGATIVE.copy().append(EnergyFormatting.formatEnergyPerTick(((ChargerMenu)this.menu).getAverageOut()))}).withStyle(ChatFormatting.GOLD));
                } else {
                    if (((ChargerMenu)this.menu).getEnergyDiff() != 0L) {
                        list.add(Component.translatable((String)LangKeys.GUI_IO.key(), (Object[])new Object[]{(((ChargerMenu)this.menu).getEnergyDiff() > 0L ? EnergyFormatting.POSITIVE : EnergyFormatting.NEGATIVE).copy().append(EnergyFormatting.formatEnergyPerTick(((ChargerMenu)this.menu).getEnergyDiff()))}).withStyle(ChatFormatting.GOLD));
                    }
                    list.add(Component.translatable((String)LangKeys.GUI_IO_MORE.key()).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
                }
            }
            graphics.renderComponentTooltip(this.font, list, pMouseX, pMouseY);
        }
        this.renderTooltip(graphics, pMouseX, pMouseY);
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(CHARGER_GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((ChargerMenu)this.menu).hasEnergy()) {
            int progress = ((ChargerMenu)this.menu).getEnergyScaled(70);
            graphics.blit(CHARGER_GUI_TEXTURE, this.leftPos + 44, this.topPos + 78 + 6 - progress, 176, 70 - progress, 16, progress);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        super.renderLabels(graphics, pMouseX, pMouseY);
    }
}

