/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.block.entity;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.block.WirelessChargerBlock;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.block.entity.EnergyHolderBlockEntity;
import se.gory_moon.chargers.compat.ChargeCompat;
import se.gory_moon.chargers.handler.WirelessHandler;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public class WirelessChargerBlockEntity
extends EnergyHolderBlockEntity {
    private boolean registered = false;
    private long lastPowered = -1L;
    private long availableEnergy;

    public WirelessChargerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.WIRELESS_CHARGER_BE.get(), pos, state);
        this.setStorage(new CustomEnergyStorage((Long)Configs.SERVER.wireless.storage.get(), (Long)Configs.SERVER.wireless.maxInput.get(), (Long)Configs.SERVER.wireless.maxOutput.get()));
    }

    public void setRemoved() {
        super.setRemoved();
        this.registered = false;
    }

    public void setChanged() {
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 2);
        }
        super.setChanged();
    }

    @Override
    public void tickServer() {
        if (this.level == null) {
            return;
        }
        if (!this.registered) {
            WirelessHandler.INSTANCE.register(this, this.level);
            this.registered = true;
        }
        Boolean powered = (Boolean)this.getBlockState().getValue((Property)WirelessChargerBlock.POWERED);
        if (this.canCharge() != powered.booleanValue()) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)WirelessChargerBlock.POWERED, (Comparable)Boolean.valueOf(this.canCharge())));
        }
        super.tickServer();
        CustomEnergyStorage storage = this.getStorage();
        if (storage != null && (this.lastPowered == -1L || this.lastPowered == 0L && storage.getLongEnergyStored() > 0L || this.lastPowered > 0L && storage.getLongEnergyStored() == 0L)) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            this.lastPowered = storage.getLongEnergyStored();
            this.setChanged();
        }
    }

    public void updateAvailable() {
        if (this.getStorage() != null) {
            this.availableEnergy = Math.min(this.getStorage().getMaxOutput(), this.getStorage().getLongEnergyStored());
        }
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        AtomicBoolean charged = new AtomicBoolean(false);
        if (this.getStorage() != null) {
            for (int i = 0; i < items.size() && this.availableEnergy > 0L; ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                if (stack.isEmpty()) continue;
                ChargeCompat.INSTANCE.chargeItem(stack, this.getStorage(), this.availableEnergy, transferred -> {
                    this.getStorage().extractLongEnergy((long)transferred, false);
                    this.availableEnergy -= transferred.longValue();
                    charged.set(true);
                });
            }
        }
        return charged.get();
    }

    public boolean canCharge() {
        return this.getStorage() != null && this.getStorage().getLongEnergyStored() > 0L && !this.isPowered();
    }

    public boolean isPowered() {
        return this.level != null && this.level.isAreaLoaded(this.getBlockPos(), 1) && this.level.getBestNeighborSignal(this.getBlockPos()) > 0;
    }

    public long getAvailableEnergy() {
        return this.availableEnergy;
    }
}

