/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.EnergyFormatting;
import se.gory_moon.chargers.LangKeys;
import se.gory_moon.chargers.block.BlockRegistry;
import se.gory_moon.chargers.block.EnergyBlock;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.block.entity.WirelessChargerBlockEntity;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public class WirelessChargerBlock
extends EnergyBlock {
    public static BooleanProperty POWERED = BooleanProperty.create((String)"powered");

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return (MapCodec)BlockRegistry.WIRELESS_CHARGER_CODEC.value();
    }

    public WirelessChargerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult result) {
        WirelessChargerBlockEntity changerEntity;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WirelessChargerBlockEntity && (changerEntity = (WirelessChargerBlockEntity)blockEntity).getStorage() != null) {
            boolean powered = changerEntity.isPowered();
            MutableComponent status = Component.translatable((String)(powered ? LangKeys.CHAT_DISABLED.key() : LangKeys.CHAT_ENABLED.key())).setStyle(Style.EMPTY.withColor(powered ? ChatFormatting.RED : ChatFormatting.GREEN));
            CustomEnergyStorage storage = changerEntity.getStorage();
            MutableComponent text = Component.translatable((String)LangKeys.CHAT_WIRELESS_CHARGER_INFO.key(), (Object[])new Object[]{status, EnergyFormatting.formatFilledCapacity(storage.getLongEnergyStored(), storage.getLongMaxEnergyStored())}).withStyle(ChatFormatting.GOLD);
            player.displayClientMessage((Component)text, true);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        EnergyFormatting.addEnergyTooltip(stack, tooltip);
        tooltip.add((Component)Component.translatable((String)LangKeys.TOOLTIP_WIRELESS_CHARGER.key()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WirelessChargerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return WirelessChargerBlock.createEnergyTicker(level, type, BlockEntityRegistry.WIRELESS_CHARGER_BE.get());
    }
}

