/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.hexlands.world;

import com.alcatrazescapee.hexlands.mixin.RandomStateAccessor;
import com.alcatrazescapee.hexlands.platform.XPlatform;
import com.alcatrazescapee.hexlands.util.Hex;
import com.alcatrazescapee.hexlands.util.HexSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.MapCodec;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;

public record HexRandomState(RandomState state, NoiseRouter hexRouter, Climate.Sampler hexSampler) {
    private static final Cache<RandomState, HexRandomState> RANDOM_STATE_EXTENSIONS = CacheBuilder.newBuilder().concurrencyLevel(4).weakKeys().build();

    public static HexRandomState modify(RandomState state, NoiseGeneratorSettings settings, HexSettings hexSettings) {
        try {
            return (HexRandomState)RANDOM_STATE_EXTENSIONS.get((Object)state, () -> {
                DensityFunction.Visitor visitor = f -> {
                    if (HexRandomState.isNoiseDensityFunction(f)) {
                        return HexRandomState.sampleHexRelative(hexSettings, f);
                    }
                    return f;
                };
                NoiseRouter router = state.router();
                NoiseRouter hexRouter = new NoiseRouter(router.barrierNoise(), router.fluidLevelFloodednessNoise(), router.fluidLevelSpreadNoise(), router.lavaNoise(), HexRandomState.sampleHexCenter(hexSettings, router.temperature()), HexRandomState.sampleHexCenter(hexSettings, router.vegetation()), HexRandomState.sampleHexCenter(hexSettings, router.continents()), HexRandomState.sampleHexCenter(hexSettings, router.erosion()), HexRandomState.sampleHexCenter(hexSettings, router.depth()), HexRandomState.sampleHexCenter(hexSettings, router.ridges()), router.initialDensityWithoutJaggedness().mapAll(visitor), router.finalDensity().mapAll(visitor), router.veinToggle(), router.veinRidged(), router.veinGap());
                Climate.Sampler hexSampler = new Climate.Sampler(hexRouter.temperature(), hexRouter.vegetation(), hexRouter.continents(), hexRouter.erosion(), hexRouter.depth(), hexRouter.ridges(), settings.spawnTarget());
                XPlatform.INSTANCE.copyFabricCachedClimateSamplerSeed(state.sampler(), hexSampler);
                RandomStateAccessor mutableState = (RandomStateAccessor)state;
                mutableState.setRouter(hexRouter);
                mutableState.setSampler(hexSampler);
                return new HexRandomState(state, hexRouter, hexSampler);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to inject HexRandomState into RandomState", e);
        }
    }

    private static boolean isNoiseDensityFunction(DensityFunction f) {
        return f instanceof DensityFunctions.Noise || f instanceof DensityFunctions.Shift || f instanceof DensityFunctions.ShiftedNoise;
    }

    private static DensityFunction sampleHexCenter(HexSettings hexSettings, DensityFunction function) {
        return new PointMapped(function, function.minValue(), function.maxValue(), point -> {
            double scale = hexSettings.biomeScale();
            double size = hexSettings.hexSize() * scale;
            Hex hex = Hex.blockToHex((double)point.blockX() * scale, (double)point.blockZ() * scale, size);
            BlockPos center = hex.center();
            return new DensityFunction.SinglePointContext(center.getX(), point.blockY(), center.getZ());
        });
    }

    private static DensityFunction sampleHexRelative(HexSettings hexSettings, DensityFunction function) {
        return new PointMapped(function, function.minValue(), function.maxValue(), point -> {
            double scale = hexSettings.biomeScale();
            double size = hexSettings.hexSize();
            Hex hex = Hex.blockToHex((double)point.blockX() * scale, (double)point.blockZ() * scale, size * scale);
            BlockPos center = hex.center();
            double deltaX = (double)point.blockX() - (double)center.getX() / scale;
            double deltaZ = (double)point.blockZ() - (double)center.getZ() / scale;
            return new DensityFunction.SinglePointContext(center.getX() + (int)deltaX, point.blockY(), center.getZ() + (int)deltaZ);
        });
    }

    record PointMapped(DensityFunction wrapped, double minValue, double maxValue, UnaryOperator<DensityFunction.FunctionContext> point) implements DensityFunction.SimpleFunction
    {
        public double compute(DensityFunction.FunctionContext context) {
            return this.wrapped.compute((DensityFunction.FunctionContext)this.point.apply(context));
        }

        public DensityFunction mapAll(DensityFunction.Visitor visitor) {
            return new PointMapped(this.wrapped.mapAll(visitor), this.minValue, this.maxValue, this.point);
        }

        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return KeyDispatchDataCodec.of((MapCodec)MapCodec.unit((Object)this));
        }
    }
}

