/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils.pathfinding.graphs;

import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.pathfinding.PathfindingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;

public class NodeGraph {
    private List<BlockPos> nodes = new ArrayList<BlockPos>();
    private List<Edge> edges = new ArrayList<Edge>();

    public NodeGraph(List<NodeParameter> nodeParameters) {
        this.nodes = nodeParameters.stream().map(node -> node.getRelativePosition()).toList();
        this.edges = new ArrayList<Edge>();
        for (BlockPos nodePosition : this.nodes) {
            for (BlockPos nextNodePosition : this.nodes) {
                int cost = PathfindingUtils.getCost(nodePosition, nextNodePosition);
                this.edges.add(new Edge(nodePosition, nextNodePosition, cost));
            }
        }
    }

    public List<Edge> createPath() {
        ArrayList<Edge> result = new ArrayList<Edge>();
        Collections.sort(this.edges);
        UnionFind uf = new UnionFind(this.nodes.size());
        for (Edge edge : this.edges) {
            int nodeIndex = this.nodes.indexOf(edge.nodePosition);
            int nextNodeIndex = this.nodes.indexOf(edge.nextNodePosition);
            if (uf.find(nodeIndex) == uf.find(nextNodeIndex)) continue;
            result.add(edge);
            uf.union(nodeIndex, nextNodeIndex);
        }
        return result;
    }

    public static class Edge
    implements Comparable<Edge> {
        public BlockPos nodePosition;
        public BlockPos nextNodePosition;
        public double cost;

        Edge(BlockPos nodePosition, BlockPos nextNodePosition, double cost) {
            this.nodePosition = nodePosition;
            this.nextNodePosition = nextNodePosition;
            this.cost = cost;
        }

        @Override
        public int compareTo(Edge other) {
            return Double.compare(this.cost, other.cost);
        }
    }

    static class UnionFind {
        private int[] parent;
        private int[] rank;

        UnionFind(int size) {
            this.parent = new int[size];
            this.rank = new int[size];
            for (int i = 0; i < size; ++i) {
                this.parent[i] = i;
            }
        }

        int find(int p) {
            if (p != this.parent[p]) {
                this.parent[p] = this.find(this.parent[p]);
            }
            return this.parent[p];
        }

        void union(int p, int q) {
            int rootQ;
            int rootP = this.find(p);
            if (rootP == (rootQ = this.find(q))) {
                return;
            }
            if (this.rank[rootP] < this.rank[rootQ]) {
                this.parent[rootP] = rootQ;
            } else if (this.rank[rootP] > this.rank[rootQ]) {
                this.parent[rootQ] = rootP;
            } else {
                this.parent[rootQ] = rootP;
                int n = rootP;
                this.rank[n] = this.rank[n] + 1;
            }
        }
    }
}

