/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.prettypipes;

import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.utils.GeneralUtils;
import de.ellpeck.prettypipes.items.PipeFrameItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PrettyPipesCompatibility
implements IPlacer {
    public static Class<? extends Block> getBlockToRegister() {
        return PipeBlock.class;
    }

    public static Class<? extends Item> getItemStackClassToRegister() {
        return PipeFrameItem.class;
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> side, ItemStack heldPipeItem) {
        if (!GeneralUtils.isVoidableBlock(level, pos)) {
            level.addDestroyBlockEffect(pos, level.getBlockState(pos));
            level.destroyBlock(pos, true, (Entity)player);
        }
        BlockState blockState = Block.byItem((Item)item).defaultBlockState();
        boolean isWaterBlock = this.isWaterBlock(level, pos);
        boolean hasLevelBlockStateProperty = this.hasLevelBlockStateProperty(level, pos);
        if (isWaterBlock && hasLevelBlockStateProperty && !this.isFlowingWaterBlock(level, pos)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE);
        }
        return level.setBlockAndUpdate(pos, blockState);
    }

    public boolean isWaterBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() == Blocks.WATER;
    }

    public boolean hasLevelBlockStateProperty(Level level, BlockPos pos) {
        return level.getBlockState(pos).hasProperty((Property)BlockStateProperties.LEVEL);
    }

    public boolean isFlowingWaterBlock(Level level, BlockPos pos) {
        return (Integer)level.getBlockState(pos).getValue((Property)BlockStateProperties.LEVEL) > 0;
    }
}

