/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.enderio;

import com.enderio.conduits.api.ConduitApi;
import com.enderio.conduits.api.EnderIOConduitsRegistries;
import com.enderio.conduits.common.conduit.ConduitBlockItem;
import com.enderio.conduits.common.conduit.RightClickAction;
import com.enderio.conduits.common.conduit.block.ConduitBundleBlock;
import com.enderio.conduits.common.conduit.block.ConduitBundleBlockEntity;
import com.enderio.conduits.common.init.ConduitComponents;
import com.heaser.pipeconnector.PipeConnector;
import com.heaser.pipeconnector.compatibility.interfaces.IBlockEqualsChecker;
import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.compatibility.interfaces.IRecipeInfoGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class EnderIoCompatibility
implements IPlacer,
IBlockEqualsChecker,
IRecipeInfoGetter {
    public static Class<? extends Block> getBlockToRegister() {
        return ConduitBundleBlock.class;
    }

    public static Class<? extends Item> getItemToRegister() {
        return ConduitBlockItem.class;
    }

    @Override
    public boolean isBlockStateSpecificBlock(BlockPos pos, Block specificBlock, ItemStack placedItemStack, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Holder conduit = (Holder)placedItemStack.get((Supplier)ConduitComponents.CONDUIT);
        if (conduit != null && level.getBlockState(pos).getBlock() instanceof ConduitBundleBlock && blockEntity instanceof ConduitBundleBlockEntity) {
            return ((ConduitBundleBlockEntity)blockEntity).hasType(conduit);
        }
        return false;
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> adjacentDirectionSides, ItemStack heldPipeItem) {
        Holder conduit = (Holder)heldPipeItem.get((Supplier)ConduitComponents.CONDUIT);
        BlockEntity existingEntity = level.getBlockEntity(pos);
        if (conduit != null && existingEntity instanceof ConduitBundleBlockEntity) {
            ConduitBundleBlockEntity blockEntity = (ConduitBundleBlockEntity)existingEntity;
            if (blockEntity.hasType(conduit)) {
                return false;
            }
            BlockState blockState = level.getBlockState(pos);
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            RightClickAction action = blockEntity.addType(conduit, player);
            PipeConnector.LOGGER.debug("Action: " + String.valueOf(action));
            return true;
        }
        BlockState blockState = Block.byItem((Item)item).defaultBlockState();
        level.setBlock(pos, blockState, 11);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
        BlockEntity entity = level.getBlockEntity(pos);
        if (conduit != null && entity instanceof ConduitBundleBlockEntity) {
            ConduitBundleBlockEntity blockEntity = (ConduitBundleBlockEntity)entity;
            blockEntity.addType(conduit, player);
        }
        return true;
    }

    @Override
    public List<ItemStack> getSupportedPipeItems(ItemStack supportedBaseItem) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        RegistryAccess registries = Minecraft.getInstance().getConnection().getLevel().registryAccess();
        ResourceKey key = EnderIOConduitsRegistries.Keys.CONDUIT;
        MappedRegistry conduitRegistry = (MappedRegistry)registries.registry(key).get();
        for (Map.Entry entry : conduitRegistry.entrySet()) {
            Holder conduit = (Holder)conduitRegistry.getHolder((ResourceKey)entry.getKey()).get();
            ItemStack itemStack = ConduitApi.INSTANCE.getStackForType(conduit);
            result.add(itemStack);
        }
        return result;
    }
}

