/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client;

import com.heaser.pipeconnector.network.UpdateDepthPacket;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="pipe_connector", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class DepthSetterEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void MouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        int scroll = (int)event.getScrollDeltaY();
        if (player == null || !player.isShiftKeyDown() || scroll == 0) {
            return;
        }
        ItemStack pipeConnectorStack = GeneralUtils.heldPipeConnector((Player)player);
        if (pipeConnectorStack == null || pipeConnectorStack.isEmpty()) {
            return;
        }
        int depth = TagUtils.getDepthFromStack(pipeConnectorStack);
        TagUtils.setDepthToStack(pipeConnectorStack, depth + scroll);
        depth = TagUtils.getDepthFromStack(pipeConnectorStack);
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateDepthPacket(depth), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.displayClientMessage((Component)Component.translatable((String)"item.pipe_connector.message.newDepth", (Object[])new Object[]{depth}).withStyle(ChatFormatting.YELLOW), true);
        event.setCanceled(true);
    }
}

