/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.events;

import com.benbenlaw.roomopolis.item.KeyItem;
import com.benbenlaw.roomopolis.item.KeyItemPaletteCache;
import com.benbenlaw.roomopolis.item.KeyItemSizeCache;
import com.benbenlaw.roomopolis.network.payload.GetStructurePalettePayload;
import com.benbenlaw.roomopolis.network.payload.GetStructureSizePayload;
import com.benbenlaw.roomopolis.util.RoomopolisTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="roomopolis")
public class UpdateKeyCache {
    @SubscribeEvent
    public static void updateKeyCache(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Objects.requireNonNull(serverPlayer.getServer()).execute(() -> {
            ServerLevel level = (ServerLevel)serverPlayer.level();
            StructureTemplateManager structureManager = level.getStructureManager();
            for (Item item : BuiltInRegistries.ITEM) {
                if (!(item instanceof KeyItem)) continue;
                KeyItem keyItem = (KeyItem)item;
                ResourceLocation templateId = keyItem.templateId;
                Optional optionalTemplate = structureManager.get(templateId);
                optionalTemplate.ifPresent(template -> {
                    Vec3i size = template.getSize();
                    KeyItemSizeCache.setTemplateSize(templateId, size);
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new GetStructureSizePayload(templateId.toString(), size), (CustomPacketPayload[])new CustomPacketPayload[0]);
                });
                if (!optionalTemplate.isPresent()) continue;
                StructureTemplate.Palette palette = (StructureTemplate.Palette)((StructureTemplate)optionalTemplate.get()).palettes.getFirst();
                HashMap<Block, Integer> blockCounts = new HashMap<Block, Integer>();
                HashMap<Block, Integer> halfCountMap = new HashMap<Block, Integer>();
                for (StructureTemplate.StructureBlockInfo structureBlockInfo : palette.blocks()) {
                    Block block = structureBlockInfo.state().getBlock();
                    if (block == Blocks.AIR) continue;
                    if (block.builtInRegistryHolder().is(RoomopolisTags.Blocks.DOUBLE_BLOCKS)) {
                        halfCountMap.put(block, halfCountMap.getOrDefault(block, 0) + 1);
                        continue;
                    }
                    blockCounts.put(block, blockCounts.getOrDefault(block, 0) + 1);
                }
                for (Map.Entry entry : halfCountMap.entrySet()) {
                    int adjusted = ((Integer)entry.getValue() + 1) / 2;
                    blockCounts.put((Block)entry.getKey(), adjusted);
                }
                KeyItemPaletteCache.setTemplatePalette(templateId, blockCounts);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new GetStructurePalettePayload(templateId.toString(), blockCounts), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }
}

