/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.SnadModule;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class SnadBlock
extends ColoredFallingBlock {
    public SnadBlock(ColorRGBA pDustColor, BlockBehaviour.Properties pProperties) {
        super(pDustColor, pProperties);
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        this.tick(pState, pLevel, pPos, pRandom);
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        BlockState plantBlock = pLevel.getBlockState(pPos.above());
        if (plantBlock.is(SnadModule.SAND_GROWABLES)) {
            Block block;
            Block block2;
            Block block3 = plantBlock.getBlock();
            if (block3 instanceof GrowingPlantBlock) {
                GrowingPlantBlock growBlock = (GrowingPlantBlock)block3;
                block2 = growBlock.getHeadBlock();
            } else {
                block2 = plantBlock.getBlock();
            }
            Block headBlock = block2;
            Block block4 = plantBlock.getBlock();
            if (block4 instanceof GrowingPlantBlock) {
                GrowingPlantBlock growBlock = (GrowingPlantBlock)block4;
                block = growBlock.getBodyBlock();
            } else {
                block = plantBlock.getBlock();
            }
            Block bodyBlock = block;
            int i = 2;
            while (pLevel.getBlockState(pPos.above(i)).is(headBlock) || pLevel.getBlockState(pPos.above(i)).is(plantBlock.getBlock())) {
                ++i;
            }
            BlockState state = pLevel.getBlockState(pPos.above(i - 1));
            IntegerProperty ageProperty = state.getBlock() instanceof GrowingPlantHeadBlock ? BlockStateProperties.AGE_25 : BlockStateProperties.AGE_15;
            int maxAge = (Integer)ageProperty.getAllValues().max(Comparator.comparingInt(Property.Value::value)).get().value();
            if (state.hasProperty((Property)ageProperty) && i < 4 + (Integer)Config.SNAD_ADDITIONAL_HEIGHT.get() && pPos.above(i).getY() < pLevel.getMaxBuildHeight() && pLevel.getBlockState(pPos.above(i)).canBeReplaced()) {
                if ((Integer)state.getValue((Property)ageProperty) == maxAge) {
                    if (CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (boolean)true)) {
                        pLevel.setBlockAndUpdate(pPos.above(i), headBlock.defaultBlockState());
                        BlockState grownState = bodyBlock.defaultBlockState();
                        pLevel.setBlock(pPos.above(i - 1), grownState.hasProperty((Property)ageProperty) ? (BlockState)grownState.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0)) : grownState, 2);
                        CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos.above(), (BlockState)plantBlock.getBlock().defaultBlockState());
                    }
                } else {
                    pLevel.setBlock(pPos.above(i - 1), (BlockState)state.setValue((Property)ageProperty, (Comparable)Integer.valueOf(Math.min(maxAge, (Integer)state.getValue((Property)ageProperty) + (Integer)Config.SNAD_GROWTH_MULTIPLIER.get()))), 4);
                }
            } else {
                for (int u = 0; u < (Integer)Config.SNAD_GROWTH_MULTIPLIER.get(); ++u) {
                    state.randomTick(pLevel, pPos.above(i - 1), pRandom);
                }
            }
        }
    }
}

