/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.events;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber
public class WorldEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldEventHandler.class);

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LOGGER.warn("WorldEventHandler: World unload detected - notifying all bridges");
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(true);
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
            LOGGER.warn("WorldEventHandler: All bridges notified of world unload");
        }
        catch (Exception e) {
            LOGGER.error("WorldEventHandler: Exception during world unload handling", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LOGGER.info("WorldEventHandler: World load detected - resetting unload flag");
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(false);
            LOGGER.info("WorldEventHandler: World load handling completed");
        }
        catch (Exception e) {
            LOGGER.error("WorldEventHandler: Exception during world load handling", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        LOGGER.warn("WorldEventHandler: Server stopping detected - emergency cleanup");
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(true);
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
            LOGGER.warn("WorldEventHandler: Server stop cleanup completed");
        }
        catch (Exception e) {
            LOGGER.error("WorldEventHandler: Exception during server stop cleanup", (Throwable)e);
        }
    }
}

