/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.neoforge.data.providers;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.sashiro.compressedblocks.block.CrateBlock;
import net.sashiro.compressedblocks.neoforge.CompressedBlocksNeoForge;
import net.sashiro.compressedblocks.util.CommonUtils;

public class CBBlockStateProvider
extends BlockStateProvider {
    public CBBlockStateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "compressedblocks", exFileHelper);
    }

    protected void registerStatesAndModels() {
        String descriptionId;
        ModelFile.UncheckedModelFile blockBlock = new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)"block/template/template_block"));
        ModelFile.UncheckedModelFile cubeColumn = new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)"block/template/template_cube_column"));
        ModelFile.UncheckedModelFile cubeColumnHorizontal = new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)"block/template/template_cube_column_horizontal"));
        for (DeferredHolder block : CompressedBlocksNeoForge.BLOCKS.getEntries()) {
            descriptionId = ((Block)block.get()).getDescriptionId();
            if (CommonUtils.isBlock(descriptionId)) continue;
            if (CommonUtils.isRotational(descriptionId)) {
                RotatedPillarBlock block1 = (RotatedPillarBlock)block.get();
                ResourceLocation side = CommonUtils.getActualResourceLocation(descriptionId);
                ResourceLocation end = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(CommonUtils.getCleanName(descriptionId) + "_top"));
                if (descriptionId.contains("froglight") || descriptionId.contains("hay") || descriptionId.contains("melon") || descriptionId.contains("pumpkin")) {
                    side = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(side.getPath() + "_side"));
                }
                this.axisBlock(block1, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cubeColumn(descriptionId.replace("block.compressedblocks.", ""), side, end)).texture("particle", side)).texture("overlay", CommonUtils.getOverlay(descriptionId))).parent((ModelFile)cubeColumn)).renderType("cutout"), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cubeColumnHorizontal(descriptionId.replace("block.compressedblocks.", "") + "_horizontal", side, end)).texture("particle", side)).texture("overlay", CommonUtils.getOverlay(descriptionId))).parent((ModelFile)cubeColumnHorizontal)).renderType("cutout"));
                continue;
            }
            this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cubeAll(descriptionId.replace("block.compressedblocks.", ""), CommonUtils.getActualResourceLocation(descriptionId))).texture("particle", CommonUtils.getActualResourceLocation(descriptionId))).texture("overlay", CommonUtils.getOverlay(descriptionId))).parent((ModelFile)blockBlock)).renderType("cutout"));
        }
        for (DeferredHolder crateBlock : CompressedBlocksNeoForge.CRATE_BLOCKS.getEntries()) {
            descriptionId = ((Block)crateBlock.get()).getDescriptionId();
            String crate_name = descriptionId.replace("block.compressedblocks.", "");
            String mc_name = CommonUtils.getMCName(crate_name);
            ResourceLocation location = CommonUtils.getResourceLocation(mc_name);
            CrateBlock rotatedPillarBlock = (CrateBlock)((Object)crateBlock.get());
            this.horizontalBlock((Block)rotatedPillarBlock, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(crate_name, ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)"block/template/template_cube_column_crate"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)"block/crate"))).texture("item", location)).texture("number", CommonUtils.getOverlay(descriptionId))).renderType("cutout"));
        }
    }
}

