/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.neoforge;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.sashiro.compressedblocks.CompressedBlocks;
import net.sashiro.compressedblocks.Constants;
import net.sashiro.compressedblocks.block.BlockList;
import net.sashiro.compressedblocks.block.CrateList;
import net.sashiro.compressedblocks.neoforge.CBNeoForgeConfig;
import net.sashiro.compressedblocks.platform.registry.CBBlockRegistry;
import net.sashiro.compressedblocks.platform.registry.CBCrateRegistry;

@Mod(value="compressedblocks")
public class CompressedBlocksNeoForge {
    private static boolean finished = false;
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"compressedblocks");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"compressedblocks");
    public static final DeferredRegister<Block> CRATE_BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"compressedblocks");
    public static final DeferredRegister<Item> CRATE_ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"compressedblocks");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"compressedblocks");
    public static final Item.Properties PROPERTIES = new Item.Properties();
    public static final Supplier<CreativeModeTab> CRATES_TAB = CREATIVE_MODE_TABS.register("compressed_items", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)"compressed_blocks")}).title((Component)Component.literal((String)"Crates")).icon(() -> CrateList.APPLE[0].asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredHolder item : CRATE_ITEMS.getEntries()) {
            output.accept((ItemLike)item.get());
        }
    }).build());
    public static final Supplier<CreativeModeTab> COMPRESSED_BLOCKS_TAB = CREATIVE_MODE_TABS.register("compressed_blocks", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.literal((String)"Compressed Blocks")).icon(() -> BlockList.STONE[9].asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredHolder item : ITEMS.getEntries()) {
            output.accept((ItemLike)item.get());
        }
    }).build());

    public CompressedBlocksNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        CompressedBlocks.init();
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)CBNeoForgeConfig.CONFIG_SPEC);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CRATE_BLOCKS.register(modEventBus);
        CRATE_ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::reg);
        Constants.LOG.info("Successfully registered all Blocks and Crates!");
    }

    private void reg(RegisterEvent event) {
        if (!finished) {
            CBBlockRegistry.registerBlocks();
            CBCrateRegistry.registerCrates();
            finished = true;
        }
    }
}

