/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.neoforge;

import java.util.ArrayList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="Compressed Blocks", bus=EventBusSubscriber.Bus.MOD)
public class CBNeoForgeConfig {
    public static final CBNeoForgeConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.BooleanValue CONFIG_BLOCKS_ENABLED;
    public final ModConfigSpec.BooleanValue CONFIG_CRATES_ENABLED;
    public final ModConfigSpec.IntValue CONFIG_MAX_COMPRESSION_LEVEL;
    public final ModConfigSpec.IntValue CONFIG_MAX_CRATE_COMPRESSION_LEVEL;
    public ArrayList<ModConfigSpec.BooleanValue> ENABLED_BLOCKS = new ArrayList();
    public ArrayList<ModConfigSpec.BooleanValue> ENABLED_CRATES = new ArrayList();

    private CBNeoForgeConfig(ModConfigSpec.Builder builder) {
        builder.comment("Compressed Blocks configuration");
        builder.comment("Changes require a game restart to take effect.");
        builder.comment("WARNING: These settings are loaded on startup and not synced with the server.");
        builder.comment("Ensure identical configuration on both client and server to prevent connection issues.");
        builder.comment("Any changes will log warnings for invalid or missing files.");
        builder.comment("----------------------------------------");
        builder.comment("Enable compressed blocks");
        this.CONFIG_BLOCKS_ENABLED = builder.define("blocksEnabled", true);
        builder.comment("Enable crates");
        this.CONFIG_CRATES_ENABLED = builder.define("cratesEnabled", true);
        builder.comment("Maximum compression level for blocks");
        this.CONFIG_MAX_COMPRESSION_LEVEL = builder.defineInRange("maxCompressionLevel", 10, 1, 10);
        builder.comment("Maximum compression level for crates");
        this.CONFIG_MAX_CRATE_COMPRESSION_LEVEL = builder.defineInRange("maxCrateCompressionLevel", 10, 1, 10);
        builder.comment("Enabled blocks:");
        this.ENABLED_BLOCKS.add(builder.define("DIRT", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAVEL", true));
        this.ENABLED_BLOCKS.add(builder.define("COBBLESTONE", true));
        builder.comment("Note: Stone can not be disabled as it is required for the creative inventory icon.");
        this.ENABLED_BLOCKS.add(builder.define("STONE", true));
        this.ENABLED_BLOCKS.add(builder.define("GRANITE", true));
        this.ENABLED_BLOCKS.add(builder.define("DIORITE", true));
        this.ENABLED_BLOCKS.add(builder.define("ANDESITE", true));
        this.ENABLED_BLOCKS.add(builder.define("CRIMSON_NYLIUM", true));
        this.ENABLED_BLOCKS.add(builder.define("WARPED_NYLIUM", true));
        this.ENABLED_BLOCKS.add(builder.define("CLAY", true));
        this.ENABLED_BLOCKS.add(builder.define("SAND", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_SAND", true));
        this.ENABLED_BLOCKS.add(builder.define("SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("COAL_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("COPPER_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("IRON_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("GOLD_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("REDSTONE_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("EMERALD_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("LAPIS_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DIAMOND_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("NETHER_GOLD_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("NETHER_QUARTZ_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_COAL_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_COPPER_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_IRON_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_GOLD_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_REDSTONE_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_EMERALD_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_LAPIS_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_DIAMOND_ORE", true));
        this.ENABLED_BLOCKS.add(builder.define("RAW_IRON_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("RAW_COPPER_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("RAW_GOLD_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("IRON_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("GOLD_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("REDSTONE_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("EMERALD_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("LAPIS_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("DIAMOND_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("NETHERITE_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("COAL_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("SLIME_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("HONEY_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("STONE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("NETHERRACK", true));
        this.ENABLED_BLOCKS.add(builder.define("NETHER_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_NETHER_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("NETHER_WART_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("SOUL_SAND", true));
        this.ENABLED_BLOCKS.add(builder.define("SOUL_SOIL", true));
        this.ENABLED_BLOCKS.add(builder.define("END_STONE", true));
        this.ENABLED_BLOCKS.add(builder.define("END_STONE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACKSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE", true));
        this.ENABLED_BLOCKS.add(builder.define("COBBLED_DEEPSLATE", true));
        this.ENABLED_BLOCKS.add(builder.define("TUFF", true));
        this.ENABLED_BLOCKS.add(builder.define("BASALT", true));
        this.ENABLED_BLOCKS.add(builder.define("OBSIDIAN", true));
        this.ENABLED_BLOCKS.add(builder.define("MUD", true));
        this.ENABLED_BLOCKS.add(builder.define("OAK_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("SPRUCE_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("BIRCH_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("JUNGLE_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("ACACIA_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("DARK_OAK_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("MANGROVE_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("CHERRY_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_OAK_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_SPRUCE_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_BIRCH_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_JUNGLE_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_ACACIA_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_DARK_OAK_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_MANGROVE_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_CHERRY_LOG", true));
        this.ENABLED_BLOCKS.add(builder.define("OAK_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("SPRUCE_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("BIRCH_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("JUNGLE_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("ACACIA_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("DARK_OAK_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("MANGROVE_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("CHERRY_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("BAMBOO_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("BAMBOO_MOSAIC", true));
        this.ENABLED_BLOCKS.add(builder.define("COPPER_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("EXPOSED_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("EXPOSED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WEATHERED_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WEATHERED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("OXIDIZED_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("OXIDIZED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_COPPER_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_EXPOSED_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_EXPOSED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_WEATHERED_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_WEATHERED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_OXIDIZED_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("WAXED_OXIDIZED_CUT_COPPER", true));
        this.ENABLED_BLOCKS.add(builder.define("BONE_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("SCULK", true));
        this.ENABLED_BLOCKS.add(builder.define("SMOOTH_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("CUT_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("CHISELED_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("SMOOTH_RED_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("CUT_RED_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("CHISELED_RED_SANDSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("CRIMSON_STEM", true));
        this.ENABLED_BLOCKS.add(builder.define("WARPED_STEM", true));
        this.ENABLED_BLOCKS.add(builder.define("TNT", true));
        this.ENABLED_BLOCKS.add(builder.define("BAMBOO_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_BAMBOO_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_CRIMSON_STEM", true));
        this.ENABLED_BLOCKS.add(builder.define("CRIMSON_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("STRIPPED_WARPED_STEM", true));
        this.ENABLED_BLOCKS.add(builder.define("WARPED_PLANKS", true));
        this.ENABLED_BLOCKS.add(builder.define("MOSSY_COBBLESTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("MOSSY_STONE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("CRACKED_STONE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("CHISELED_STONE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("POLISHED_GRANITE", true));
        this.ENABLED_BLOCKS.add(builder.define("POLISHED_DIORITE", true));
        this.ENABLED_BLOCKS.add(builder.define("POLISHED_ANDESITE", true));
        this.ENABLED_BLOCKS.add(builder.define("CHISELED_DEEPSLATE", true));
        this.ENABLED_BLOCKS.add(builder.define("POLISHED_DEEPSLATE", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("CRACKED_DEEPSLATE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("DEEPSLATE_TILES", true));
        this.ENABLED_BLOCKS.add(builder.define("CRACKED_DEEPSLATE_TILES", true));
        this.ENABLED_BLOCKS.add(builder.define("PACKED_MUD", true));
        this.ENABLED_BLOCKS.add(builder.define("MUD_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("PRISMARINE", true));
        this.ENABLED_BLOCKS.add(builder.define("PRISMARINE_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("DARK_PRISMARINE", true));
        this.ENABLED_BLOCKS.add(builder.define("QUARTZ_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("CHISELED_QUARTZ_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("QUARTZ_BRICKS", true));
        this.ENABLED_BLOCKS.add(builder.define("QUARTZ_PILLAR", true));
        this.ENABLED_BLOCKS.add(builder.define("SMOOTH_QUARTZ_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("AMETHYST_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("WHITE_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_GRAY_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAY_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACK_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("ORANGE_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("YELLOW_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("LIME_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("GREEN_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("CYAN_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_BLUE_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("PURPLE_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGENTA_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("PINK_WOOL", true));
        this.ENABLED_BLOCKS.add(builder.define("TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("WHITE_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_GRAY_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAY_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACK_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("ORANGE_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("YELLOW_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("LIME_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("GREEN_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("CYAN_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_BLUE_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("PURPLE_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGENTA_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("PINK_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("WHITE_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_GRAY_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAY_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACK_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("ORANGE_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("YELLOW_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("LIME_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("GREEN_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("CYAN_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_BLUE_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("PURPLE_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGENTA_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("PINK_GLAZED_TERRACOTTA", true));
        this.ENABLED_BLOCKS.add(builder.define("WHITE_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_GRAY_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAY_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACK_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("ORANGE_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("YELLOW_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("LIME_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("GREEN_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("CYAN_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_BLUE_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("PURPLE_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGENTA_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("PINK_CONCRETE_POWDER", true));
        this.ENABLED_BLOCKS.add(builder.define("WHITE_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_GRAY_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAY_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACK_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("ORANGE_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("YELLOW_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("LIME_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("GREEN_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("CYAN_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_BLUE_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("PURPLE_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGENTA_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("PINK_CONCRETE", true));
        this.ENABLED_BLOCKS.add(builder.define("GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("TINTED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("WHITE_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_GRAY_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("GRAY_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("BLACK_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("ORANGE_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("YELLOW_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("LIME_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("GREEN_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("CYAN_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("LIGHT_BLUE_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("PURPLE_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGENTA_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("PINK_STAINED_GLASS", true));
        this.ENABLED_BLOCKS.add(builder.define("ICE", true));
        this.ENABLED_BLOCKS.add(builder.define("PACKED_ICE", true));
        this.ENABLED_BLOCKS.add(builder.define("BLUE_ICE", true));
        this.ENABLED_BLOCKS.add(builder.define("SNOW_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("MOSS_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("CALCITE", true));
        this.ENABLED_BLOCKS.add(builder.define("DRIPSTONE_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("MAGMA_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("GLOWSTONE", true));
        this.ENABLED_BLOCKS.add(builder.define("DRIED_KELP_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("BROWN_MUSHROOM_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("RED_MUSHROOM_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("SHROOMLIGHT", true));
        this.ENABLED_BLOCKS.add(builder.define("MELON", true));
        this.ENABLED_BLOCKS.add(builder.define("PUMPKIN", true));
        this.ENABLED_BLOCKS.add(builder.define("HAY_BLOCK", true));
        this.ENABLED_BLOCKS.add(builder.define("OCHRE_FROGLIGHT", true));
        this.ENABLED_BLOCKS.add(builder.define("VERDANT_FROGLIGHT", true));
        this.ENABLED_BLOCKS.add(builder.define("PEARLESCENT_FROGLIGHT", true));
        this.ENABLED_BLOCKS.add(builder.define("SEA_LANTERN", true));
        builder.comment("Enabled crates:");
        builder.comment("Note: Apple can not be disabled as it is required for the creative inventory icon.");
        this.ENABLED_CRATES.add(builder.define("APPLE", true));
        this.ENABLED_CRATES.add(builder.define("GOLDEN_APPLE", true));
        this.ENABLED_CRATES.add(builder.define("SWEET_BERRIES", true));
        this.ENABLED_CRATES.add(builder.define("GLOW_BERRIES", true));
        this.ENABLED_CRATES.add(builder.define("CHORUS_FRUIT", true));
        this.ENABLED_CRATES.add(builder.define("CARROT", true));
        this.ENABLED_CRATES.add(builder.define("GOLDEN_CARROT", true));
        this.ENABLED_CRATES.add(builder.define("POTATO", true));
        this.ENABLED_CRATES.add(builder.define("BAKED_POTATO", true));
        this.ENABLED_CRATES.add(builder.define("POISONOUS_POTATO", true));
        this.ENABLED_CRATES.add(builder.define("BEETROOT", true));
        this.ENABLED_CRATES.add(builder.define("BEEF", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_BEEF", true));
        this.ENABLED_CRATES.add(builder.define("PORKCHOP", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_PORKCHOP", true));
        this.ENABLED_CRATES.add(builder.define("MUTTON", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_MUTTON", true));
        this.ENABLED_CRATES.add(builder.define("CHICKEN", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_CHICKEN", true));
        this.ENABLED_CRATES.add(builder.define("RABBIT", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_RABBIT", true));
        this.ENABLED_CRATES.add(builder.define("COD", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_COD", true));
        this.ENABLED_CRATES.add(builder.define("SALMON", true));
        this.ENABLED_CRATES.add(builder.define("COOKED_SALMON", true));
        this.ENABLED_CRATES.add(builder.define("TROPICAL_FISH", true));
        this.ENABLED_CRATES.add(builder.define("PUFFERFISH", true));
        this.ENABLED_CRATES.add(builder.define("BREAD", true));
        this.ENABLED_CRATES.add(builder.define("COOKIE", true));
        this.ENABLED_CRATES.add(builder.define("ROTTEN_FLESH", true));
        this.ENABLED_CRATES.add(builder.define("SPIDER_EYE", true));
        this.ENABLED_CRATES.add(builder.define("HONEY_BOTTLE", true));
        this.ENABLED_CRATES.add(builder.define("CHARCOAL", true));
        this.ENABLED_CRATES.add(builder.define("QUARTZ", true));
        this.ENABLED_CRATES.add(builder.define("AMETHYST_SHARD", true));
        this.ENABLED_CRATES.add(builder.define("STICK", true));
        this.ENABLED_CRATES.add(builder.define("FLINT", true));
        this.ENABLED_CRATES.add(builder.define("BONE", true));
        this.ENABLED_CRATES.add(builder.define("STRING", true));
        this.ENABLED_CRATES.add(builder.define("FEATHER", true));
        this.ENABLED_CRATES.add(builder.define("SNOWBALL", true));
        this.ENABLED_CRATES.add(builder.define("EGG", true));
        this.ENABLED_CRATES.add(builder.define("LEATHER", true));
        this.ENABLED_CRATES.add(builder.define("RABBIT_HIDE", true));
        this.ENABLED_CRATES.add(builder.define("HONEYCOMB", true));
        this.ENABLED_CRATES.add(builder.define("INK_SAC", true));
        this.ENABLED_CRATES.add(builder.define("GLOW_INK_SAC", true));
        this.ENABLED_CRATES.add(builder.define("TURTLE_SCUTE", true));
        this.ENABLED_CRATES.add(builder.define("CLAY_BALL", true));
        this.ENABLED_CRATES.add(builder.define("NAUTILUS_SHELL", true));
        this.ENABLED_CRATES.add(builder.define("FIRE_CHARGE", true));
        this.ENABLED_CRATES.add(builder.define("BLAZE_ROD", true));
        this.ENABLED_CRATES.add(builder.define("NETHER_STAR", true));
        this.ENABLED_CRATES.add(builder.define("ENDER_PEARL", true));
        this.ENABLED_CRATES.add(builder.define("ENDER_EYE", true));
        this.ENABLED_CRATES.add(builder.define("SHULKER_SHELL", true));
        this.ENABLED_CRATES.add(builder.define("WHITE_DYE", true));
        this.ENABLED_CRATES.add(builder.define("LIGHT_GRAY_DYE", true));
        this.ENABLED_CRATES.add(builder.define("GRAY_DYE", true));
        this.ENABLED_CRATES.add(builder.define("BLACK_DYE", true));
        this.ENABLED_CRATES.add(builder.define("BROWN_DYE", true));
        this.ENABLED_CRATES.add(builder.define("RED_DYE", true));
        this.ENABLED_CRATES.add(builder.define("ORANGE_DYE", true));
        this.ENABLED_CRATES.add(builder.define("YELLOW_DYE", true));
        this.ENABLED_CRATES.add(builder.define("LIME_DYE", true));
        this.ENABLED_CRATES.add(builder.define("GREEN_DYE", true));
        this.ENABLED_CRATES.add(builder.define("CYAN_DYE", true));
        this.ENABLED_CRATES.add(builder.define("LIGHT_BLUE_DYE", true));
        this.ENABLED_CRATES.add(builder.define("BLUE_DYE", true));
        this.ENABLED_CRATES.add(builder.define("PURPLE_DYE", true));
        this.ENABLED_CRATES.add(builder.define("MAGENTA_DYE", true));
        this.ENABLED_CRATES.add(builder.define("PINK_DYE", true));
        this.ENABLED_CRATES.add(builder.define("PAPER", true));
        this.ENABLED_CRATES.add(builder.define("BOOK", true));
        this.ENABLED_CRATES.add(builder.define("FIREWORK_STAR", true));
        this.ENABLED_CRATES.add(builder.define("GLASS_BOTTLE", true));
        this.ENABLED_CRATES.add(builder.define("GLOWSTONE_DUST", true));
        this.ENABLED_CRATES.add(builder.define("GUNPOWDER", true));
        this.ENABLED_CRATES.add(builder.define("DRAGON_BREATH", true));
        this.ENABLED_CRATES.add(builder.define("FERMENTED_SPIDER_EYE", true));
        this.ENABLED_CRATES.add(builder.define("BLAZE_POWDER", true));
        this.ENABLED_CRATES.add(builder.define("SUGAR", true));
        this.ENABLED_CRATES.add(builder.define("RABBIT_FOOT", true));
        this.ENABLED_CRATES.add(builder.define("GLISTERING_MELON_SLICE", true));
        this.ENABLED_CRATES.add(builder.define("MAGMA_CREAM", true));
        this.ENABLED_CRATES.add(builder.define("GHAST_TEAR", true));
        this.ENABLED_CRATES.add(builder.define("PHANTOM_MEMBRANE", true));
        this.ENABLED_CRATES.add(builder.define("EXPERIENCE_BOTTLE", true));
        this.ENABLED_CRATES.add(builder.define("END_CRYSTAL", true));
        this.ENABLED_CRATES.add(builder.define("ARROW", true));
        this.ENABLED_CRATES.add(builder.define("SPECTRAL_ARROW", true));
        this.ENABLED_CRATES.add(builder.define("NAME_TAG", true));
        this.ENABLED_CRATES.add(builder.define("LEAD", true));
        this.ENABLED_CRATES.add(builder.define("RAIL", true));
        this.ENABLED_CRATES.add(builder.define("POWERED_RAIL", true));
        this.ENABLED_CRATES.add(builder.define("DETECTOR_RAIL", true));
        this.ENABLED_CRATES.add(builder.define("ACTIVATOR_RAIL", true));
        this.ENABLED_CRATES.add(builder.define("REDSTONE_TORCH", true));
        this.ENABLED_CRATES.add(builder.define("REPEATER", true));
        this.ENABLED_CRATES.add(builder.define("COMPARATOR", true));
        this.ENABLED_CRATES.add(builder.define("LIGHTNING_ROD", true));
        this.ENABLED_CRATES.add(builder.define("TORCH", true));
        this.ENABLED_CRATES.add(builder.define("SOUL_TORCH", true));
        this.ENABLED_CRATES.add(builder.define("LANTERN", true));
        this.ENABLED_CRATES.add(builder.define("SOUL_LANTERN", true));
        this.ENABLED_CRATES.add(builder.define("CHAIN", true));
        this.ENABLED_CRATES.add(builder.define("END_ROD", true));
        this.ENABLED_CRATES.add(builder.define("ANVIL", true));
        this.ENABLED_CRATES.add(builder.define("CAMPFIRE", true));
        this.ENABLED_CRATES.add(builder.define("SOUL_CAMPFIRE", true));
        this.ENABLED_CRATES.add(builder.define("ITEM_FRAME", true));
        this.ENABLED_CRATES.add(builder.define("GLOW_ITEM_FRAME", true));
        this.ENABLED_CRATES.add(builder.define("PAINTING", true));
        this.ENABLED_CRATES.add(builder.define("POINTED_DRIPSTONE", true));
        this.ENABLED_CRATES.add(builder.define("OAK_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("SPRUCE_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("BIRCH_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("JUNGLE_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("ACACIA_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("DARK_OAK_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("CHERRY_SAPLING", true));
        this.ENABLED_CRATES.add(builder.define("MANGROVE_PROPAGULE", true));
        this.ENABLED_CRATES.add(builder.define("BROWN_MUSHROOM", true));
        this.ENABLED_CRATES.add(builder.define("RED_MUSHROOM", true));
        this.ENABLED_CRATES.add(builder.define("CRIMSON_FUNGUS", true));
        this.ENABLED_CRATES.add(builder.define("WARPED_FUNGUS", true));
        this.ENABLED_CRATES.add(builder.define("DANDELION", true));
        this.ENABLED_CRATES.add(builder.define("POPPY", true));
        this.ENABLED_CRATES.add(builder.define("BLUE_ORCHID", true));
        this.ENABLED_CRATES.add(builder.define("ALLIUM", true));
        this.ENABLED_CRATES.add(builder.define("AZURE_BLUET", true));
        this.ENABLED_CRATES.add(builder.define("RED_TULIP", true));
        this.ENABLED_CRATES.add(builder.define("ORANGE_TULIP", true));
        this.ENABLED_CRATES.add(builder.define("WHITE_TULIP", true));
        this.ENABLED_CRATES.add(builder.define("PINK_TULIP", true));
        this.ENABLED_CRATES.add(builder.define("OXEYE_DAISY", true));
        this.ENABLED_CRATES.add(builder.define("CORNFLOWER", true));
        this.ENABLED_CRATES.add(builder.define("LILY_OF_THE_VALLEY", true));
        this.ENABLED_CRATES.add(builder.define("SUGAR_CANE", true));
        this.ENABLED_CRATES.add(builder.define("WITHER_ROSE", true));
        this.ENABLED_CRATES.add(builder.define("SUNFLOWER", true));
        this.ENABLED_CRATES.add(builder.define("LILAC", true));
        this.ENABLED_CRATES.add(builder.define("ROSE_BUSH", true));
        this.ENABLED_CRATES.add(builder.define("PEONY", true));
        this.ENABLED_CRATES.add(builder.define("TURTLE_EGG", true));
        this.ENABLED_CRATES.add(builder.define("WHEAT_SEEDS", true));
        this.ENABLED_CRATES.add(builder.define("COCOA_BEANS", true));
        this.ENABLED_CRATES.add(builder.define("PUMPKIN_SEEDS", true));
        this.ENABLED_CRATES.add(builder.define("MELON_SEEDS", true));
        this.ENABLED_CRATES.add(builder.define("BEETROOT_SEEDS", true));
        this.ENABLED_CRATES.add(builder.define("SEAGRASS", true));
        this.ENABLED_CRATES.add(builder.define("KELP", true));
        this.ENABLED_CRATES.add(builder.define("COBWEB", true));
        this.ENABLED_CRATES.add(builder.define("WHITE_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("LIGHT_GRAY_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("GRAY_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("BLACK_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("BROWN_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("RED_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("ORANGE_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("YELLOW_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("LIME_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("GREEN_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("CYAN_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("LIGHT_BLUE_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("BLUE_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("PURPLE_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("MAGENTA_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("PINK_CARPET", true));
        this.ENABLED_CRATES.add(builder.define("VINE", true));
        this.ENABLED_CRATES.add(builder.define("TWISTING_VINES", true));
        this.ENABLED_CRATES.add(builder.define("WEEPING_VINES", true));
        this.ENABLED_CRATES.add(builder.define("GLOW_LICHEN", true));
        this.ENABLED_CRATES.add(builder.define("SCULK_VEIN", true));
    }

    public boolean isBlockEnabled(String blockName) {
        for (ModConfigSpec.BooleanValue value : this.ENABLED_BLOCKS) {
            if (((String)value.getPath().getFirst()).contains("STONE")) {
                return true;
            }
            if (!((String)value.getPath().getFirst()).contains(blockName)) continue;
            return (Boolean)value.get();
        }
        for (ModConfigSpec.BooleanValue value : this.ENABLED_CRATES) {
            if (((String)value.getPath().getFirst()).contains("APPLE")) {
                return true;
            }
            if (!((String)value.getPath().getFirst()).contains(blockName)) continue;
            return (Boolean)value.get();
        }
        return false;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(CBNeoForgeConfig::new);
        CONFIG = (CBNeoForgeConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

