/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.DarkConfig;
import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.buuz135.darkmodeeverywhere.DarkShaderInstance;
import com.buuz135.darkmodeeverywhere.RenderedClassesTracker;
import com.buuz135.darkmodeeverywhere.ShaderConfig;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ClientProxy {
    private final EventExecutor eventExecutor = new DefaultEventExecutor();
    public static Object2BooleanMap<String> BLACKLISTED_ELEMENTS = new Object2BooleanOpenHashMap();
    public static List<String> MODDED_BLACKLIST = new ArrayList<String>();
    public static ShaderConfig CONFIG = new ShaderConfig();
    public static Map<ShaderConfig.ShaderValue, ShaderInstance> TEX_SHADERS = new HashMap<ShaderConfig.ShaderValue, ShaderInstance>();
    public static Map<ShaderConfig.ShaderValue, ShaderInstance> TEX_COLOR_SHADERS = new HashMap<ShaderConfig.ShaderValue, ShaderInstance>();
    private static HashMap<ResourceLocation, Promise<ShaderInstance>> ON_SHADERS_LOADED = new HashMap();
    public static List<ShaderConfig.ShaderValue> SHADER_VALUES = new ArrayList<ShaderConfig.ShaderValue>();
    public static ShaderConfig.ShaderValue SELECTED_SHADER_VALUE = null;

    public ClientProxy(IEventBus modEventBus, ModContainer modContainer) {
        ShaderConfig.load();
        modEventBus.addListener(this::registerAllShaders);
        modEventBus.addListener(this::onConfigReload);
        modEventBus.addListener(this::imcCallback);
        NeoForge.EVENT_BUS.addListener(this::openGui);
    }

    private void registerShaderForLoading(RegisterShadersEvent event, ResourceLocation shaderResourceLocation, VertexFormat format) {
        try {
            DarkModeEverywhere.LOGGER.debug("Registering shader {} for loading", (Object)shaderResourceLocation);
            ON_SHADERS_LOADED.put(shaderResourceLocation, (Promise<ShaderInstance>)this.eventExecutor.newPromise());
            event.registerShader((ShaderInstance)new DarkShaderInstance(event.getResourceProvider(), shaderResourceLocation, format), shaderInstance -> {
                DarkModeEverywhere.LOGGER.debug("Shader {} has loaded, resolving promise", (Object)shaderResourceLocation);
                ON_SHADERS_LOADED.get(shaderResourceLocation).setSuccess(shaderInstance);
            });
        }
        catch (IOException e) {
            DarkModeEverywhere.LOGGER.trace("Failed to register shader", (Throwable)e);
        }
    }

    public void listenForShaderLoaded(RegisterShadersEvent event, ResourceLocation shaderResourceLocation, VertexFormat format, Consumer<ShaderInstance> onLoaded) {
        if (!ON_SHADERS_LOADED.containsKey(shaderResourceLocation)) {
            this.registerShaderForLoading(event, shaderResourceLocation, format);
        }
        Promise<ShaderInstance> onLoadedPromise = ON_SHADERS_LOADED.get(shaderResourceLocation);
        FutureListener listener = shaderInstance -> onLoaded.accept((ShaderInstance)shaderInstance.get());
        onLoadedPromise.addListener((GenericFutureListener)listener);
    }

    @SubscribeEvent
    public void registerAllShaders(RegisterShadersEvent event) {
        TEX_SHADERS = new HashMap<ShaderConfig.ShaderValue, ShaderInstance>();
        TEX_COLOR_SHADERS = new HashMap<ShaderConfig.ShaderValue, ShaderInstance>();
        ON_SHADERS_LOADED = new HashMap();
        SHADER_VALUES = new ArrayList<ShaderConfig.ShaderValue>();
        for (ShaderConfig.ShaderValue shaderValue : CONFIG.getShaders()) {
            SHADER_VALUES.add(shaderValue);
            if (shaderValue == null) continue;
            this.listenForShaderLoaded(event, shaderValue.texShaderLocation, DefaultVertexFormat.POSITION_TEX, shaderInstance -> TEX_SHADERS.put(shaderValue, (ShaderInstance)shaderInstance));
            this.listenForShaderLoaded(event, shaderValue.texColorShaderLocation, DefaultVertexFormat.POSITION_TEX_COLOR, shaderInstance -> TEX_COLOR_SHADERS.put(shaderValue, (ShaderInstance)shaderInstance));
        }
        SELECTED_SHADER_VALUE = SHADER_VALUES.get(CONFIG.getSelectedShaderIndex());
        RenderedClassesTracker.start();
    }

    public static ShaderInstance getSelectedTexShader() {
        return TEX_SHADERS.get(SELECTED_SHADER_VALUE);
    }

    public static ShaderInstance getSelectedTexColorShader() {
        return TEX_COLOR_SHADERS.get(SELECTED_SHADER_VALUE);
    }

    public static ShaderConfig.ShaderValue getSelectedShaderValue() {
        return SELECTED_SHADER_VALUE;
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading reloading) {
        BLACKLISTED_ELEMENTS.clear();
    }

    private static boolean blacklistContains(List<? extends String> blacklist, String elementName) {
        return blacklist.stream().anyMatch(elementName::contains);
    }

    public static boolean isElementNameBlacklisted(String elementName) {
        return BLACKLISTED_ELEMENTS.computeIfAbsent((Object)elementName, name -> {
            DarkModeEverywhere.LOGGER.debug("Considering {} for element blacklist", name);
            RenderedClassesTracker.add(name);
            return ClientProxy.blacklistContains(MODDED_BLACKLIST, name) || ClientProxy.blacklistContains((List)DarkConfig.CLIENT.METHOD_SHADER_BLACKLIST.get(), name);
        });
    }

    @SubscribeEvent
    public void imcCallback(InterModProcessEvent event) {
        event.getIMCStream(string -> string.equals("dme-shaderblacklist")).forEach(imcMessage -> {
            Object patt0$temp = imcMessage.messageSupplier().get();
            if (patt0$temp instanceof String) {
                String classMethodBlacklist = (String)patt0$temp;
                MODDED_BLACKLIST.add(classMethodBlacklist);
            }
        });
    }

    private int getNextShaderValueIndex() {
        if (Screen.hasShiftDown()) {
            return 0;
        }
        int nextShaderIndex = SHADER_VALUES.indexOf(SELECTED_SHADER_VALUE) + 1;
        if (nextShaderIndex >= SHADER_VALUES.size()) {
            return 0;
        }
        return nextShaderIndex;
    }

    private Tooltip getShaderSwitchButtonTooltip() {
        MutableComponent tooltipComponent = (SELECTED_SHADER_VALUE == null ? Component.translatable((String)"gui.darkmodeeverywhere.light_mode") : ClientProxy.SELECTED_SHADER_VALUE.displayName).plainCopy();
        tooltipComponent.append((Component)Component.literal((String)"\n"));
        tooltipComponent.append((Component)Component.translatable((String)"gui.tooltip.darkmodeeverywhere.shader_switch_tooltip").withStyle(ChatFormatting.GRAY));
        return Tooltip.create((Component)tooltipComponent);
    }

    @SubscribeEvent
    public void openGui(ScreenEvent.Init.Pre event) {
        if (event.getScreen() instanceof AbstractContainerScreen || event.getScreen() instanceof TitleScreen && ((Boolean)DarkConfig.CLIENT.SHOW_BUTTON_IN_TITLE_SCREEN.get()).booleanValue()) {
            int x = (Integer)DarkConfig.CLIENT.GUI_BUTTON_X_OFFSET.get();
            int y = (Integer)DarkConfig.CLIENT.GUI_BUTTON_Y_OFFSET.get();
            if (event.getScreen() instanceof TitleScreen) {
                x = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_X_OFFSET.get();
                y = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_Y_OFFSET.get();
            }
            Button.Builder buttonBuilder = Button.builder((Component)Component.translatable((String)"gui.darkmodeeverywhere.dark_mode"), button -> {
                int selectedShaderIndex = this.getNextShaderValueIndex();
                CONFIG.setSelectedShaderIndex(selectedShaderIndex);
                SELECTED_SHADER_VALUE = SHADER_VALUES.get(selectedShaderIndex);
                button.setTooltip(this.getShaderSwitchButtonTooltip());
            });
            buttonBuilder.pos(x, event.getScreen().height - 19 - y);
            buttonBuilder.size(60, 20);
            buttonBuilder.tooltip(this.getShaderSwitchButtonTooltip());
            Button button2 = buttonBuilder.build();
            event.addListener((GuiEventListener)button2);
        }
    }
}

