/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.bbllights.network;

import com.benbenlaw.bbllights.item.BBLLightsDataComponents;
import com.benbenlaw.bbllights.item.LightItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record LightItemPacket(int lightLevel) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LightItemPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"bbllights", (String)"light_item"));
    public static final StreamCodec<FriendlyByteBuf, LightItemPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LightItemPacket::lightLevel, LightItemPacket::new);

    public static void handle(LightItemPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ItemStack item = player.getMainHandItem();
            if (item.getItem() instanceof LightItem) {
                item.set(BBLLightsDataComponents.LIGHT_LEVEL, (Object)payload.lightLevel());
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

