/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block.entity;

import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.block.entity.ImporterBlockEntity;
import com.benbenlaw.routers.block.entity.RoutersBlockEntities;
import com.benbenlaw.routers.config.StartupConfig;
import com.benbenlaw.routers.integration.RoutersCapabilities;
import com.benbenlaw.routers.item.UpgradeItem;
import com.benbenlaw.routers.screen.ExporterMenu;
import com.benbenlaw.routers.screen.util.FluidContainerHelper;
import com.benbenlaw.routers.util.RoutersTags;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExporterBlockEntity
extends BlockEntity
implements MenuProvider,
IAttachmentHolder {
    private List<BlockPos> importerPositions;
    public final ContainerData data;
    private final NonNullList<ItemStack> filters = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
    private final NonNullList<FluidStack> fluidFilters = NonNullList.withSize((int)18, (Object)FluidStack.EMPTY);
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            ExporterBlockEntity.this.setChanged();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.is(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (i == slot || !this.getStackInSlot(i).is(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) continue;
                    return false;
                }
                return true;
            }
            return stack.is(RoutersTags.Items.UPGRADES);
        }
    };
    private int lastRoundRobinIndex = 0;
    private final Map<BlockPos, Map<BlockPos, Double>> particleProgress = new HashMap<BlockPos, Map<BlockPos, Double>>();

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.routers.exporter_block");
    }

    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ExporterMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public ExporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RoutersBlockEntities.EXPORTER_BLOCK_ENTITY.get(), pos, state);
        this.importerPositions = new ArrayList<BlockPos>();
        this.data = new ContainerData(this){

            public int get(int index) {
                return 0;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 0;
            }
        };
    }

    public NonNullList<ItemStack> getFilters() {
        return this.filters;
    }

    public NonNullList<FluidStack> getFluidFilters() {
        return this.fluidFilters;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public void toggleImporter(BlockPos importerPos, Player player) {
        if (this.importerPositions.contains(importerPos)) {
            this.importerPositions.remove(importerPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.routers.exporter.remove_importer"), true);
        } else {
            this.importerPositions.add(importerPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.routers.exporter.add_importer"), true);
        }
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
        this.setChanged();
    }

    public void tick() {
        block32: {
            int maxTransfer;
            ISourceCap targetSourceHandler;
            block33: {
                int canReceive;
                int canExtract;
                int transferAmount;
                ImporterBlockEntity importer;
                ISourceCap importerSource;
                boolean allowByImporter;
                NonNullList<ItemStack> importerFilters;
                ImporterBlockEntity importer2;
                BlockEntity be;
                BlockPos importerPos3;
                boolean allowByExporter;
                if (this.level == null || this.level.isClientSide) {
                    return;
                }
                if (this.level.getGameTime() % 10L == 0L) {
                    this.removeInvalidImporters();
                }
                Direction facing = (Direction)this.getBlockState().getValue((Property)ImporterBlock.FACING);
                BlockPos targetPos = this.worldPosition.relative(facing);
                assert (this.level != null);
                BlockEntity targetBlockEntity = this.level.getBlockEntity(targetPos);
                Direction inputDirection = facing.getOpposite();
                int speedPerOperation = this.getSpeedPerOperation();
                IEnergyStorage targetEnergyStorage = (IEnergyStorage)Capabilities.EnergyStorage.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                if (targetEnergyStorage != null && this.hasUpgrade(RoutersTags.Items.RF_UPGRADES)) {
                    int maxTransfer2 = this.getExtractAmount(RoutersTags.Items.RF_UPGRADES);
                    if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                        if (!this.importerPositions.isEmpty()) {
                            int index = this.lastRoundRobinIndex % this.importerPositions.size();
                            BlockPos importerPos2 = this.importerPositions.get(index);
                            be = this.level.getBlockEntity(importerPos2);
                            if (be instanceof ImporterBlockEntity && (importerEnergy = (importer = (ImporterBlockEntity)be).getEnergyStorage()) != null && (transferAmount = Math.min(canReceive = importerEnergy.receiveEnergy(maxTransfer2, true), canExtract = targetEnergyStorage.extractEnergy(maxTransfer2, true))) > 0) {
                                targetEnergyStorage.extractEnergy(transferAmount, false);
                                importerEnergy.receiveEnergy(transferAmount, false);
                                this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                return;
                            }
                            this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                        }
                    } else {
                        for (BlockPos importerPos2 : this.importerPositions) {
                            be = this.level.getBlockEntity(importerPos2);
                            if (!(be instanceof ImporterBlockEntity) || (importerEnergy = (importer = (ImporterBlockEntity)be).getEnergyStorage()) == null || (transferAmount = Math.min(canReceive = importerEnergy.receiveEnergy(maxTransfer2, true), canExtract = targetEnergyStorage.extractEnergy(maxTransfer2, true))) <= 0) continue;
                            targetEnergyStorage.extractEnergy(transferAmount, false);
                            importerEnergy.receiveEnergy(transferAmount, false);
                            maxTransfer2 -= transferAmount;
                        }
                    }
                }
                if (this.level.getGameTime() % (long)speedPerOperation != 0L || targetBlockEntity == null) break block32;
                IItemHandler targetItemHandler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                IFluidHandler targetFluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                IChemicalHandler targetChemicalHandler = ModList.get().isLoaded("mekanism") ? (IChemicalHandler)RoutersCapabilities.CHEMICAL_HANDLER.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection) : null;
                ISourceCap iSourceCap = targetSourceHandler = ModList.get().isLoaded("ars_nouveau") ? (ISourceCap)CapabilityRegistry.SOURCE_CAPABILITY.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection) : null;
                if (targetItemHandler != null && this.hasUpgrade(RoutersTags.Items.ITEM_UPGRADES)) {
                    NonNullList<ItemStack> exporterFilters = this.getFilters();
                    int maxTransfer3 = this.getExtractAmount(RoutersTags.Items.ITEM_UPGRADES);
                    for (int slot = 0; slot < targetItemHandler.getSlots(); ++slot) {
                        int inserted;
                        ItemStack remainder;
                        IItemHandler importerHandler;
                        ItemStack extracted = targetItemHandler.extractItem(slot, maxTransfer3, true);
                        if (extracted.isEmpty()) continue;
                        boolean bl = allowByExporter = exporterFilters.stream().allMatch(ItemStack::isEmpty) || exporterFilters.stream().anyMatch(f -> !f.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)f, (ItemStack)extracted));
                        if (!allowByExporter) continue;
                        if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                            if (this.importerPositions.isEmpty()) continue;
                            int index = this.lastRoundRobinIndex % this.importerPositions.size();
                            importerPos3 = this.importerPositions.get(index);
                            be = this.level.getBlockEntity(importerPos3);
                            if (be instanceof ImporterBlockEntity && (importerHandler = (importer2 = (ImporterBlockEntity)be).getTargetHandler()) != null) {
                                importerFilters = importer2.getFilters();
                                boolean bl2 = allowByImporter = importerFilters.stream().allMatch(ItemStack::isEmpty) || importerFilters.stream().anyMatch(f -> !f.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)f, (ItemStack)extracted));
                                if (allowByImporter) {
                                    remainder = ItemHandlerHelper.insertItem((IItemHandler)importerHandler, (ItemStack)extracted, (boolean)false);
                                    inserted = extracted.getCount() - remainder.getCount();
                                    if (inserted > 0) {
                                        targetItemHandler.extractItem(slot, inserted, false);
                                        this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                        return;
                                    }
                                }
                            }
                            this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                            continue;
                        }
                        for (BlockPos importerPos3 : this.importerPositions) {
                            be = this.level.getBlockEntity(importerPos3);
                            if (!(be instanceof ImporterBlockEntity) || (importerHandler = (importer2 = (ImporterBlockEntity)be).getTargetHandler()) == null) continue;
                            importerFilters = importer2.getFilters();
                            boolean bl3 = allowByImporter = importerFilters.stream().allMatch(ItemStack::isEmpty) || importerFilters.stream().anyMatch(f -> !f.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)f, (ItemStack)extracted));
                            if (!allowByImporter) continue;
                            remainder = ItemHandlerHelper.insertItem((IItemHandler)importerHandler, (ItemStack)extracted, (boolean)false);
                            inserted = extracted.getCount() - remainder.getCount();
                            if (inserted <= 0) continue;
                            targetItemHandler.extractItem(slot, inserted, false);
                            return;
                        }
                    }
                }
                if (targetFluidHandler != null && this.hasUpgrade(RoutersTags.Items.FLUID_UPGRADES)) {
                    NonNullList<FluidStack> exporterFluidFilters = this.getFluidFilters();
                    for (int slot = 0; slot < targetFluidHandler.getTanks(); ++slot) {
                        int canReceive2;
                        IFluidHandler importerFluid;
                        int maxTransfer4 = this.getExtractAmount(RoutersTags.Items.FLUID_UPGRADES);
                        FluidStack simulatedDrain = targetFluidHandler.drain(maxTransfer4, IFluidHandler.FluidAction.SIMULATE);
                        if (simulatedDrain.isEmpty()) continue;
                        boolean bl = allowByExporter = exporterFluidFilters.stream().allMatch(FluidStack::isEmpty) || exporterFluidFilters.stream().anyMatch(f -> !f.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)simulatedDrain));
                        if (!allowByExporter) continue;
                        if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                            if (this.importerPositions.isEmpty()) continue;
                            int index = this.lastRoundRobinIndex % this.importerPositions.size();
                            importerPos3 = this.importerPositions.get(index);
                            be = this.level.getBlockEntity(importerPos3);
                            if (be instanceof ImporterBlockEntity && (importerFluid = (importer2 = (ImporterBlockEntity)be).getFluidHandler()) != null) {
                                importerFilters = importer2.getFluidFilters();
                                boolean bl4 = allowByImporter = importerFilters.stream().allMatch(FluidStack::isEmpty) || importerFilters.stream().anyMatch(f -> !f.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)simulatedDrain));
                                if (allowByImporter && (canReceive2 = importerFluid.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                                    FluidStack extracted = targetFluidHandler.drain(canReceive2, IFluidHandler.FluidAction.EXECUTE);
                                    importerFluid.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                    return;
                                }
                            }
                            this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                            continue;
                        }
                        for (BlockPos importerPos3 : this.importerPositions) {
                            be = this.level.getBlockEntity(importerPos3);
                            if (!(be instanceof ImporterBlockEntity) || (importerFluid = (importer2 = (ImporterBlockEntity)be).getFluidHandler()) == null || !(allowByImporter = (importerFilters = importer2.getFluidFilters()).stream().allMatch(FluidStack::isEmpty) || importerFilters.stream().anyMatch(f -> !f.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)simulatedDrain))) || (canReceive2 = importerFluid.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                            FluidStack extracted = targetFluidHandler.drain(canReceive2, IFluidHandler.FluidAction.EXECUTE);
                            importerFluid.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                            return;
                        }
                    }
                }
                if (targetChemicalHandler != null && this.hasUpgrade(RoutersTags.Items.CHEMICAL_UPGRADES)) {
                    int maxTransfer5 = this.getExtractAmount(RoutersTags.Items.CHEMICAL_UPGRADES);
                    if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                        if (!this.importerPositions.isEmpty()) {
                            ImporterBlockEntity importer3;
                            IChemicalHandler importerChemical;
                            int index = this.lastRoundRobinIndex % this.importerPositions.size();
                            BlockPos importerPos4 = this.importerPositions.get(index);
                            BlockEntity be2 = this.level.getBlockEntity(importerPos4);
                            if (be2 instanceof ImporterBlockEntity && (importerChemical = (importer3 = (ImporterBlockEntity)be2).getChemicalHandler()) != null) {
                                for (int tank = 0; tank < targetChemicalHandler.getChemicalTanks(); ++tank) {
                                    stackInTank = targetChemicalHandler.getChemicalInTank(tank);
                                    if (stackInTank.isEmpty()) continue;
                                    toExtract = stackInTank.copy();
                                    toExtract.setAmount(Math.min(stackInTank.getAmount(), (long)maxTransfer5));
                                    remainder = importerChemical.insertChemical(toExtract, Action.SIMULATE);
                                    long insertedAmount = toExtract.getAmount() - remainder.getAmount();
                                    if (insertedAmount <= 0L) continue;
                                    ChemicalStack extracted = targetChemicalHandler.extractChemical(insertedAmount, Action.EXECUTE);
                                    importerChemical.insertChemical(extracted, Action.EXECUTE);
                                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                    return;
                                }
                            }
                            this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                        }
                    } else {
                        for (BlockPos importerPos5 : this.importerPositions) {
                            ImporterBlockEntity importer4;
                            IChemicalHandler importerChemical;
                            BlockEntity be3 = this.level.getBlockEntity(importerPos5);
                            if (!(be3 instanceof ImporterBlockEntity) || (importerChemical = (importer4 = (ImporterBlockEntity)be3).getChemicalHandler()) == null) continue;
                            for (int tank = 0; tank < targetChemicalHandler.getChemicalTanks(); ++tank) {
                                stackInTank = targetChemicalHandler.getChemicalInTank(tank);
                                if (stackInTank.isEmpty()) continue;
                                toExtract = stackInTank.copy();
                                toExtract.setAmount(Math.min(stackInTank.getAmount(), (long)maxTransfer5));
                                remainder = importerChemical.insertChemical(toExtract, Action.SIMULATE);
                                long insertedAmount = toExtract.getAmount() - remainder.getAmount();
                                if (insertedAmount <= 0L) continue;
                                ChemicalStack extracted = targetChemicalHandler.extractChemical(insertedAmount, Action.EXECUTE);
                                importerChemical.insertChemical(extracted, Action.EXECUTE);
                                return;
                            }
                        }
                    }
                }
                if (targetSourceHandler == null || !this.hasUpgrade(RoutersTags.Items.SOURCE_UPGRADES)) break block32;
                maxTransfer = this.getExtractAmount(RoutersTags.Items.SOURCE_UPGRADES);
                if (!this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) break block33;
                if (this.importerPositions.isEmpty()) break block32;
                int index = this.lastRoundRobinIndex % this.importerPositions.size();
                BlockPos importerPos6 = this.importerPositions.get(index);
                BlockEntity be4 = this.level.getBlockEntity(importerPos6);
                if (be4 instanceof ImporterBlockEntity && (importerSource = (importer = (ImporterBlockEntity)be4).getSourceHandler()) != null && (transferAmount = Math.min(canExtract = targetSourceHandler.extractSource(maxTransfer, true), canReceive = importerSource.receiveSource(canExtract, true))) > 0) {
                    targetSourceHandler.extractSource(transferAmount, false);
                    importerSource.receiveSource(transferAmount, false);
                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                    return;
                }
                this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                break block32;
            }
            for (BlockPos importerPos : this.importerPositions) {
                int canReceive;
                int canExtract;
                int transferAmount;
                ImporterBlockEntity importer;
                ISourceCap importerSource;
                BlockEntity be = this.level.getBlockEntity(importerPos);
                if (!(be instanceof ImporterBlockEntity) || (importerSource = (importer = (ImporterBlockEntity)be).getSourceHandler()) == null || (transferAmount = Math.min(canExtract = targetSourceHandler.extractSource(maxTransfer, true), canReceive = importerSource.receiveSource(canExtract, true))) <= 0) continue;
                targetSourceHandler.extractSource(transferAmount, false);
                importerSource.receiveSource(transferAmount, false);
                if ((maxTransfer -= transferAmount) > 0) continue;
                break;
            }
        }
    }

    public int getSpeedPerOperation() {
        if (this.hasUpgrade(RoutersTags.Items.SPEED_UPGRADES)) {
            int speed = 0;
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                Item item;
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty() || !stack.is(RoutersTags.Items.SPEED_UPGRADES) || !((item = stack.getItem()) instanceof UpgradeItem)) continue;
                UpgradeItem upgradeItem = (UpgradeItem)item;
                speed += upgradeItem.getExtractAmount();
                break;
            }
            return speed;
        }
        return (Integer)StartupConfig.defaultSpeedPerOperation.get();
    }

    public boolean hasUpgrade(TagKey<Item> tag) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty() || !stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public int getExtractAmount(TagKey<Item> tag) {
        int total = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            Item item;
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty() || !stack.is(tag) || !((item = stack.getItem()) instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            total += upgradeItem.getExtractAmount();
        }
        return total;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.filters, (HolderLookup.Provider)provider);
        FluidContainerHelper.saveAllFluids(compoundTag, this.fluidFilters, true, provider);
        if (this.importerPositions != null && !this.importerPositions.isEmpty()) {
            ListTag listTag = new ListTag();
            for (BlockPos pos : this.importerPositions) {
                CompoundTag posTag = new CompoundTag();
                posTag.putInt("x", pos.getX());
                posTag.putInt("y", pos.getY());
                posTag.putInt("z", pos.getZ());
                listTag.add((Object)posTag);
            }
            compoundTag.put("ImporterPositions", (Tag)listTag);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return this.saveWithoutMetadata(p_323910_);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.filters, (HolderLookup.Provider)provider);
        FluidContainerHelper.loadAllFluids(compoundTag, this.fluidFilters, provider);
        this.importerPositions = new ArrayList<BlockPos>();
        if (compoundTag.contains("ImporterPositions")) {
            ListTag listTag = compoundTag.getList("ImporterPositions", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag posTag = listTag.getCompound(i);
                BlockPos pos = new BlockPos(posTag.getInt("x"), posTag.getInt("y"), posTag.getInt("z"));
                this.importerPositions.add(pos);
            }
        }
    }

    public List<BlockPos> getImporterPositions() {
        return this.importerPositions;
    }

    public void removeInvalidImporters() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.importerPositions.removeIf(pos -> {
            BlockEntity be = this.level.getBlockEntity(pos);
            return !(be instanceof ImporterBlockEntity);
        });
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }
}

