/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public final class FluidHelper {
    public static FluidStack getFluidFromStack(ItemStack stack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return handler == null ? FluidStack.EMPTY : handler.getFluidInTank(0);
    }

    public static int getFluidAmount(ItemStack stack) {
        FluidStack fluid = FluidHelper.getFluidFromStack(stack);
        return fluid == null ? 0 : fluid.getAmount();
    }

    public static ItemStack getFilledBucket(FluidStack fluid, Item bucket, int capacity) {
        if (BuiltInRegistries.FLUID.containsValue((Object)fluid.getFluid())) {
            ItemStack filledBucket = new ItemStack((ItemLike)bucket);
            FluidStack fluidContents = fluid.copyWithAmount(capacity);
            IFluidHandlerItem tank = (IFluidHandlerItem)filledBucket.getCapability(Capabilities.FluidHandler.ITEM);
            if (tank != null) {
                tank.fill(fluidContents, IFluidHandler.FluidAction.EXECUTE);
            }
            return filledBucket;
        }
        return ItemStack.EMPTY;
    }

    public static int toBuckets(int i) {
        return i - i % 1000;
    }
}

