/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ShapedRecipePatternCodecs;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class ShapedEnderCrafterRecipe
implements IEnderCrafterRecipe {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final int craftingTime;

    public ShapedEnderCrafterRecipe(ShapedRecipePattern pattern, ItemStack result, int craftingTime) {
        this.pattern = pattern;
        this.result = result;
        this.craftingTime = craftingTime;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        return this.pattern.matches(inventory);
    }

    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPED_ENDER_CRAFTER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.ENDER_CRAFTER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    @Override
    public int getCraftingTime() {
        return this.craftingTime;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedEnderCrafterRecipe> {
        public static final MapCodec<ShapedEnderCrafterRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ShapedRecipePatternCodecs.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("crafting_time", (Object)((Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get())).forGetter(recipe -> recipe.craftingTime)).apply((Applicative)builder, ShapedEnderCrafterRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedEnderCrafterRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedEnderCrafterRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedEnderCrafterRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedEnderCrafterRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int craftingTime = buffer.readVarInt();
            return new ShapedEnderCrafterRecipe(pattern, result, craftingTime);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedEnderCrafterRecipe recipe) {
            buffer.writeVarInt(recipe.pattern.width());
            buffer.writeVarInt(recipe.pattern.height());
            for (Ingredient ingredient : recipe.pattern.ingredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.craftingTime);
        }
    }
}

