/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FluxCraftingCategory
implements IRecipeCategory<IFluxCrafterRecipe> {
    private static final ResourceLocation TEXTURE = ExtendedCrafting.resource("textures/jei/flux_crafting.png");
    public static final RecipeType<IFluxCrafterRecipe> RECIPE_TYPE = RecipeType.create((String)"extendedcrafting", (String)"flux_crafting", IFluxCrafterRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FluxCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 149, 78);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FLUX_CRAFTER.get()));
    }

    public RecipeType<IFluxCrafterRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.flux_crafting").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void getTooltip(ITooltipBuilder tooltip, IFluxCrafterRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 1.0 && mouseX < 14.0 && mouseY > 1.0 && mouseY < 78.0) {
            tooltip.add((FormattedText)Formatting.energy((Object)recipe.getPowerRequired()));
            tooltip.add((FormattedText)ModTooltips.PER_ALTERNATOR.args(new Object[]{Formatting.energyPerTick((Object)recipe.getPowerRate())}).color(ChatFormatting.WHITE).build());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFluxCrafterRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = recipe.getIngredients();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (recipe instanceof ShapedFluxCrafterRecipe) {
            ShapedFluxCrafterRecipe shaped = (ShapedFluxCrafterRecipe)recipe;
            int stackIndex = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 26, i * 18 + 13);
                    if (i >= shaped.getHeight() || j >= shaped.getWidth()) continue;
                    slot.addIngredients((Ingredient)inputs.get(stackIndex++));
                }
            }
        } else if (recipe instanceof ShapelessFluxCrafterRecipe) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = j + i * 3;
                    if (index >= inputs.size()) continue;
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 26, i * 18 + 13).addIngredients((Ingredient)inputs.get(index));
                }
            }
            builder.setShapeless();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 31).addItemStack(output);
        builder.moveRecipeTransferButton(134, 63);
    }
}

